/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.algorithms;

import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.Container;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.OutputIterator;
import com.objectspace.jgl.algorithms.Copying;
import com.objectspace.jgl.algorithms.xHashComparator;

public final class SetOperations {
    public static boolean includes(Container container, Container container2, BinaryPredicate binaryPredicate) {
        return SetOperations.includes(container.start(), container.finish(), container2.start(), container2.finish(), binaryPredicate);
    }

    public static boolean includes(InputIterator inputIterator, InputIterator inputIterator2, InputIterator inputIterator3, InputIterator inputIterator4) {
        return SetOperations.includes(inputIterator, inputIterator2, inputIterator3, inputIterator4, new xHashComparator());
    }

    public static boolean includes(InputIterator inputIterator, InputIterator inputIterator2, InputIterator inputIterator3, InputIterator inputIterator4, BinaryPredicate binaryPredicate) {
        if (!inputIterator.isCompatibleWith(inputIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        if (!inputIterator3.isCompatibleWith(inputIterator4)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        InputIterator inputIterator5 = (InputIterator)inputIterator.clone();
        InputIterator inputIterator6 = (InputIterator)inputIterator3.clone();
        while (!inputIterator5.equals(inputIterator2) && !inputIterator6.equals(inputIterator4)) {
            if (binaryPredicate.execute(inputIterator6.get(), inputIterator5.get())) {
                return false;
            }
            if (binaryPredicate.execute(inputIterator5.get(), inputIterator6.get())) {
                inputIterator5.advance();
                continue;
            }
            inputIterator5.advance();
            inputIterator6.advance();
        }
        return inputIterator6.equals(inputIterator4);
    }

    public static OutputIterator setDifference(Container container, Container container2, OutputIterator outputIterator, BinaryPredicate binaryPredicate) {
        return SetOperations.setDifference(container.start(), container.finish(), container2.start(), container2.finish(), outputIterator, binaryPredicate);
    }

    public static OutputIterator setDifference(InputIterator inputIterator, InputIterator inputIterator2, InputIterator inputIterator3, InputIterator inputIterator4, OutputIterator outputIterator) {
        return SetOperations.setDifference(inputIterator, inputIterator2, inputIterator3, inputIterator4, outputIterator, new xHashComparator());
    }

    public static OutputIterator setDifference(InputIterator inputIterator, InputIterator inputIterator2, InputIterator inputIterator3, InputIterator inputIterator4, OutputIterator outputIterator, BinaryPredicate binaryPredicate) {
        if (!inputIterator.isCompatibleWith(inputIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        if (!inputIterator3.isCompatibleWith(inputIterator4)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        InputIterator inputIterator5 = (InputIterator)inputIterator.clone();
        InputIterator inputIterator6 = (InputIterator)inputIterator3.clone();
        OutputIterator outputIterator2 = (OutputIterator)outputIterator.clone();
        while (!inputIterator5.equals(inputIterator2) && !inputIterator6.equals(inputIterator4)) {
            if (binaryPredicate.execute(inputIterator5.get(), inputIterator6.get())) {
                outputIterator2.put(inputIterator5.get());
                outputIterator2.advance();
                inputIterator5.advance();
                continue;
            }
            if (binaryPredicate.execute(inputIterator6.get(), inputIterator5.get())) {
                inputIterator6.advance();
                continue;
            }
            inputIterator5.advance();
            inputIterator6.advance();
        }
        return Copying.copy(inputIterator5, inputIterator2, outputIterator2);
    }

    public static OutputIterator setIntersection(Container container, Container container2, OutputIterator outputIterator, BinaryPredicate binaryPredicate) {
        return SetOperations.setIntersection(container.start(), container.finish(), container2.start(), container2.finish(), outputIterator, binaryPredicate);
    }

    public static OutputIterator setIntersection(InputIterator inputIterator, InputIterator inputIterator2, InputIterator inputIterator3, InputIterator inputIterator4, OutputIterator outputIterator) {
        return SetOperations.setIntersection(inputIterator, inputIterator2, inputIterator3, inputIterator4, outputIterator, new xHashComparator());
    }

    public static OutputIterator setIntersection(InputIterator inputIterator, InputIterator inputIterator2, InputIterator inputIterator3, InputIterator inputIterator4, OutputIterator outputIterator, BinaryPredicate binaryPredicate) {
        if (!inputIterator.isCompatibleWith(inputIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        if (!inputIterator3.isCompatibleWith(inputIterator4)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        InputIterator inputIterator5 = (InputIterator)inputIterator.clone();
        InputIterator inputIterator6 = (InputIterator)inputIterator3.clone();
        OutputIterator outputIterator2 = (OutputIterator)outputIterator.clone();
        while (!inputIterator5.equals(inputIterator2) && !inputIterator6.equals(inputIterator4)) {
            if (binaryPredicate.execute(inputIterator5.get(), inputIterator6.get())) {
                inputIterator5.advance();
                continue;
            }
            if (binaryPredicate.execute(inputIterator6.get(), inputIterator5.get())) {
                inputIterator6.advance();
                continue;
            }
            outputIterator2.put(inputIterator5.get());
            outputIterator2.advance();
            inputIterator5.advance();
            inputIterator6.advance();
        }
        return outputIterator2;
    }

    public static OutputIterator setSymmetricDifference(Container container, Container container2, OutputIterator outputIterator, BinaryPredicate binaryPredicate) {
        return SetOperations.setSymmetricDifference(container.start(), container.finish(), container2.start(), container2.finish(), outputIterator, binaryPredicate);
    }

    public static OutputIterator setSymmetricDifference(InputIterator inputIterator, InputIterator inputIterator2, InputIterator inputIterator3, InputIterator inputIterator4, OutputIterator outputIterator) {
        return SetOperations.setSymmetricDifference(inputIterator, inputIterator2, inputIterator3, inputIterator4, outputIterator, new xHashComparator());
    }

    public static OutputIterator setSymmetricDifference(InputIterator inputIterator, InputIterator inputIterator2, InputIterator inputIterator3, InputIterator inputIterator4, OutputIterator outputIterator, BinaryPredicate binaryPredicate) {
        if (!inputIterator.isCompatibleWith(inputIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        if (!inputIterator3.isCompatibleWith(inputIterator4)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        InputIterator inputIterator5 = (InputIterator)inputIterator.clone();
        InputIterator inputIterator6 = (InputIterator)inputIterator3.clone();
        OutputIterator outputIterator2 = (OutputIterator)outputIterator.clone();
        while (!inputIterator5.equals(inputIterator2) && !inputIterator6.equals(inputIterator4)) {
            if (binaryPredicate.execute(inputIterator5.get(), inputIterator6.get())) {
                outputIterator2.put(inputIterator5.get());
                outputIterator2.advance();
                inputIterator5.advance();
                continue;
            }
            if (binaryPredicate.execute(inputIterator6.get(), inputIterator5.get())) {
                outputIterator2.put(inputIterator6.get());
                outputIterator2.advance();
                inputIterator6.advance();
                continue;
            }
            inputIterator5.advance();
            inputIterator6.advance();
        }
        return Copying.copy(inputIterator6, inputIterator4, Copying.copy(inputIterator5, inputIterator2, outputIterator2));
    }

    public static OutputIterator setUnion(Container container, Container container2, OutputIterator outputIterator, BinaryPredicate binaryPredicate) {
        return SetOperations.setUnion(container.start(), container.finish(), container2.start(), container2.finish(), outputIterator, binaryPredicate);
    }

    public static OutputIterator setUnion(InputIterator inputIterator, InputIterator inputIterator2, InputIterator inputIterator3, InputIterator inputIterator4, OutputIterator outputIterator) {
        return SetOperations.setUnion(inputIterator, inputIterator2, inputIterator3, inputIterator4, outputIterator, new xHashComparator());
    }

    public static OutputIterator setUnion(InputIterator inputIterator, InputIterator inputIterator2, InputIterator inputIterator3, InputIterator inputIterator4, OutputIterator outputIterator, BinaryPredicate binaryPredicate) {
        if (!inputIterator.isCompatibleWith(inputIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        if (!inputIterator3.isCompatibleWith(inputIterator4)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        InputIterator inputIterator5 = (InputIterator)inputIterator.clone();
        InputIterator inputIterator6 = (InputIterator)inputIterator3.clone();
        OutputIterator outputIterator2 = (OutputIterator)outputIterator.clone();
        while (!inputIterator5.equals(inputIterator2) && !inputIterator6.equals(inputIterator4)) {
            if (binaryPredicate.execute(inputIterator5.get(), inputIterator6.get())) {
                outputIterator2.put(inputIterator5.get());
                outputIterator2.advance();
                inputIterator5.advance();
                continue;
            }
            if (binaryPredicate.execute(inputIterator6.get(), inputIterator5.get())) {
                outputIterator2.put(inputIterator6.get());
                outputIterator2.advance();
                inputIterator6.advance();
                continue;
            }
            outputIterator2.put(inputIterator5.get());
            outputIterator2.advance();
            inputIterator5.advance();
            inputIterator6.advance();
        }
        return Copying.copy(inputIterator6, inputIterator4, Copying.copy(inputIterator5, inputIterator2, outputIterator2));
    }
}

