/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.algorithms;

import com.objectspace.jgl.BidirectionalIterator;
import com.objectspace.jgl.Container;
import com.objectspace.jgl.OutputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.algorithms.Swapping;
import com.objectspace.jgl.util.InsertIterator;

public final class Reversing {
    private Reversing() {
    }

    public static void reverse(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2) {
        if (!bidirectionalIterator.isCompatibleWith(bidirectionalIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        if (!(bidirectionalIterator.getContainer() instanceof Sequence)) {
            throw new IllegalArgumentException("iterator containers must be a Sequence");
        }
        if (bidirectionalIterator instanceof RandomAccessIterator) {
            RandomAccessIterator randomAccessIterator = (RandomAccessIterator)bidirectionalIterator.clone();
            RandomAccessIterator randomAccessIterator2 = (RandomAccessIterator)bidirectionalIterator2.clone();
            while (randomAccessIterator.less(randomAccessIterator2)) {
                randomAccessIterator2.retreat();
                Swapping.iterSwap(randomAccessIterator, randomAccessIterator2);
                randomAccessIterator.advance();
            }
        } else {
            BidirectionalIterator bidirectionalIterator3 = (BidirectionalIterator)bidirectionalIterator.clone();
            BidirectionalIterator bidirectionalIterator4 = (BidirectionalIterator)bidirectionalIterator2.clone();
            while (true) {
                if (bidirectionalIterator3.equals(bidirectionalIterator4)) {
                    return;
                }
                bidirectionalIterator4.retreat();
                if (bidirectionalIterator3.equals(bidirectionalIterator4)) {
                    return;
                }
                Swapping.iterSwap(bidirectionalIterator3, bidirectionalIterator4);
                bidirectionalIterator3.advance();
            }
        }
    }

    public static void reverse(Container container) {
        Reversing.reverse((BidirectionalIterator)container.start(), (BidirectionalIterator)container.finish());
    }

    public static OutputIterator reverseCopy(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2, OutputIterator outputIterator) {
        if (!bidirectionalIterator.isCompatibleWith(bidirectionalIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        if (!(bidirectionalIterator.getContainer() instanceof Sequence)) {
            throw new IllegalArgumentException("iterator containers must be a Sequence");
        }
        BidirectionalIterator bidirectionalIterator3 = (BidirectionalIterator)bidirectionalIterator2.clone();
        OutputIterator outputIterator2 = (OutputIterator)outputIterator.clone();
        while (!bidirectionalIterator3.equals(bidirectionalIterator)) {
            bidirectionalIterator3.retreat();
            outputIterator2.put(bidirectionalIterator3.get());
            outputIterator2.advance();
        }
        return outputIterator2;
    }

    public static void reverseCopy(Container container, Container container2) {
        Reversing.reverseCopy((BidirectionalIterator)container.start(), (BidirectionalIterator)container.finish(), new InsertIterator(container2));
    }

    public static OutputIterator reverseCopy(Container container, OutputIterator outputIterator) {
        return Reversing.reverseCopy((BidirectionalIterator)container.start(), (BidirectionalIterator)container.finish(), outputIterator);
    }
}

