/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.algorithms;

import com.objectspace.jgl.BidirectionalIterator;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.Container;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.algorithms.Reversing;
import com.objectspace.jgl.algorithms.Swapping;

public final class Permuting {
    private Permuting() {
    }

    public static boolean nextPermutation(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2, BinaryPredicate binaryPredicate) {
        if (!bidirectionalIterator.isCompatibleWith(bidirectionalIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        if (!(bidirectionalIterator.getContainer() instanceof Sequence)) {
            throw new IllegalArgumentException("iterator containers must be a Sequence");
        }
        BidirectionalIterator bidirectionalIterator3 = (BidirectionalIterator)bidirectionalIterator.clone();
        if (bidirectionalIterator3.equals(bidirectionalIterator2)) {
            return false;
        }
        bidirectionalIterator3.advance();
        if (bidirectionalIterator3.equals(bidirectionalIterator2)) {
            return false;
        }
        bidirectionalIterator3 = (BidirectionalIterator)bidirectionalIterator2.clone();
        bidirectionalIterator3.retreat();
        do {
            BidirectionalIterator bidirectionalIterator4 = (BidirectionalIterator)bidirectionalIterator3.clone();
            bidirectionalIterator3.retreat();
            if (!binaryPredicate.execute(bidirectionalIterator3.get(), bidirectionalIterator4.get())) continue;
            BidirectionalIterator bidirectionalIterator5 = (BidirectionalIterator)bidirectionalIterator2.clone();
            bidirectionalIterator5.retreat();
            while (!binaryPredicate.execute(bidirectionalIterator3.get(), bidirectionalIterator5.get())) {
                bidirectionalIterator5.retreat();
            }
            Swapping.iterSwap(bidirectionalIterator3, bidirectionalIterator5);
            Reversing.reverse(bidirectionalIterator4, bidirectionalIterator2);
            return true;
        } while (!bidirectionalIterator3.equals(bidirectionalIterator));
        Reversing.reverse(bidirectionalIterator, bidirectionalIterator2);
        return false;
    }

    public static boolean nextPermutation(Container container, BinaryPredicate binaryPredicate) {
        return Permuting.nextPermutation((BidirectionalIterator)container.start(), (BidirectionalIterator)container.finish(), binaryPredicate);
    }

    public static boolean prevPermutation(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2, BinaryPredicate binaryPredicate) {
        if (!bidirectionalIterator.isCompatibleWith(bidirectionalIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        if (!(bidirectionalIterator.getContainer() instanceof Sequence)) {
            throw new IllegalArgumentException("iterator containers must be a Sequence");
        }
        BidirectionalIterator bidirectionalIterator3 = (BidirectionalIterator)bidirectionalIterator.clone();
        if (bidirectionalIterator3.equals(bidirectionalIterator2)) {
            return false;
        }
        bidirectionalIterator3.advance();
        if (bidirectionalIterator3.equals(bidirectionalIterator2)) {
            return false;
        }
        bidirectionalIterator3 = (BidirectionalIterator)bidirectionalIterator2.clone();
        bidirectionalIterator3.retreat();
        do {
            BidirectionalIterator bidirectionalIterator4 = (BidirectionalIterator)bidirectionalIterator3.clone();
            bidirectionalIterator3.retreat();
            if (!binaryPredicate.execute(bidirectionalIterator4.get(), bidirectionalIterator3.get())) continue;
            BidirectionalIterator bidirectionalIterator5 = (BidirectionalIterator)bidirectionalIterator2.clone();
            bidirectionalIterator5.retreat();
            while (!binaryPredicate.execute(bidirectionalIterator5.get(), bidirectionalIterator3.get())) {
                bidirectionalIterator5.retreat();
            }
            Swapping.iterSwap(bidirectionalIterator3, bidirectionalIterator5);
            Reversing.reverse(bidirectionalIterator4, bidirectionalIterator2);
            return true;
        } while (!bidirectionalIterator3.equals(bidirectionalIterator));
        Reversing.reverse(bidirectionalIterator, bidirectionalIterator2);
        return false;
    }

    public static boolean prevPermutation(Container container, BinaryPredicate binaryPredicate) {
        return Permuting.prevPermutation((BidirectionalIterator)container.start(), (BidirectionalIterator)container.finish(), binaryPredicate);
    }
}

