/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.algorithms;

import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.Container;
import com.objectspace.jgl.DList;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.OutputIterator;
import com.objectspace.jgl.UnaryPredicate;
import com.objectspace.jgl.algorithms.Finding;
import com.objectspace.jgl.algorithms.Removing;
import com.objectspace.jgl.algorithms.UnaryNot;
import com.objectspace.jgl.algorithms.xEqualTo;
import com.objectspace.jgl.util.InsertIterator;

public final class Filtering {
    private Filtering() {
    }

    public static Container reject(Container container, UnaryPredicate unaryPredicate) {
        Container container2 = (Container)container.clone();
        try {
            container2.remove(Removing.removeIf(container2.start(), container2.finish(), unaryPredicate), container2.finish());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Filtering.select(container.start(), container.finish(), new UnaryNot(unaryPredicate), container2);
        }
        return container2;
    }

    public static Container reject(InputIterator inputIterator, InputIterator inputIterator2, UnaryPredicate unaryPredicate) {
        return Filtering.select(inputIterator, inputIterator2, new UnaryNot(unaryPredicate));
    }

    public static Container select(Container container, UnaryPredicate unaryPredicate) {
        Container container2 = (Container)container.clone();
        try {
            container2.remove(Removing.removeIf(container2.start(), container2.finish(), new UnaryNot(unaryPredicate)), container2.finish());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Filtering.select(container.start(), container.finish(), unaryPredicate, container2);
        }
        return container2;
    }

    public static Container select(InputIterator inputIterator, InputIterator inputIterator2, UnaryPredicate unaryPredicate) {
        Container container = inputIterator instanceof ForwardIterator ? (Container)((ForwardIterator)inputIterator).getContainer().clone() : new DList();
        return Filtering.select(inputIterator, inputIterator2, unaryPredicate, container);
    }

    private static Container select(InputIterator inputIterator, InputIterator inputIterator2, UnaryPredicate unaryPredicate, Container container) {
        if (!inputIterator.isCompatibleWith(inputIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        container.clear();
        InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
        while (!inputIterator3.equals(inputIterator2)) {
            Object e = inputIterator3.nextElement();
            if (!unaryPredicate.execute(e)) continue;
            container.add(e);
        }
        return container;
    }

    public static OutputIterator unique(Container container) {
        return Filtering.unique(container.start(), container.finish(), new xEqualTo());
    }

    public static OutputIterator unique(Container container, BinaryPredicate binaryPredicate) {
        return Filtering.unique(container.start(), container.finish(), binaryPredicate);
    }

    public static OutputIterator unique(ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        return Filtering.unique(forwardIterator, forwardIterator2, new xEqualTo());
    }

    public static OutputIterator unique(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, BinaryPredicate binaryPredicate) {
        forwardIterator = (ForwardIterator)Finding.adjacentFind(forwardIterator, forwardIterator2, binaryPredicate);
        return Filtering.uniqueCopy(forwardIterator, forwardIterator2, forwardIterator, binaryPredicate);
    }

    public static void uniqueCopy(Container container, Container container2) {
        Filtering.uniqueCopy(container.start(), container.finish(), new InsertIterator(container2), new xEqualTo());
    }

    public static void uniqueCopy(Container container, Container container2, BinaryPredicate binaryPredicate) {
        Filtering.uniqueCopy(container.start(), container.finish(), new InsertIterator(container2), binaryPredicate);
    }

    public static OutputIterator uniqueCopy(Container container, OutputIterator outputIterator) {
        return Filtering.uniqueCopy(container.start(), container.finish(), outputIterator, new xEqualTo());
    }

    public static OutputIterator uniqueCopy(Container container, OutputIterator outputIterator, BinaryPredicate binaryPredicate) {
        return Filtering.uniqueCopy(container.start(), container.finish(), outputIterator, binaryPredicate);
    }

    public static OutputIterator uniqueCopy(InputIterator inputIterator, InputIterator inputIterator2, OutputIterator outputIterator) {
        return Filtering.uniqueCopy(inputIterator, inputIterator2, outputIterator, new xEqualTo());
    }

    public static OutputIterator uniqueCopy(InputIterator inputIterator, InputIterator inputIterator2, OutputIterator outputIterator, BinaryPredicate binaryPredicate) {
        if (!inputIterator.isCompatibleWith(inputIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
        if (inputIterator3.equals(inputIterator2)) {
            return (OutputIterator)outputIterator.clone();
        }
        if (outputIterator instanceof ForwardIterator) {
            ForwardIterator forwardIterator = (ForwardIterator)outputIterator.clone();
            forwardIterator.put(inputIterator3.nextElement());
            while (!inputIterator3.equals(inputIterator2)) {
                if (!binaryPredicate.execute(forwardIterator.get(), inputIterator3.get())) {
                    forwardIterator.advance();
                    forwardIterator.put(inputIterator3.get());
                }
                inputIterator3.advance();
            }
            forwardIterator.advance();
            return forwardIterator;
        }
        Object object = inputIterator3.get();
        OutputIterator outputIterator2 = (OutputIterator)outputIterator.clone();
        outputIterator2.put(object);
        inputIterator3.advance();
        while (!inputIterator3.equals(inputIterator2)) {
            if (!binaryPredicate.execute(object, inputIterator3.get())) {
                object = inputIterator3.get();
                outputIterator2.advance();
                outputIterator2.put(object);
            }
            inputIterator3.advance();
        }
        outputIterator2.advance();
        return outputIterator2;
    }
}

