/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.adapters.VectorArray;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Vector;

public final class VectorIterator
implements RandomAccessIterator,
Serializable {
    VectorArray buffer;
    int index;
    static final long serialVersionUID = 6819025880408038288L;

    public VectorIterator() {
        this(new Vector(), 0);
    }

    public VectorIterator(VectorArray vectorArray, int n) {
        this.buffer = vectorArray;
        this.index = n;
    }

    public VectorIterator(VectorIterator vectorIterator) {
        this.buffer = vectorIterator.buffer;
        this.index = vectorIterator.index;
    }

    public VectorIterator(Vector vector, int n) {
        this(new VectorArray(vector), n);
    }

    public void advance() {
        ++this.index;
    }

    public void advance(int n) {
        this.index += n;
    }

    public boolean atBegin() {
        return this.index == 0;
    }

    public boolean atEnd() {
        return this.index == this.buffer.array.size();
    }

    public static VectorIterator begin(Vector vector) {
        return new VectorIterator(vector, 0);
    }

    public Object clone() {
        return new VectorIterator(this);
    }

    public int distance(ForwardIterator forwardIterator) {
        if (!this.isCompatibleWith(forwardIterator)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((VectorIterator)forwardIterator).index - this.index;
    }

    public static VectorIterator end(Vector vector) {
        return new VectorIterator(vector, vector.size());
    }

    public boolean equals(VectorIterator vectorIterator) {
        return vectorIterator.index == this.index && vectorIterator.buffer == this.buffer;
    }

    public boolean equals(Object object) {
        return object instanceof VectorIterator && this.equals((VectorIterator)object);
    }

    public Object get() {
        return this.get(0);
    }

    public Object get(int n) {
        return this.buffer.array.elementAt(this.index + n);
    }

    public Container getContainer() {
        return this.buffer;
    }

    public boolean hasMoreElements() {
        return this.index < this.buffer.array.size();
    }

    public int index() {
        return this.index;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof VectorIterator && this.buffer.array == ((VectorIterator)inputIterator).buffer.array;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.index < ((VectorIterator)randomAccessIterator).index;
    }

    public Object nextElement() {
        try {
            Object object = this.get();
            this.advance();
            return object;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("VectorIterator");
        }
    }

    public void put(int n, Object object) {
        this.buffer.array.setElementAt(object, this.index + n);
    }

    public void put(Object object) {
        this.put(0, object);
    }

    public void retreat() {
        --this.index;
    }

    public void retreat(int n) {
        this.index -= n;
    }
}

