/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.adapters.ShortArray;
import com.objectspace.jgl.adapters.ShortBuffer;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class ShortIterator
implements RandomAccessIterator,
Serializable {
    short[] buffer;
    Container original;
    int index;
    static final long serialVersionUID = -9054943108350905562L;

    public ShortIterator() {
        this(new ShortArray(), 0);
    }

    public ShortIterator(short[] sArray, int n) {
        this(new ShortArray(sArray), n);
    }

    public ShortIterator(ShortArray shortArray, int n) {
        this.buffer = shortArray.array;
        this.original = shortArray;
        this.index = n;
    }

    public ShortIterator(ShortBuffer shortBuffer, int n) {
        this.buffer = shortBuffer.storage;
        this.original = shortBuffer;
        this.index = n;
    }

    public ShortIterator(ShortIterator shortIterator) {
        this.buffer = shortIterator.buffer;
        this.original = shortIterator.original;
        this.index = shortIterator.index;
    }

    public void advance() {
        ++this.index;
    }

    public void advance(int n) {
        this.index += n;
    }

    public boolean atBegin() {
        return this.index == 0;
    }

    public boolean atEnd() {
        return this.index == this.original.size();
    }

    public static ShortIterator begin(short[] sArray) {
        return new ShortIterator(sArray, 0);
    }

    public Object clone() {
        return new ShortIterator(this);
    }

    public int distance(ForwardIterator forwardIterator) {
        if (!this.isCompatibleWith(forwardIterator)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((ShortIterator)forwardIterator).index - this.index;
    }

    public static ShortIterator end(short[] sArray) {
        return new ShortIterator(sArray, sArray.length);
    }

    public boolean equals(ShortIterator shortIterator) {
        return shortIterator.index == this.index && shortIterator.buffer == this.buffer;
    }

    public boolean equals(Object object) {
        return object instanceof ShortIterator && this.equals((ShortIterator)object);
    }

    public Object get() {
        return this.get(0);
    }

    public Object get(int n) {
        return new Short(this.buffer[this.index + n]);
    }

    public Container getContainer() {
        return this.original;
    }

    public short getShort() {
        return this.getShort(0);
    }

    public short getShort(int n) {
        return this.buffer[this.index + n];
    }

    public boolean hasMoreElements() {
        return this.index < this.original.size();
    }

    public int index() {
        return this.index;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof ShortIterator && this.buffer == ((ShortIterator)inputIterator).buffer;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.index < ((ShortIterator)randomAccessIterator).index;
    }

    public Object nextElement() {
        try {
            Object object = this.get();
            this.advance();
            return object;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("ShortIterator");
        }
    }

    public void put(int n, Object object) {
        this.put(n, ShortBuffer.asShort(object));
    }

    public void put(int n, short s) {
        this.buffer[this.index + n] = s;
    }

    public void put(Object object) {
        this.put(0, object);
    }

    public void put(short s) {
        this.put(0, s);
    }

    public void retreat() {
        --this.index;
    }

    public void retreat(int n) {
        this.index -= n;
    }
}

