/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.adapters.ObjectArray;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class ObjectIterator
implements RandomAccessIterator,
Serializable {
    ObjectArray buffer;
    int index;
    static final long serialVersionUID = 2615219073404665807L;

    public ObjectIterator() {
        this(new ObjectArray(), 0);
    }

    public ObjectIterator(Object[] objectArray, int n) {
        this(new ObjectArray(objectArray), n);
    }

    public ObjectIterator(ObjectArray objectArray, int n) {
        this.buffer = objectArray;
        this.index = n;
    }

    public ObjectIterator(ObjectIterator objectIterator) {
        this.buffer = objectIterator.buffer;
        this.index = objectIterator.index;
    }

    public void advance() {
        ++this.index;
    }

    public void advance(int n) {
        this.index += n;
    }

    public boolean atBegin() {
        return this.index == 0;
    }

    public boolean atEnd() {
        return this.index == this.buffer.array.length;
    }

    public static ObjectIterator begin(Object[] objectArray) {
        return new ObjectIterator(objectArray, 0);
    }

    public Object clone() {
        return new ObjectIterator(this);
    }

    public int distance(ForwardIterator forwardIterator) {
        if (!this.isCompatibleWith(forwardIterator)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((ObjectIterator)forwardIterator).index - this.index;
    }

    public static ObjectIterator end(Object[] objectArray) {
        return new ObjectIterator(objectArray, objectArray.length);
    }

    public boolean equals(ObjectIterator objectIterator) {
        return objectIterator.index == this.index && objectIterator.buffer.array == this.buffer.array;
    }

    public boolean equals(Object object) {
        return object instanceof ObjectIterator && this.equals((ObjectIterator)object);
    }

    public Object get() {
        return this.get(0);
    }

    public Object get(int n) {
        return this.buffer.array[this.index + n];
    }

    public Container getContainer() {
        return this.buffer;
    }

    public boolean hasMoreElements() {
        return this.index < this.buffer.array.length;
    }

    public int index() {
        return this.index;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof ObjectIterator && this.buffer.array == ((ObjectIterator)inputIterator).buffer.array;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.index < ((ObjectIterator)randomAccessIterator).index;
    }

    public Object nextElement() {
        try {
            Object object = this.get();
            this.advance();
            return object;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("ObjectIterator");
        }
    }

    public void put(int n, Object object) {
        this.buffer.array[this.index + n] = object;
    }

    public void put(Object object) {
        this.put(0, object);
    }

    public void retreat() {
        --this.index;
    }

    public void retreat(int n) {
        this.index -= n;
    }
}

