/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.adapters.LongArray;
import com.objectspace.jgl.adapters.LongBuffer;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class LongIterator
implements RandomAccessIterator,
Serializable {
    long[] buffer;
    Container original;
    int index;
    static final long serialVersionUID = -1074640010234074351L;

    public LongIterator() {
        this(new LongArray(), 0);
    }

    public LongIterator(long[] lArray, int n) {
        this(new LongArray(lArray), n);
    }

    public LongIterator(LongArray longArray, int n) {
        this.buffer = longArray.array;
        this.original = longArray;
        this.index = n;
    }

    public LongIterator(LongBuffer longBuffer, int n) {
        this.buffer = longBuffer.storage;
        this.original = longBuffer;
        this.index = n;
    }

    public LongIterator(LongIterator longIterator) {
        this.buffer = longIterator.buffer;
        this.original = longIterator.original;
        this.index = longIterator.index;
    }

    public void advance() {
        ++this.index;
    }

    public void advance(int n) {
        this.index += n;
    }

    public boolean atBegin() {
        return this.index == 0;
    }

    public boolean atEnd() {
        return this.index == this.original.size();
    }

    public static LongIterator begin(long[] lArray) {
        return new LongIterator(lArray, 0);
    }

    public Object clone() {
        return new LongIterator(this);
    }

    public int distance(ForwardIterator forwardIterator) {
        if (!this.isCompatibleWith(forwardIterator)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((LongIterator)forwardIterator).index - this.index;
    }

    public static LongIterator end(long[] lArray) {
        return new LongIterator(lArray, lArray.length);
    }

    public boolean equals(LongIterator longIterator) {
        return longIterator.index == this.index && longIterator.buffer == this.buffer;
    }

    public boolean equals(Object object) {
        return object instanceof LongIterator && this.equals((LongIterator)object);
    }

    public Object get() {
        return this.get(0);
    }

    public Object get(int n) {
        return new Long(this.buffer[this.index + n]);
    }

    public Container getContainer() {
        return this.original;
    }

    public long getLong() {
        return this.getLong(0);
    }

    public long getLong(int n) {
        return this.buffer[this.index + n];
    }

    public boolean hasMoreElements() {
        return this.index < this.original.size();
    }

    public int index() {
        return this.index;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof LongIterator && this.buffer == ((LongIterator)inputIterator).buffer;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.index < ((LongIterator)randomAccessIterator).index;
    }

    public Object nextElement() {
        try {
            Object object = this.get();
            this.advance();
            return object;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("LongIterator");
        }
    }

    public void put(int n, long l) {
        this.buffer[this.index + n] = l;
    }

    public void put(int n, Object object) {
        this.put(n, LongBuffer.asLong(object));
    }

    public void put(long l) {
        this.put(0, l);
    }

    public void put(Object object) {
        this.put(0, object);
    }

    public void retreat() {
        --this.index;
    }

    public void retreat(int n) {
        this.index -= n;
    }
}

