/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.LongArray;
import com.objectspace.jgl.adapters.LongIterator;
import java.util.Enumeration;

public class LongBuffer
implements Sequence {
    static final long defaultValue = 0L;
    long[] storage;
    int length;
    static final long serialVersionUID = 568000230794422863L;

    public LongBuffer() {
        this.clear();
    }

    public LongBuffer(long[] lArray) {
        this(lArray, true);
    }

    LongBuffer(long[] lArray, boolean bl) {
        long[] lArray2 = lArray;
        synchronized (lArray) {
            this.length = lArray.length;
            if (bl) {
                this.storage = new long[this.length];
                System.arraycopy(lArray, 0, this.storage, 0, this.length);
            } else {
                this.storage = lArray;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public LongBuffer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to create an LongBuffer with a negative size");
        }
        this.length = n;
        this.storage = new long[this.length];
    }

    public LongBuffer(int n, long l) {
        this(n);
        int n2 = 0;
        while (n2 < this.length) {
            this.storage[n2] = l;
            ++n2;
        }
    }

    public LongBuffer(LongBuffer longBuffer) {
        this(longBuffer.storage);
    }

    public synchronized void add(long l) {
        if (this.length == this.storage.length) {
            long[] lArray = this.getNextStorage(1);
            this.copyTo(lArray);
            this.storage = lArray;
        }
        this.storage[this.length++] = l;
    }

    public synchronized Object add(Object object) {
        this.add(LongBuffer.asLong(object));
        return null;
    }

    static long asLong(Object object) {
        return ((Number)object).longValue();
    }

    public Object at(int n) {
        return new Long(this.longAt(n));
    }

    public Object back() {
        return this.at(this.size() - 1);
    }

    public synchronized LongIterator begin() {
        return new LongIterator(this, 0);
    }

    public int capacity() {
        return this.storage.length;
    }

    public synchronized void clear() {
        this.storage = new long[10];
        this.length = 0;
    }

    public synchronized Object clone() {
        return new LongBuffer(this);
    }

    public boolean contains(long l) {
        return this.indexOf(l) != -1;
    }

    public boolean contains(Object object) {
        return this.contains(LongBuffer.asLong(object));
    }

    public synchronized void copy(LongBuffer longBuffer) {
        if (this == longBuffer) {
            return;
        }
        LongBuffer longBuffer2 = longBuffer;
        synchronized (longBuffer2) {
            if (longBuffer.length > this.storage.length) {
                this.storage = longBuffer.get();
            } else {
                System.arraycopy(longBuffer.storage, 0, this.storage, 0, longBuffer.length);
                int n = longBuffer.length;
                while (n < this.length) {
                    this.storage[n] = 0L;
                    ++n;
                }
            }
            this.length = longBuffer.length;
        }
    }

    public synchronized void copyTo(long[] lArray) {
        long[] lArray2 = lArray;
        synchronized (lArray) {
            System.arraycopy(this.storage, 0, lArray, 0, Math.min(this.length, lArray.length));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public synchronized int count(int n, int n2, long l) {
        ArrayAdapter.checkRange(n, n2, this.length);
        int n3 = 0;
        while (n < n2) {
            if (this.storage[n] == l) {
                ++n3;
            }
            ++n;
        }
        return n3;
    }

    public int count(int n, int n2, Object object) {
        return this.count(n, n2, LongBuffer.asLong(object));
    }

    public int count(long l) {
        return this.count(0, this.length - 1, l);
    }

    public int count(Object object) {
        return this.count(LongBuffer.asLong(object));
    }

    public Enumeration elements() {
        return this.begin();
    }

    public synchronized LongIterator end() {
        return new LongIterator(this, this.length);
    }

    public synchronized void ensureCapacity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to reserve a negative size.");
        }
        if (this.storage.length < n) {
            long[] lArray = new long[n];
            if (this.length > 0) {
                System.arraycopy(this.storage, 0, lArray, 0, this.length);
            }
            this.storage = lArray;
        }
    }

    public boolean equals(long[] lArray) {
        return this.equals(new LongArray(lArray));
    }

    public synchronized boolean equals(LongArray longArray) {
        return longArray.equals(this.storage);
    }

    public boolean equals(LongBuffer longBuffer) {
        return this.equals(new LongArray(longBuffer.storage));
    }

    public boolean equals(Object object) {
        return object instanceof LongBuffer && this.equals((LongBuffer)object) || object instanceof LongArray && this.equals((LongArray)object);
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public Object front() {
        return this.at(0);
    }

    public synchronized long[] get() {
        long[] lArray = new long[this.length];
        this.copyTo(lArray);
        return lArray;
    }

    private long[] getNextStorage(int n) {
        int n2 = Math.max(ArrayAdapter.getNextSize(this.length), this.length + n);
        long[] lArray = new long[n2];
        return lArray;
    }

    public synchronized int hashCode() {
        return Algorithms.orderedHash(this.begin(), this.length);
    }

    public synchronized int indexOf(int n, int n2, long l) {
        if (n2 < n) {
            return -1;
        }
        ArrayAdapter.checkRange(n, n2, this.length);
        while (n < n2) {
            if (this.storage[n] == l) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(int n, int n2, Object object) {
        return this.indexOf(n, n2, LongBuffer.asLong(object));
    }

    public int indexOf(long l) {
        return this.indexOf(0, this.length - 1, l);
    }

    public int indexOf(Object object) {
        return this.indexOf(LongBuffer.asLong(object));
    }

    public synchronized void insert(int n, int n2, long l) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects.");
        }
        if (n2 == 0) {
            return;
        }
        ArrayAdapter.checkIndex(n, this.length + 1);
        if (this.storage.length - this.length >= n2) {
            System.arraycopy(this.storage, n, this.storage, n + n2, this.length - n);
        } else {
            long[] lArray = this.getNextStorage(n2);
            System.arraycopy(this.storage, 0, lArray, 0, n);
            System.arraycopy(this.storage, n, lArray, n + n2, this.length - n);
            this.storage = lArray;
        }
        int n3 = n;
        while (n3 < n + n2) {
            this.storage[n3] = l;
            ++n3;
        }
        this.length += n2;
    }

    public void insert(int n, int n2, Object object) {
        this.insert(n, n2, LongBuffer.asLong(object));
    }

    public synchronized void insert(int n, long l) {
        ArrayAdapter.checkIndex(n, this.length + 1);
        if (this.length != this.storage.length) {
            if (n != this.length) {
                System.arraycopy(this.storage, n, this.storage, n + 1, this.length - n);
            }
        } else {
            long[] lArray = this.getNextStorage(1);
            System.arraycopy(this.storage, 0, lArray, 0, n);
            System.arraycopy(this.storage, n, lArray, n + 1, this.length - n);
            this.storage = lArray;
        }
        this.storage[n] = l;
        ++this.length;
    }

    public synchronized void insert(int n, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        int n2 = forwardIterator.distance(forwardIterator2);
        if (n2 == 0) {
            return;
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        if (this.storage.length - this.length >= n2) {
            System.arraycopy(this.storage, n, this.storage, n + n2, this.length - n);
        } else {
            long[] lArray = this.getNextStorage(n2);
            System.arraycopy(this.storage, 0, lArray, 0, n);
            System.arraycopy(this.storage, n, lArray, n + n2, this.length - n);
            this.storage = lArray;
        }
        this.length += n2;
        int n3 = n;
        while (n3 < n + n2) {
            this.put(n3, forwardIterator3.nextElement());
            ++n3;
        }
    }

    public void insert(int n, Object object) {
        this.insert(n, LongBuffer.asLong(object));
    }

    public void insert(LongIterator longIterator, int n, long l) {
        this.insert(longIterator.index, n, l);
    }

    public void insert(LongIterator longIterator, int n, Object object) {
        this.insert(longIterator, n, LongBuffer.asLong(object));
    }

    public LongIterator insert(LongIterator longIterator, long l) {
        this.insert(longIterator.index, l);
        return new LongIterator(this, longIterator.index);
    }

    public void insert(LongIterator longIterator, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        this.insert(longIterator.index, forwardIterator, forwardIterator2);
    }

    public LongIterator insert(LongIterator longIterator, Object object) {
        return this.insert(longIterator, LongBuffer.asLong(object));
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized long longAt(int n) {
        ArrayAdapter.checkIndex(n, this.length);
        return this.storage[n];
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public synchronized Object popBack() {
        if (this.length == 0) {
            throw new InvalidOperationException("LongBuffer is empty");
        }
        Long l = new Long(this.storage[--this.length]);
        this.storage[this.length] = 0L;
        return l;
    }

    public synchronized Object popFront() {
        if (this.length == 0) {
            throw new InvalidOperationException("LongBuffer is empty");
        }
        Long l = new Long(this.storage[0]);
        this.remove(0);
        return l;
    }

    public void pushBack(long l) {
        this.add(l);
    }

    public void pushBack(Object object) {
        this.add(LongBuffer.asLong(object));
    }

    public void pushFront(long l) {
        this.insert(0, l);
    }

    public void pushFront(Object object) {
        this.insert(0, object);
    }

    public synchronized void put(int n, long l) {
        ArrayAdapter.checkIndex(n, this.length);
        this.storage[n] = l;
    }

    public synchronized void put(int n, Object object) {
        this.put(n, LongBuffer.asLong(object));
    }

    public synchronized Object remove(int n) {
        ArrayAdapter.checkIndex(n, this.length);
        Long l = new Long(this.storage[n]);
        System.arraycopy(this.storage, n + 1, this.storage, n, this.length - n - 1);
        this.storage[--this.length] = 0L;
        return l;
    }

    public synchronized int remove(int n, int n2) {
        if (n2 < n) {
            return 0;
        }
        ArrayAdapter.checkRange(n, n2, this.length);
        int n3 = n2 - n + 1;
        System.arraycopy(this.storage, n2 + 1, this.storage, n, this.length - n2 - 1);
        int n4 = this.length - n3;
        while (n4 < this.length) {
            this.storage[n4] = 0L;
            ++n4;
        }
        this.length -= n3;
        return n3;
    }

    public synchronized int remove(int n, int n2, Object object) {
        LongBuffer.asLong(object);
        if (n2 < n) {
            return 0;
        }
        ArrayAdapter.checkRange(n, n2, this.length);
        LongIterator longIterator = new LongIterator(this, n);
        LongIterator longIterator2 = new LongIterator(this, n2 + 1);
        LongIterator longIterator3 = (LongIterator)Algorithms.remove(longIterator, longIterator2, object);
        return this.remove(longIterator3.index, n2);
    }

    public int remove(Object object) {
        return this.remove(object, this.length);
    }

    public synchronized int remove(Object object, int n) {
        long l = LongBuffer.asLong(object);
        int n2 = 0;
        while (n > 0) {
            int n3 = this.indexOf(l);
            if (n3 < 0) break;
            --n;
            ++n2;
            this.remove(n3);
        }
        return n2;
    }

    public Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof LongIterator)) {
            throw new IllegalArgumentException("Enumeration not an LongIterator");
        }
        if (((LongIterator)enumeration).buffer != this.storage) {
            throw new IllegalArgumentException("Enumeration not for this LongBuffer ");
        }
        Object object = ((LongIterator)enumeration).get();
        this.remove(((LongIterator)enumeration).index);
        return object;
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        if (!(enumeration instanceof LongIterator) || !(enumeration2 instanceof LongIterator)) {
            throw new IllegalArgumentException("Enumeration not an LongIterator");
        }
        if (((LongIterator)enumeration).buffer != this.storage || ((LongIterator)enumeration).isCompatibleWith((LongIterator)enumeration2)) {
            throw new IllegalArgumentException("Enumeration not compatible");
        }
        return this.remove(((LongIterator)enumeration).index, ((LongIterator)enumeration2).index - 1);
    }

    public synchronized int replace(int n, int n2, long l, long l2) {
        ArrayAdapter.checkRange(n, n2, this.length);
        int n3 = 0;
        while (n < n2) {
            if (this.storage[n] == l) {
                this.storage[n] = l2;
                ++n3;
            }
            ++n;
        }
        return n3;
    }

    public int replace(int n, int n2, Object object, Object object2) {
        return this.replace(n, n2, LongBuffer.asLong(object), LongBuffer.asLong(object2));
    }

    public int replace(long l, long l2) {
        return this.replace(0, this.length - 1, l, l2);
    }

    public int replace(Object object, Object object2) {
        return this.replace(LongBuffer.asLong(object), LongBuffer.asLong(object2));
    }

    public synchronized void setSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to become a negative size.");
        }
        if (this.length > n) {
            this.remove(n, this.length - 1);
        } else if (this.length < n) {
            this.insert(this.length, n - this.length, 0L);
        }
    }

    public int size() {
        return this.length;
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public synchronized void swap(LongBuffer longBuffer) {
        LongBuffer longBuffer2 = longBuffer;
        synchronized (longBuffer2) {
            int n = this.length;
            long[] lArray = this.storage;
            this.length = longBuffer.length;
            this.storage = longBuffer.storage;
            longBuffer.length = n;
            longBuffer.storage = lArray;
        }
    }

    public synchronized String toString() {
        return Algorithms.toString(this, "LongBuffer");
    }

    public synchronized void trimToSize() {
        if (this.length < this.storage.length) {
            this.storage = this.get();
        }
    }
}

