/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.adapters.IntArray;
import com.objectspace.jgl.adapters.IntBuffer;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class IntIterator
implements RandomAccessIterator,
Serializable {
    int[] buffer;
    Container original;
    int index;
    static final long serialVersionUID = 2299607292735098234L;

    public IntIterator() {
        this(new IntArray(), 0);
    }

    public IntIterator(int[] nArray, int n) {
        this(new IntArray(nArray), n);
    }

    public IntIterator(IntArray intArray, int n) {
        this.buffer = intArray.array;
        this.original = intArray;
        this.index = n;
    }

    public IntIterator(IntBuffer intBuffer, int n) {
        this.buffer = intBuffer.storage;
        this.original = intBuffer;
        this.index = n;
    }

    public IntIterator(IntIterator intIterator) {
        this.buffer = intIterator.buffer;
        this.original = intIterator.original;
        this.index = intIterator.index;
    }

    public void advance() {
        ++this.index;
    }

    public void advance(int n) {
        this.index += n;
    }

    public boolean atBegin() {
        return this.index == 0;
    }

    public boolean atEnd() {
        return this.index == this.original.size();
    }

    public static IntIterator begin(int[] nArray) {
        return new IntIterator(nArray, 0);
    }

    public Object clone() {
        return new IntIterator(this);
    }

    public int distance(ForwardIterator forwardIterator) {
        if (!this.isCompatibleWith(forwardIterator)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((IntIterator)forwardIterator).index - this.index;
    }

    public static IntIterator end(int[] nArray) {
        return new IntIterator(nArray, nArray.length);
    }

    public boolean equals(IntIterator intIterator) {
        return intIterator.index == this.index && intIterator.buffer == this.buffer;
    }

    public boolean equals(Object object) {
        return object instanceof IntIterator && this.equals((IntIterator)object);
    }

    public Object get() {
        return this.get(0);
    }

    public Object get(int n) {
        return new Integer(this.buffer[this.index + n]);
    }

    public Container getContainer() {
        return this.original;
    }

    public int getInt() {
        return this.getInt(0);
    }

    public int getInt(int n) {
        return this.buffer[this.index + n];
    }

    public boolean hasMoreElements() {
        return this.index < this.original.size();
    }

    public int index() {
        return this.index;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof IntIterator && this.buffer == ((IntIterator)inputIterator).buffer;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.index < ((IntIterator)randomAccessIterator).index;
    }

    public Object nextElement() {
        try {
            Object object = this.get();
            this.advance();
            return object;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("IntIterator");
        }
    }

    public void put(int n) {
        this.put(0, n);
    }

    public void put(int n, int n2) {
        this.buffer[this.index + n] = n2;
    }

    public void put(int n, Object object) {
        this.put(n, IntBuffer.asInt(object));
    }

    public void put(Object object) {
        this.put(0, object);
    }

    public void retreat() {
        --this.index;
    }

    public void retreat(int n) {
        this.index -= n;
    }
}

