/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.adapters.FloatArray;
import com.objectspace.jgl.adapters.FloatBuffer;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class FloatIterator
implements RandomAccessIterator,
Serializable {
    float[] buffer;
    Container original;
    int index;
    static final long serialVersionUID = -4831335176103843922L;

    public FloatIterator() {
        this(new FloatArray(), 0);
    }

    public FloatIterator(float[] fArray, int n) {
        this(new FloatArray(fArray), n);
    }

    public FloatIterator(FloatArray floatArray, int n) {
        this.buffer = floatArray.array;
        this.original = floatArray;
        this.index = n;
    }

    public FloatIterator(FloatBuffer floatBuffer, int n) {
        this.buffer = floatBuffer.storage;
        this.original = floatBuffer;
        this.index = n;
    }

    public FloatIterator(FloatIterator floatIterator) {
        this.buffer = floatIterator.buffer;
        this.original = floatIterator.original;
        this.index = floatIterator.index;
    }

    public void advance() {
        ++this.index;
    }

    public void advance(int n) {
        this.index += n;
    }

    public boolean atBegin() {
        return this.index == 0;
    }

    public boolean atEnd() {
        return this.index == this.original.size();
    }

    public static FloatIterator begin(float[] fArray) {
        return new FloatIterator(fArray, 0);
    }

    public Object clone() {
        return new FloatIterator(this);
    }

    public int distance(ForwardIterator forwardIterator) {
        if (!this.isCompatibleWith(forwardIterator)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((FloatIterator)forwardIterator).index - this.index;
    }

    public static FloatIterator end(float[] fArray) {
        return new FloatIterator(fArray, fArray.length);
    }

    public boolean equals(FloatIterator floatIterator) {
        return floatIterator.index == this.index && floatIterator.buffer == this.buffer;
    }

    public boolean equals(Object object) {
        return object instanceof FloatIterator && this.equals((FloatIterator)object);
    }

    public Object get() {
        return this.get(0);
    }

    public Object get(int n) {
        return new Float(this.buffer[this.index + n]);
    }

    public Container getContainer() {
        return this.original;
    }

    public float getFloat() {
        return this.getFloat(0);
    }

    public float getFloat(int n) {
        return this.buffer[this.index + n];
    }

    public boolean hasMoreElements() {
        return this.index < this.original.size();
    }

    public int index() {
        return this.index;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof FloatIterator && this.buffer == ((FloatIterator)inputIterator).buffer;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.index < ((FloatIterator)randomAccessIterator).index;
    }

    public Object nextElement() {
        try {
            Object object = this.get();
            this.advance();
            return object;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("FloatIterator");
        }
    }

    public void put(float f) {
        this.put(0, f);
    }

    public void put(int n, float f) {
        this.buffer[this.index + n] = f;
    }

    public void put(int n, Object object) {
        this.put(n, FloatBuffer.asFloat(object));
    }

    public void put(Object object) {
        this.put(0, object);
    }

    public void retreat() {
        --this.index;
    }

    public void retreat(int n) {
        this.index -= n;
    }
}

