/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.FloatBuffer;
import com.objectspace.jgl.adapters.FloatIterator;
import java.util.Enumeration;

public class FloatArray
extends ArrayAdapter {
    float[] array;
    static final long serialVersionUID = 2024495121036254354L;

    public FloatArray() {
        this(new float[0]);
    }

    public FloatArray(float[] fArray) {
        this.array = fArray;
    }

    public FloatArray(FloatArray floatArray) {
        this(floatArray.array);
    }

    public FloatArray(FloatBuffer floatBuffer) {
        this(floatBuffer.get());
    }

    public Object at(int n) {
        return new Float(this.floatAt(n));
    }

    public synchronized FloatIterator begin() {
        return new FloatIterator(this, 0);
    }

    public synchronized Object clone() {
        return new FloatArray(this);
    }

    public Enumeration elements() {
        return this.begin();
    }

    public synchronized FloatIterator end() {
        return new FloatIterator(this, this.array.length);
    }

    public synchronized boolean equals(float[] fArray) {
        float[] fArray2 = fArray;
        synchronized (fArray) {
            if (this.array.length != fArray.length) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            int n = 0;
            while (n < fArray.length) {
                if (this.array[n] != fArray[n]) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    public boolean equals(FloatArray floatArray) {
        return this.equals(floatArray.array);
    }

    public boolean equals(FloatBuffer floatBuffer) {
        return this.equals(floatBuffer.storage);
    }

    public boolean equals(Object object) {
        return object instanceof FloatArray && this.equals((FloatArray)object) || object instanceof FloatBuffer && this.equals((FloatBuffer)object);
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized float floatAt(int n) {
        return this.array[n];
    }

    public float[] get() {
        return this.array;
    }

    public int maxSize() {
        return this.array.length;
    }

    public synchronized void put(int n, float f) {
        this.array[n] = f;
    }

    public void put(int n, Object object) {
        this.put(n, ((Number)object).floatValue());
    }

    public int size() {
        return this.array.length;
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public synchronized String toString() {
        return Algorithms.toString(this, "float[]");
    }
}

