/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.adapters.DoubleArray;
import com.objectspace.jgl.adapters.DoubleBuffer;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class DoubleIterator
implements RandomAccessIterator,
Serializable {
    double[] buffer;
    Container original;
    int index;
    static final long serialVersionUID = 5481800139253707671L;

    public DoubleIterator() {
        this(new DoubleArray(), 0);
    }

    public DoubleIterator(double[] dArray, int n) {
        this(new DoubleArray(dArray), n);
    }

    public DoubleIterator(DoubleArray doubleArray, int n) {
        this.buffer = doubleArray.array;
        this.original = doubleArray;
        this.index = n;
    }

    public DoubleIterator(DoubleBuffer doubleBuffer, int n) {
        this.buffer = doubleBuffer.storage;
        this.original = doubleBuffer;
        this.index = n;
    }

    public DoubleIterator(DoubleIterator doubleIterator) {
        this.buffer = doubleIterator.buffer;
        this.original = doubleIterator.original;
        this.index = doubleIterator.index;
    }

    public void advance() {
        ++this.index;
    }

    public void advance(int n) {
        this.index += n;
    }

    public boolean atBegin() {
        return this.index == 0;
    }

    public boolean atEnd() {
        return this.index == this.original.size();
    }

    public static DoubleIterator begin(double[] dArray) {
        return new DoubleIterator(dArray, 0);
    }

    public Object clone() {
        return new DoubleIterator(this);
    }

    public int distance(ForwardIterator forwardIterator) {
        if (!this.isCompatibleWith(forwardIterator)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((DoubleIterator)forwardIterator).index - this.index;
    }

    public static DoubleIterator end(double[] dArray) {
        return new DoubleIterator(dArray, dArray.length);
    }

    public boolean equals(DoubleIterator doubleIterator) {
        return doubleIterator.index == this.index && doubleIterator.buffer == this.buffer;
    }

    public boolean equals(Object object) {
        return object instanceof DoubleIterator && this.equals((DoubleIterator)object);
    }

    public Object get() {
        return this.get(0);
    }

    public Object get(int n) {
        return new Double(this.buffer[this.index + n]);
    }

    public Container getContainer() {
        return this.original;
    }

    public double getDouble() {
        return this.getDouble(0);
    }

    public double getDouble(int n) {
        return this.buffer[this.index + n];
    }

    public boolean hasMoreElements() {
        return this.index < this.original.size();
    }

    public int index() {
        return this.index;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof DoubleIterator && this.buffer == ((DoubleIterator)inputIterator).buffer;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.index < ((DoubleIterator)randomAccessIterator).index;
    }

    public Object nextElement() {
        try {
            Object object = this.get();
            this.advance();
            return object;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("DoubleIterator");
        }
    }

    public void put(double d) {
        this.put(0, d);
    }

    public void put(int n, double d) {
        this.buffer[this.index + n] = d;
    }

    public void put(int n, Object object) {
        this.put(n, DoubleBuffer.asDouble(object));
    }

    public void put(Object object) {
        this.put(0, object);
    }

    public void retreat() {
        --this.index;
    }

    public void retreat(int n) {
        this.index -= n;
    }
}

