/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.DoubleArray;
import com.objectspace.jgl.adapters.DoubleIterator;
import java.util.Enumeration;

public class DoubleBuffer
implements Sequence {
    static final double defaultValue = 0.0;
    double[] storage;
    int length;
    static final long serialVersionUID = 2440304957869661623L;

    public DoubleBuffer() {
        this.clear();
    }

    public DoubleBuffer(double[] dArray) {
        this(dArray, true);
    }

    DoubleBuffer(double[] dArray, boolean bl) {
        double[] dArray2 = dArray;
        synchronized (dArray) {
            this.length = dArray.length;
            if (bl) {
                this.storage = new double[this.length];
                System.arraycopy(dArray, 0, this.storage, 0, this.length);
            } else {
                this.storage = dArray;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public DoubleBuffer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to create an DoubleBuffer with a negative size");
        }
        this.length = n;
        this.storage = new double[this.length];
    }

    public DoubleBuffer(int n, double d) {
        this(n);
        int n2 = 0;
        while (n2 < this.length) {
            this.storage[n2] = d;
            ++n2;
        }
    }

    public DoubleBuffer(DoubleBuffer doubleBuffer) {
        this(doubleBuffer.storage);
    }

    public synchronized void add(double d) {
        if (this.length == this.storage.length) {
            double[] dArray = this.getNextStorage(1);
            this.copyTo(dArray);
            this.storage = dArray;
        }
        this.storage[this.length++] = d;
    }

    public synchronized Object add(Object object) {
        this.add(DoubleBuffer.asDouble(object));
        return null;
    }

    static double asDouble(Object object) {
        return ((Number)object).doubleValue();
    }

    public Object at(int n) {
        return new Double(this.doubleAt(n));
    }

    public Object back() {
        return this.at(this.size() - 1);
    }

    public synchronized DoubleIterator begin() {
        return new DoubleIterator(this, 0);
    }

    public int capacity() {
        return this.storage.length;
    }

    public synchronized void clear() {
        this.storage = new double[10];
        this.length = 0;
    }

    public synchronized Object clone() {
        return new DoubleBuffer(this);
    }

    public boolean contains(double d) {
        return this.indexOf(d) != -1;
    }

    public boolean contains(Object object) {
        return this.contains(DoubleBuffer.asDouble(object));
    }

    public synchronized void copy(DoubleBuffer doubleBuffer) {
        if (this == doubleBuffer) {
            return;
        }
        DoubleBuffer doubleBuffer2 = doubleBuffer;
        synchronized (doubleBuffer2) {
            if (doubleBuffer.length > this.storage.length) {
                this.storage = doubleBuffer.get();
            } else {
                System.arraycopy(doubleBuffer.storage, 0, this.storage, 0, doubleBuffer.length);
                int n = doubleBuffer.length;
                while (n < this.length) {
                    this.storage[n] = 0.0;
                    ++n;
                }
            }
            this.length = doubleBuffer.length;
        }
    }

    public synchronized void copyTo(double[] dArray) {
        double[] dArray2 = dArray;
        synchronized (dArray) {
            System.arraycopy(this.storage, 0, dArray, 0, Math.min(this.length, dArray.length));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int count(double d) {
        return this.count(0, this.length - 1, d);
    }

    public synchronized int count(int n, int n2, double d) {
        ArrayAdapter.checkRange(n, n2, this.length);
        int n3 = 0;
        while (n < n2) {
            if (this.storage[n] == d) {
                ++n3;
            }
            ++n;
        }
        return n3;
    }

    public int count(int n, int n2, Object object) {
        return this.count(n, n2, DoubleBuffer.asDouble(object));
    }

    public int count(Object object) {
        return this.count(DoubleBuffer.asDouble(object));
    }

    public synchronized double doubleAt(int n) {
        ArrayAdapter.checkIndex(n, this.length);
        return this.storage[n];
    }

    public Enumeration elements() {
        return this.begin();
    }

    public synchronized DoubleIterator end() {
        return new DoubleIterator(this, this.length);
    }

    public synchronized void ensureCapacity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to reserve a negative size.");
        }
        if (this.storage.length < n) {
            double[] dArray = new double[n];
            if (this.length > 0) {
                System.arraycopy(this.storage, 0, dArray, 0, this.length);
            }
            this.storage = dArray;
        }
    }

    public boolean equals(double[] dArray) {
        return this.equals(new DoubleArray(dArray));
    }

    public synchronized boolean equals(DoubleArray doubleArray) {
        return doubleArray.equals(this.storage);
    }

    public boolean equals(DoubleBuffer doubleBuffer) {
        return this.equals(new DoubleArray(doubleBuffer.storage));
    }

    public boolean equals(Object object) {
        return object instanceof DoubleBuffer && this.equals((DoubleBuffer)object) || object instanceof DoubleArray && this.equals((DoubleArray)object);
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public Object front() {
        return this.at(0);
    }

    public synchronized double[] get() {
        double[] dArray = new double[this.length];
        this.copyTo(dArray);
        return dArray;
    }

    private double[] getNextStorage(int n) {
        int n2 = Math.max(ArrayAdapter.getNextSize(this.length), this.length + n);
        double[] dArray = new double[n2];
        return dArray;
    }

    public synchronized int hashCode() {
        return Algorithms.orderedHash(this.begin(), this.length);
    }

    public int indexOf(double d) {
        return this.indexOf(0, this.length - 1, d);
    }

    public synchronized int indexOf(int n, int n2, double d) {
        if (n2 < n) {
            return -1;
        }
        ArrayAdapter.checkRange(n, n2, this.length);
        while (n < n2) {
            if (this.storage[n] == d) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(int n, int n2, Object object) {
        return this.indexOf(n, n2, DoubleBuffer.asDouble(object));
    }

    public int indexOf(Object object) {
        return this.indexOf(DoubleBuffer.asDouble(object));
    }

    public synchronized void insert(int n, double d) {
        ArrayAdapter.checkIndex(n, this.length + 1);
        if (this.length != this.storage.length) {
            if (n != this.length) {
                System.arraycopy(this.storage, n, this.storage, n + 1, this.length - n);
            }
        } else {
            double[] dArray = this.getNextStorage(1);
            System.arraycopy(this.storage, 0, dArray, 0, n);
            System.arraycopy(this.storage, n, dArray, n + 1, this.length - n);
            this.storage = dArray;
        }
        this.storage[n] = d;
        ++this.length;
    }

    public synchronized void insert(int n, int n2, double d) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects.");
        }
        if (n2 == 0) {
            return;
        }
        ArrayAdapter.checkIndex(n, this.length + 1);
        if (this.storage.length - this.length >= n2) {
            System.arraycopy(this.storage, n, this.storage, n + n2, this.length - n);
        } else {
            double[] dArray = this.getNextStorage(n2);
            System.arraycopy(this.storage, 0, dArray, 0, n);
            System.arraycopy(this.storage, n, dArray, n + n2, this.length - n);
            this.storage = dArray;
        }
        int n3 = n;
        while (n3 < n + n2) {
            this.storage[n3] = d;
            ++n3;
        }
        this.length += n2;
    }

    public void insert(int n, int n2, Object object) {
        this.insert(n, n2, DoubleBuffer.asDouble(object));
    }

    public synchronized void insert(int n, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        int n2 = forwardIterator.distance(forwardIterator2);
        if (n2 == 0) {
            return;
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        if (this.storage.length - this.length >= n2) {
            System.arraycopy(this.storage, n, this.storage, n + n2, this.length - n);
        } else {
            double[] dArray = this.getNextStorage(n2);
            System.arraycopy(this.storage, 0, dArray, 0, n);
            System.arraycopy(this.storage, n, dArray, n + n2, this.length - n);
            this.storage = dArray;
        }
        this.length += n2;
        int n3 = n;
        while (n3 < n + n2) {
            this.put(n3, forwardIterator3.nextElement());
            ++n3;
        }
    }

    public void insert(int n, Object object) {
        this.insert(n, DoubleBuffer.asDouble(object));
    }

    public DoubleIterator insert(DoubleIterator doubleIterator, double d) {
        this.insert(doubleIterator.index, d);
        return new DoubleIterator(this, doubleIterator.index);
    }

    public void insert(DoubleIterator doubleIterator, int n, double d) {
        this.insert(doubleIterator.index, n, d);
    }

    public void insert(DoubleIterator doubleIterator, int n, Object object) {
        this.insert(doubleIterator, n, DoubleBuffer.asDouble(object));
    }

    public void insert(DoubleIterator doubleIterator, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        this.insert(doubleIterator.index, forwardIterator, forwardIterator2);
    }

    public DoubleIterator insert(DoubleIterator doubleIterator, Object object) {
        return this.insert(doubleIterator, DoubleBuffer.asDouble(object));
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public synchronized Object popBack() {
        if (this.length == 0) {
            throw new InvalidOperationException("DoubleBuffer is empty");
        }
        Double d = new Double(this.storage[--this.length]);
        this.storage[this.length] = 0.0;
        return d;
    }

    public synchronized Object popFront() {
        if (this.length == 0) {
            throw new InvalidOperationException("DoubleBuffer is empty");
        }
        Double d = new Double(this.storage[0]);
        this.remove(0);
        return d;
    }

    public void pushBack(double d) {
        this.add(d);
    }

    public void pushBack(Object object) {
        this.add(DoubleBuffer.asDouble(object));
    }

    public void pushFront(double d) {
        this.insert(0, d);
    }

    public void pushFront(Object object) {
        this.insert(0, object);
    }

    public synchronized void put(int n, double d) {
        ArrayAdapter.checkIndex(n, this.length);
        this.storage[n] = d;
    }

    public synchronized void put(int n, Object object) {
        this.put(n, DoubleBuffer.asDouble(object));
    }

    public synchronized Object remove(int n) {
        ArrayAdapter.checkIndex(n, this.length);
        Double d = new Double(this.storage[n]);
        System.arraycopy(this.storage, n + 1, this.storage, n, this.length - n - 1);
        this.storage[--this.length] = 0.0;
        return d;
    }

    public synchronized int remove(int n, int n2) {
        if (n2 < n) {
            return 0;
        }
        ArrayAdapter.checkRange(n, n2, this.length);
        int n3 = n2 - n + 1;
        System.arraycopy(this.storage, n2 + 1, this.storage, n, this.length - n2 - 1);
        int n4 = this.length - n3;
        while (n4 < this.length) {
            this.storage[n4] = 0.0;
            ++n4;
        }
        this.length -= n3;
        return n3;
    }

    public synchronized int remove(int n, int n2, Object object) {
        DoubleBuffer.asDouble(object);
        if (n2 < n) {
            return 0;
        }
        ArrayAdapter.checkRange(n, n2, this.length);
        DoubleIterator doubleIterator = new DoubleIterator(this, n);
        DoubleIterator doubleIterator2 = new DoubleIterator(this, n2 + 1);
        DoubleIterator doubleIterator3 = (DoubleIterator)Algorithms.remove(doubleIterator, doubleIterator2, object);
        return this.remove(doubleIterator3.index, n2);
    }

    public int remove(Object object) {
        return this.remove(object, this.length);
    }

    public synchronized int remove(Object object, int n) {
        double d = DoubleBuffer.asDouble(object);
        int n2 = 0;
        while (n > 0) {
            int n3 = this.indexOf(d);
            if (n3 < 0) break;
            --n;
            ++n2;
            this.remove(n3);
        }
        return n2;
    }

    public Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof DoubleIterator)) {
            throw new IllegalArgumentException("Enumeration not an DoubleIterator");
        }
        if (((DoubleIterator)enumeration).buffer != this.storage) {
            throw new IllegalArgumentException("Enumeration not for this DoubleBuffer ");
        }
        Object object = ((DoubleIterator)enumeration).get();
        this.remove(((DoubleIterator)enumeration).index);
        return object;
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        if (!(enumeration instanceof DoubleIterator) || !(enumeration2 instanceof DoubleIterator)) {
            throw new IllegalArgumentException("Enumeration not an DoubleIterator");
        }
        if (((DoubleIterator)enumeration).buffer != this.storage || ((DoubleIterator)enumeration).isCompatibleWith((DoubleIterator)enumeration2)) {
            throw new IllegalArgumentException("Enumeration not compatible");
        }
        return this.remove(((DoubleIterator)enumeration).index, ((DoubleIterator)enumeration2).index - 1);
    }

    public int replace(double d, double d2) {
        return this.replace(0, this.length - 1, d, d2);
    }

    public synchronized int replace(int n, int n2, double d, double d2) {
        ArrayAdapter.checkRange(n, n2, this.length);
        int n3 = 0;
        while (n < n2) {
            if (this.storage[n] == d) {
                this.storage[n] = d2;
                ++n3;
            }
            ++n;
        }
        return n3;
    }

    public int replace(int n, int n2, Object object, Object object2) {
        return this.replace(n, n2, DoubleBuffer.asDouble(object), DoubleBuffer.asDouble(object2));
    }

    public int replace(Object object, Object object2) {
        return this.replace(DoubleBuffer.asDouble(object), DoubleBuffer.asDouble(object2));
    }

    public synchronized void setSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to become a negative size.");
        }
        if (this.length > n) {
            this.remove(n, this.length - 1);
        } else if (this.length < n) {
            this.insert(this.length, n - this.length, 0.0);
        }
    }

    public int size() {
        return this.length;
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public synchronized void swap(DoubleBuffer doubleBuffer) {
        DoubleBuffer doubleBuffer2 = doubleBuffer;
        synchronized (doubleBuffer2) {
            int n = this.length;
            double[] dArray = this.storage;
            this.length = doubleBuffer.length;
            this.storage = doubleBuffer.storage;
            doubleBuffer.length = n;
            doubleBuffer.storage = dArray;
        }
    }

    public synchronized String toString() {
        return Algorithms.toString(this, "DoubleBuffer");
    }

    public synchronized void trimToSize() {
        if (this.length < this.storage.length) {
            this.storage = this.get();
        }
    }
}

