/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.adapters.CharArray;
import com.objectspace.jgl.adapters.CharBuffer;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class CharIterator
implements RandomAccessIterator,
Serializable {
    char[] buffer;
    Container original;
    int index;
    static final long serialVersionUID = 2176327841327675493L;

    public CharIterator() {
        this(new CharArray(), 0);
    }

    public CharIterator(char[] cArray, int n) {
        this(new CharArray(cArray), n);
    }

    public CharIterator(CharArray charArray, int n) {
        this.buffer = charArray.array;
        this.original = charArray;
        this.index = n;
    }

    public CharIterator(CharBuffer charBuffer, int n) {
        this.buffer = charBuffer.storage;
        this.original = charBuffer;
        this.index = n;
    }

    public CharIterator(CharIterator charIterator) {
        this.buffer = charIterator.buffer;
        this.original = charIterator.original;
        this.index = charIterator.index;
    }

    public void advance() {
        ++this.index;
    }

    public void advance(int n) {
        this.index += n;
    }

    public boolean atBegin() {
        return this.index == 0;
    }

    public boolean atEnd() {
        return this.index == this.original.size();
    }

    public static CharIterator begin(char[] cArray) {
        return new CharIterator(cArray, 0);
    }

    public Object clone() {
        return new CharIterator(this);
    }

    public int distance(ForwardIterator forwardIterator) {
        if (!this.isCompatibleWith(forwardIterator)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((CharIterator)forwardIterator).index - this.index;
    }

    public static CharIterator end(char[] cArray) {
        return new CharIterator(cArray, cArray.length);
    }

    public boolean equals(CharIterator charIterator) {
        return charIterator.index == this.index && charIterator.buffer == this.buffer;
    }

    public boolean equals(Object object) {
        return object instanceof CharIterator && this.equals((CharIterator)object);
    }

    public Object get() {
        return this.get(0);
    }

    public Object get(int n) {
        return new Character(this.buffer[this.index + n]);
    }

    public char getChar() {
        return this.getChar(0);
    }

    public char getChar(int n) {
        return this.buffer[this.index + n];
    }

    public Container getContainer() {
        return this.original;
    }

    public boolean hasMoreElements() {
        return this.index < this.original.size();
    }

    public int index() {
        return this.index;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof CharIterator && this.buffer == ((CharIterator)inputIterator).buffer;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.index < ((CharIterator)randomAccessIterator).index;
    }

    public Object nextElement() {
        try {
            Object object = this.get();
            this.advance();
            return object;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("CharIterator");
        }
    }

    public void put(char c) {
        this.put(0, c);
    }

    public void put(int n, char c) {
        this.buffer[this.index + n] = c;
    }

    public void put(int n, Object object) {
        this.put(n, CharBuffer.asChar(object));
    }

    public void put(Object object) {
        this.put(0, object);
    }

    public void retreat() {
        --this.index;
    }

    public void retreat(int n) {
        this.index -= n;
    }
}

