/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.CharBuffer;
import com.objectspace.jgl.adapters.CharIterator;
import java.util.Enumeration;

public class CharArray
extends ArrayAdapter {
    char[] array;
    static final long serialVersionUID = -7920180968357434958L;

    public CharArray() {
        this(new char[0]);
    }

    public CharArray(char[] cArray) {
        this.array = cArray;
    }

    public CharArray(CharArray charArray) {
        this(charArray.array);
    }

    public CharArray(CharBuffer charBuffer) {
        this(charBuffer.get());
    }

    public Object at(int n) {
        return new Character(this.charAt(n));
    }

    public synchronized CharIterator begin() {
        return new CharIterator(this, 0);
    }

    public synchronized char charAt(int n) {
        return this.array[n];
    }

    public synchronized Object clone() {
        return new CharArray(this);
    }

    public Enumeration elements() {
        return this.begin();
    }

    public synchronized CharIterator end() {
        return new CharIterator(this, this.array.length);
    }

    public synchronized boolean equals(char[] cArray) {
        char[] cArray2 = cArray;
        synchronized (cArray) {
            if (this.array.length != cArray.length) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            int n = 0;
            while (n < cArray.length) {
                if (this.array[n] != cArray[n]) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    public boolean equals(CharArray charArray) {
        return this.equals(charArray.array);
    }

    public boolean equals(CharBuffer charBuffer) {
        return this.equals(charBuffer.storage);
    }

    public boolean equals(Object object) {
        return object instanceof CharArray && this.equals((CharArray)object) || object instanceof CharBuffer && this.equals((CharBuffer)object);
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public char[] get() {
        return this.array;
    }

    public int maxSize() {
        return this.array.length;
    }

    public synchronized void put(int n, char c) {
        this.array[n] = c;
    }

    public void put(int n, Object object) {
        this.put(n, ((Character)object).charValue());
    }

    public int size() {
        return this.array.length;
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public synchronized String toString() {
        return Algorithms.toString(this, "char[]");
    }
}

