/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.adapters.ByteArray;
import com.objectspace.jgl.adapters.ByteBuffer;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class ByteIterator
implements RandomAccessIterator,
Serializable {
    byte[] buffer;
    Container original;
    int index;
    static final long serialVersionUID = 4883976831804292945L;

    public ByteIterator() {
        this(new ByteArray(), 0);
    }

    public ByteIterator(byte[] byArray, int n) {
        this(new ByteArray(byArray), n);
    }

    public ByteIterator(ByteArray byteArray, int n) {
        this.buffer = byteArray.array;
        this.original = byteArray;
        this.index = n;
    }

    public ByteIterator(ByteBuffer byteBuffer, int n) {
        this.buffer = byteBuffer.storage;
        this.original = byteBuffer;
        this.index = n;
    }

    public ByteIterator(ByteIterator byteIterator) {
        this.buffer = byteIterator.buffer;
        this.original = byteIterator.original;
        this.index = byteIterator.index;
    }

    public void advance() {
        ++this.index;
    }

    public void advance(int n) {
        this.index += n;
    }

    public boolean atBegin() {
        return this.index == 0;
    }

    public boolean atEnd() {
        return this.index == this.original.size();
    }

    public static ByteIterator begin(byte[] byArray) {
        return new ByteIterator(byArray, 0);
    }

    public Object clone() {
        return new ByteIterator(this);
    }

    public int distance(ForwardIterator forwardIterator) {
        if (!this.isCompatibleWith(forwardIterator)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((ByteIterator)forwardIterator).index - this.index;
    }

    public static ByteIterator end(byte[] byArray) {
        return new ByteIterator(byArray, byArray.length);
    }

    public boolean equals(ByteIterator byteIterator) {
        return byteIterator.index == this.index && byteIterator.buffer == this.buffer;
    }

    public boolean equals(Object object) {
        return object instanceof ByteIterator && this.equals((ByteIterator)object);
    }

    public Object get() {
        return this.get(0);
    }

    public Object get(int n) {
        return new Byte(this.buffer[this.index + n]);
    }

    public byte getByte() {
        return this.getByte(0);
    }

    public byte getByte(int n) {
        return this.buffer[this.index + n];
    }

    public Container getContainer() {
        return this.original;
    }

    public boolean hasMoreElements() {
        return this.index < this.original.size();
    }

    public int index() {
        return this.index;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof ByteIterator && this.buffer == ((ByteIterator)inputIterator).buffer;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.index < ((ByteIterator)randomAccessIterator).index;
    }

    public Object nextElement() {
        try {
            Object object = this.get();
            this.advance();
            return object;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("ByteIterator");
        }
    }

    public void put(byte by) {
        this.put(0, by);
    }

    public void put(int n, byte by) {
        this.buffer[this.index + n] = by;
    }

    public void put(int n, Object object) {
        this.put(n, ByteBuffer.asByte(object));
    }

    public void put(Object object) {
        this.put(0, object);
    }

    public void retreat() {
        --this.index;
    }

    public void retreat(int n) {
        this.index -= n;
    }
}

