/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.ByteArray;
import com.objectspace.jgl.adapters.ByteIterator;
import java.util.Enumeration;

public class ByteBuffer
implements Sequence {
    static final byte defaultValue = 0;
    byte[] storage;
    int length;
    static final long serialVersionUID = 4412460359937432540L;

    public ByteBuffer() {
        this.clear();
    }

    public ByteBuffer(byte[] byArray) {
        this(byArray, true);
    }

    ByteBuffer(byte[] byArray, boolean bl) {
        byte[] byArray2 = byArray;
        synchronized (byArray) {
            this.length = byArray.length;
            if (bl) {
                this.storage = new byte[this.length];
                System.arraycopy(byArray, 0, this.storage, 0, this.length);
            } else {
                this.storage = byArray;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public ByteBuffer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to create an ByteBuffer with a negative size");
        }
        this.length = n;
        this.storage = new byte[this.length];
    }

    public ByteBuffer(int n, byte by) {
        this(n);
        int n2 = 0;
        while (n2 < this.length) {
            this.storage[n2] = by;
            ++n2;
        }
    }

    public ByteBuffer(ByteBuffer byteBuffer) {
        this(byteBuffer.storage);
    }

    public synchronized void add(byte by) {
        if (this.length == this.storage.length) {
            byte[] byArray = this.getNextStorage(1);
            this.copyTo(byArray);
            this.storage = byArray;
        }
        this.storage[this.length++] = by;
    }

    public synchronized Object add(Object object) {
        this.add(ByteBuffer.asByte(object));
        return null;
    }

    static byte asByte(Object object) {
        return ((Number)object).byteValue();
    }

    public Object at(int n) {
        return new Byte(this.byteAt(n));
    }

    public Object back() {
        return this.at(this.size() - 1);
    }

    public synchronized ByteIterator begin() {
        return new ByteIterator(this, 0);
    }

    public synchronized byte byteAt(int n) {
        ArrayAdapter.checkIndex(n, this.length);
        return this.storage[n];
    }

    public int capacity() {
        return this.storage.length;
    }

    public synchronized void clear() {
        this.storage = new byte[10];
        this.length = 0;
    }

    public synchronized Object clone() {
        return new ByteBuffer(this);
    }

    public boolean contains(byte by) {
        return this.indexOf(by) != -1;
    }

    public boolean contains(Object object) {
        return this.contains(ByteBuffer.asByte(object));
    }

    public synchronized void copy(ByteBuffer byteBuffer) {
        if (this == byteBuffer) {
            return;
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        synchronized (byteBuffer2) {
            if (byteBuffer.length > this.storage.length) {
                this.storage = byteBuffer.get();
            } else {
                System.arraycopy(byteBuffer.storage, 0, this.storage, 0, byteBuffer.length);
                int n = byteBuffer.length;
                while (n < this.length) {
                    this.storage[n] = 0;
                    ++n;
                }
            }
            this.length = byteBuffer.length;
        }
    }

    public synchronized void copyTo(byte[] byArray) {
        byte[] byArray2 = byArray;
        synchronized (byArray) {
            System.arraycopy(this.storage, 0, byArray, 0, Math.min(this.length, byArray.length));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int count(byte by) {
        return this.count(0, this.length - 1, by);
    }

    public synchronized int count(int n, int n2, byte by) {
        ArrayAdapter.checkRange(n, n2, this.length);
        int n3 = 0;
        while (n < n2) {
            if (this.storage[n] == by) {
                ++n3;
            }
            ++n;
        }
        return n3;
    }

    public int count(int n, int n2, Object object) {
        return this.count(n, n2, ByteBuffer.asByte(object));
    }

    public int count(Object object) {
        return this.count(ByteBuffer.asByte(object));
    }

    public Enumeration elements() {
        return this.begin();
    }

    public synchronized ByteIterator end() {
        return new ByteIterator(this, this.length);
    }

    public synchronized void ensureCapacity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to reserve a negative size.");
        }
        if (this.storage.length < n) {
            byte[] byArray = new byte[n];
            if (this.length > 0) {
                System.arraycopy(this.storage, 0, byArray, 0, this.length);
            }
            this.storage = byArray;
        }
    }

    public boolean equals(byte[] byArray) {
        return this.equals(new ByteArray(byArray));
    }

    public synchronized boolean equals(ByteArray byteArray) {
        return byteArray.equals(this.storage);
    }

    public boolean equals(ByteBuffer byteBuffer) {
        return this.equals(new ByteArray(byteBuffer.storage));
    }

    public boolean equals(Object object) {
        return object instanceof ByteBuffer && this.equals((ByteBuffer)object) || object instanceof ByteArray && this.equals((ByteArray)object);
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public Object front() {
        return this.at(0);
    }

    public synchronized byte[] get() {
        byte[] byArray = new byte[this.length];
        this.copyTo(byArray);
        return byArray;
    }

    private byte[] getNextStorage(int n) {
        int n2 = Math.max(ArrayAdapter.getNextSize(this.length), this.length + n);
        byte[] byArray = new byte[n2];
        return byArray;
    }

    public synchronized int hashCode() {
        return Algorithms.orderedHash(this.begin(), this.length);
    }

    public int indexOf(byte by) {
        return this.indexOf(0, this.length - 1, by);
    }

    public synchronized int indexOf(int n, int n2, byte by) {
        if (n2 < n) {
            return -1;
        }
        ArrayAdapter.checkRange(n, n2, this.length);
        while (n < n2) {
            if (this.storage[n] == by) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(int n, int n2, Object object) {
        return this.indexOf(n, n2, ByteBuffer.asByte(object));
    }

    public int indexOf(Object object) {
        return this.indexOf(ByteBuffer.asByte(object));
    }

    public synchronized void insert(int n, byte by) {
        ArrayAdapter.checkIndex(n, this.length + 1);
        if (this.length != this.storage.length) {
            if (n != this.length) {
                System.arraycopy(this.storage, n, this.storage, n + 1, this.length - n);
            }
        } else {
            byte[] byArray = this.getNextStorage(1);
            System.arraycopy(this.storage, 0, byArray, 0, n);
            System.arraycopy(this.storage, n, byArray, n + 1, this.length - n);
            this.storage = byArray;
        }
        this.storage[n] = by;
        ++this.length;
    }

    public synchronized void insert(int n, int n2, byte by) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects.");
        }
        if (n2 == 0) {
            return;
        }
        ArrayAdapter.checkIndex(n, this.length + 1);
        if (this.storage.length - this.length >= n2) {
            System.arraycopy(this.storage, n, this.storage, n + n2, this.length - n);
        } else {
            byte[] byArray = this.getNextStorage(n2);
            System.arraycopy(this.storage, 0, byArray, 0, n);
            System.arraycopy(this.storage, n, byArray, n + n2, this.length - n);
            this.storage = byArray;
        }
        int n3 = n;
        while (n3 < n + n2) {
            this.storage[n3] = by;
            ++n3;
        }
        this.length += n2;
    }

    public void insert(int n, int n2, Object object) {
        this.insert(n, n2, ByteBuffer.asByte(object));
    }

    public synchronized void insert(int n, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        int n2 = forwardIterator.distance(forwardIterator2);
        if (n2 == 0) {
            return;
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        if (this.storage.length - this.length >= n2) {
            System.arraycopy(this.storage, n, this.storage, n + n2, this.length - n);
        } else {
            byte[] byArray = this.getNextStorage(n2);
            System.arraycopy(this.storage, 0, byArray, 0, n);
            System.arraycopy(this.storage, n, byArray, n + n2, this.length - n);
            this.storage = byArray;
        }
        this.length += n2;
        int n3 = n;
        while (n3 < n + n2) {
            this.put(n3, forwardIterator3.nextElement());
            ++n3;
        }
    }

    public void insert(int n, Object object) {
        this.insert(n, ByteBuffer.asByte(object));
    }

    public ByteIterator insert(ByteIterator byteIterator, byte by) {
        this.insert(byteIterator.index, by);
        return new ByteIterator(this, byteIterator.index);
    }

    public void insert(ByteIterator byteIterator, int n, byte by) {
        this.insert(byteIterator.index, n, by);
    }

    public void insert(ByteIterator byteIterator, int n, Object object) {
        this.insert(byteIterator, n, ByteBuffer.asByte(object));
    }

    public void insert(ByteIterator byteIterator, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        this.insert(byteIterator.index, forwardIterator, forwardIterator2);
    }

    public ByteIterator insert(ByteIterator byteIterator, Object object) {
        return this.insert(byteIterator, ByteBuffer.asByte(object));
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public synchronized Object popBack() {
        if (this.length == 0) {
            throw new InvalidOperationException("ByteBuffer is empty");
        }
        Byte by = new Byte(this.storage[--this.length]);
        this.storage[this.length] = 0;
        return by;
    }

    public synchronized Object popFront() {
        if (this.length == 0) {
            throw new InvalidOperationException("ByteBuffer is empty");
        }
        Byte by = new Byte(this.storage[0]);
        this.remove(0);
        return by;
    }

    public void pushBack(byte by) {
        this.add(by);
    }

    public void pushBack(Object object) {
        this.add(ByteBuffer.asByte(object));
    }

    public void pushFront(byte by) {
        this.insert(0, by);
    }

    public void pushFront(Object object) {
        this.insert(0, object);
    }

    public synchronized void put(int n, byte by) {
        ArrayAdapter.checkIndex(n, this.length);
        this.storage[n] = by;
    }

    public synchronized void put(int n, Object object) {
        this.put(n, ByteBuffer.asByte(object));
    }

    public synchronized Object remove(int n) {
        ArrayAdapter.checkIndex(n, this.length);
        Byte by = new Byte(this.storage[n]);
        System.arraycopy(this.storage, n + 1, this.storage, n, this.length - n - 1);
        this.storage[--this.length] = 0;
        return by;
    }

    public synchronized int remove(int n, int n2) {
        if (n2 < n) {
            return 0;
        }
        ArrayAdapter.checkRange(n, n2, this.length);
        int n3 = n2 - n + 1;
        System.arraycopy(this.storage, n2 + 1, this.storage, n, this.length - n2 - 1);
        int n4 = this.length - n3;
        while (n4 < this.length) {
            this.storage[n4] = 0;
            ++n4;
        }
        this.length -= n3;
        return n3;
    }

    public synchronized int remove(int n, int n2, Object object) {
        ByteBuffer.asByte(object);
        if (n2 < n) {
            return 0;
        }
        ArrayAdapter.checkRange(n, n2, this.length);
        ByteIterator byteIterator = new ByteIterator(this, n);
        ByteIterator byteIterator2 = new ByteIterator(this, n2 + 1);
        ByteIterator byteIterator3 = (ByteIterator)Algorithms.remove(byteIterator, byteIterator2, object);
        return this.remove(byteIterator3.index, n2);
    }

    public int remove(Object object) {
        return this.remove(object, this.length);
    }

    public synchronized int remove(Object object, int n) {
        byte by = ByteBuffer.asByte(object);
        int n2 = 0;
        while (n > 0) {
            int n3 = this.indexOf(by);
            if (n3 < 0) break;
            --n;
            ++n2;
            this.remove(n3);
        }
        return n2;
    }

    public Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof ByteIterator)) {
            throw new IllegalArgumentException("Enumeration not an ByteIterator");
        }
        if (((ByteIterator)enumeration).buffer != this.storage) {
            throw new IllegalArgumentException("Enumeration not for this ByteBuffer ");
        }
        Object object = ((ByteIterator)enumeration).get();
        this.remove(((ByteIterator)enumeration).index);
        return object;
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        if (!(enumeration instanceof ByteIterator) || !(enumeration2 instanceof ByteIterator)) {
            throw new IllegalArgumentException("Enumeration not an ByteIterator");
        }
        if (((ByteIterator)enumeration).buffer != this.storage || ((ByteIterator)enumeration).isCompatibleWith((ByteIterator)enumeration2)) {
            throw new IllegalArgumentException("Enumeration not compatible");
        }
        return this.remove(((ByteIterator)enumeration).index, ((ByteIterator)enumeration2).index - 1);
    }

    public int replace(byte by, byte by2) {
        return this.replace(0, this.length - 1, by, by2);
    }

    public synchronized int replace(int n, int n2, byte by, byte by2) {
        ArrayAdapter.checkRange(n, n2, this.length);
        int n3 = 0;
        while (n < n2) {
            if (this.storage[n] == by) {
                this.storage[n] = by2;
                ++n3;
            }
            ++n;
        }
        return n3;
    }

    public int replace(int n, int n2, Object object, Object object2) {
        return this.replace(n, n2, ByteBuffer.asByte(object), ByteBuffer.asByte(object2));
    }

    public int replace(Object object, Object object2) {
        return this.replace(ByteBuffer.asByte(object), ByteBuffer.asByte(object2));
    }

    public synchronized void setSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to become a negative size.");
        }
        if (this.length > n) {
            this.remove(n, this.length - 1);
        } else if (this.length < n) {
            this.insert(this.length, n - this.length, (byte)0);
        }
    }

    public int size() {
        return this.length;
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public synchronized void swap(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer;
        synchronized (byteBuffer2) {
            int n = this.length;
            byte[] byArray = this.storage;
            this.length = byteBuffer.length;
            this.storage = byteBuffer.storage;
            byteBuffer.length = n;
            byteBuffer.storage = byArray;
        }
    }

    public synchronized String toString() {
        return Algorithms.toString(this, "ByteBuffer");
    }

    public synchronized void trimToSize() {
        if (this.length < this.storage.length) {
            this.storage = this.get();
        }
    }
}

