/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.adapters.BooleanArray;
import com.objectspace.jgl.adapters.BooleanBuffer;
import com.objectspace.jgl.adapters.ByteBuffer;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class BooleanIterator
implements RandomAccessIterator,
Serializable {
    byte offset;
    int index;
    Sequence original;
    static final long serialVersionUID = 9093107050268453497L;

    public BooleanIterator() {
        this(new BooleanArray(), 0);
    }

    BooleanIterator(boolean[] blArray, int n) {
        this(new BooleanArray(blArray), n);
    }

    BooleanIterator(BooleanArray booleanArray, int n) {
        this.offset = (byte)-1;
        this.index = n;
        this.original = booleanArray;
    }

    public BooleanIterator(BooleanBuffer booleanBuffer, int n) {
        this.original = booleanBuffer;
        this.index = n / 8;
        this.offset = (byte)(n % 8);
    }

    public BooleanIterator(BooleanIterator booleanIterator) {
        this.offset = booleanIterator.offset;
        this.index = booleanIterator.index;
        this.original = booleanIterator.original;
    }

    public void advance() {
        if (this.offset == -1) {
            ++this.index;
        } else {
            this.offset = (byte)(this.offset + 1);
            if (this.offset == 8) {
                this.offset = 0;
                ++this.index;
            }
        }
    }

    public void advance(int n) {
        if (this.offset == -1) {
            this.index += n;
        } else {
            byte by = this.offset;
            this.offset = (byte)(n % 8);
            this.index += n / 8;
            if (by > this.offset) {
                ++this.index;
            }
        }
    }

    public boolean atBegin() {
        return this.index == 0 && (this.offset == -1 || this.offset == 0);
    }

    public boolean atEnd() {
        return this.offset == -1 ? this.index == this.original.size() : this.equals(this.original.finish());
    }

    public static BooleanIterator begin(boolean[] blArray) {
        return new BooleanIterator(blArray, 0);
    }

    public Object clone() {
        return new BooleanIterator(this);
    }

    public int distance(ForwardIterator forwardIterator) {
        if (!this.isCompatibleWith(forwardIterator)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((BooleanIterator)forwardIterator).index() - this.index();
    }

    public static BooleanIterator end(boolean[] blArray) {
        return new BooleanIterator(blArray, blArray.length);
    }

    public boolean equals(BooleanIterator booleanIterator) {
        return this.index == booleanIterator.index && this.offset == booleanIterator.offset && this.isCompatibleWith(booleanIterator);
    }

    public boolean equals(Object object) {
        return object instanceof BooleanIterator && this.equals((BooleanIterator)object);
    }

    public Object get() {
        return this.get(0);
    }

    public Object get(int n) {
        return new Boolean(this.getBoolean(n));
    }

    public boolean getBoolean() {
        return this.getBoolean(0);
    }

    public boolean getBoolean(int n) {
        return this.original instanceof BooleanArray ? ((BooleanArray)this.original).booleanAt(this.index + n) : (((BooleanBuffer)this.original).storage.byteAt(this.index) & this.mask()) > 0;
    }

    public Container getContainer() {
        return this.original;
    }

    public boolean hasMoreElements() {
        return !this.atEnd();
    }

    public int index() {
        return this.offset == -1 ? this.index : this.index * 8 + this.offset;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        if (inputIterator instanceof BooleanIterator) {
            BooleanIterator booleanIterator = (BooleanIterator)inputIterator;
            if (this.original instanceof BooleanArray) {
                return booleanIterator.original instanceof BooleanArray && ((BooleanArray)this.original).array == ((BooleanArray)booleanIterator.original).array;
            }
            return this.original instanceof BooleanBuffer && booleanIterator.original instanceof BooleanBuffer && ((BooleanBuffer)this.original).storage == ((BooleanBuffer)booleanIterator.original).storage;
        }
        return false;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        if (this.offset == -1 && this.index == ((BooleanIterator)randomAccessIterator).index) {
            return this.offset < ((BooleanIterator)randomAccessIterator).offset;
        }
        return this.index < ((BooleanIterator)randomAccessIterator).index;
    }

    final byte mask() {
        return (byte)(1 << this.offset);
    }

    public Object nextElement() {
        try {
            Object object = this.get();
            this.advance();
            return object;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("BooleanIterator");
        }
    }

    public void put(int n, Object object) {
        this.put(n, BooleanBuffer.asBoolean(object));
    }

    public void put(int n, boolean bl) {
        if (this.original instanceof BooleanArray) {
            ((BooleanArray)this.original).put(n, bl);
        } else {
            ByteBuffer byteBuffer = ((BooleanBuffer)this.original).storage;
            byte by = byteBuffer.byteAt(this.index);
            by = bl ? (byte)(by | this.mask()) : (byte)(by & ~this.mask());
            byteBuffer.put(this.index, by);
        }
    }

    public void put(Object object) {
        this.put(0, object);
    }

    public void put(boolean bl) {
        this.put(0, bl);
    }

    public void retreat() {
        if (this.offset == -1) {
            --this.index;
        } else if (this.offset == 0) {
            this.offset = (byte)7;
            --this.index;
        } else {
            this.offset = (byte)(this.offset - 1);
        }
    }

    public void retreat(int n) {
        if (this.offset == -1) {
            this.index -= n;
        } else {
            byte by = this.offset;
            this.offset = (byte)((this.offset + 8 - n % 8) % 8);
            this.index += n / 8;
            if (by < this.offset) {
                ++this.index;
            }
        }
    }
}

