/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.BooleanArray;
import com.objectspace.jgl.adapters.BooleanIterator;
import com.objectspace.jgl.adapters.ByteBuffer;
import com.objectspace.jgl.adapters.ByteIterator;
import java.util.BitSet;
import java.util.Enumeration;

public class BooleanBuffer
extends ArrayAdapter {
    ByteBuffer storage;
    int size;
    static final long serialVersionUID = -1087317977793221720L;

    public BooleanBuffer() {
        this(0);
    }

    public BooleanBuffer(boolean[] blArray) {
        this(new BooleanArray(blArray));
    }

    public BooleanBuffer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to create an BooleanBuffer with a negative size");
        }
        this.storage = new ByteBuffer(n / 8 + 1);
        this.size = n;
    }

    public BooleanBuffer(int n, boolean bl) {
        this(n);
        int n2 = 0;
        while (n2 < this.storage.size()) {
            this.storage.put(n2, (byte)(bl ? 255 : 0));
            ++n2;
        }
    }

    public BooleanBuffer(BooleanArray booleanArray) {
        this(booleanArray.size());
        Algorithms.copy(booleanArray.begin(), booleanArray.end(), this.begin());
    }

    public BooleanBuffer(BooleanBuffer booleanBuffer) {
        this.storage = booleanBuffer.storage;
        this.size = booleanBuffer.size;
    }

    BooleanBuffer(ByteBuffer byteBuffer) {
        this.storage = byteBuffer;
        this.size = 0;
    }

    public BooleanBuffer(BitSet bitSet) {
        this(bitSet.size());
        BooleanIterator booleanIterator = this.begin();
        BitSet bitSet2 = bitSet;
        synchronized (bitSet2) {
            int n = 0;
            while (n < this.size()) {
                booleanIterator.put(n, bitSet.get(n));
                ++n;
            }
        }
    }

    public Object add(Object object) {
        this.add(BooleanBuffer.asBoolean(object));
        return null;
    }

    public synchronized void add(boolean bl) {
        BooleanIterator booleanIterator = new BooleanIterator(this, this.size);
        if (this.atEnd()) {
            this.insertAux(booleanIterator, bl);
        } else {
            ++this.size;
            booleanIterator.put(bl);
        }
    }

    static final boolean asBoolean(Object object) {
        return (Boolean)object;
    }

    public synchronized Object at(int n) {
        ArrayAdapter.checkIndex(n, this.size);
        return new BooleanIterator(this, n).get();
    }

    private final boolean atEnd() {
        return this.size / 8 == this.storage.size();
    }

    public synchronized BooleanIterator begin() {
        return new BooleanIterator(this, 0);
    }

    public boolean booleanAt(int n) {
        return (Boolean)this.at(n);
    }

    public int capacity() {
        return this.storage.size() * 8 - 1;
    }

    public synchronized void clear() {
        this.storage.clear();
        this.size = 0;
    }

    public synchronized Object clone() {
        return new BooleanBuffer(this);
    }

    public boolean contains(boolean bl) {
        return this.indexOf(bl) != -1;
    }

    public synchronized void copy(BooleanBuffer booleanBuffer) {
        if (this == booleanBuffer) {
            return;
        }
        this.storage = new ByteBuffer(booleanBuffer.storage);
        this.size = booleanBuffer.size;
    }

    public synchronized void copyTo(boolean[] blArray) {
        boolean[] blArray2 = blArray;
        synchronized (blArray) {
            int n = 0;
            BooleanIterator booleanIterator = this.begin();
            while (n < this.size()) {
                blArray[n] = booleanIterator.getBoolean(n);
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public synchronized void copyTo(BitSet bitSet) {
        BitSet bitSet2 = bitSet;
        synchronized (bitSet2) {
            int n = 0;
            BooleanIterator booleanIterator = this.begin();
            while (n < this.size()) {
                if (booleanIterator.getBoolean(n)) {
                    bitSet.set(n);
                } else {
                    bitSet.clear(n);
                }
                ++n;
            }
        }
    }

    public synchronized int count(int n, int n2, Object object) {
        if (n2 < n) {
            return -1;
        }
        ArrayAdapter.checkRange(n, n2, this.size);
        int n3 = ((BooleanIterator)Algorithms.find(new BooleanIterator(this, n), new BooleanIterator(this, n2 + 1), object)).index();
        return n3 == n2 + 1 ? -1 : n3;
    }

    public int count(int n, int n2, boolean bl) {
        return this.count(n, n2, new Boolean(bl));
    }

    public int count(Object object) {
        return Algorithms.count(this.begin(), this.end(), object);
    }

    public int count(boolean bl) {
        return this.count(new Boolean(bl));
    }

    public synchronized Enumeration elements() {
        return this.begin();
    }

    public synchronized BooleanIterator end() {
        return new BooleanIterator(this, this.size);
    }

    public synchronized void ensureCapacity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to reserve a negative size.");
        }
        if (this.capacity() < n) {
            this.storage.ensureCapacity(n / 8 + 1);
        }
    }

    public boolean equals(boolean[] blArray) {
        return this.equals(new BooleanArray(blArray));
    }

    public boolean equals(BooleanArray booleanArray) {
        BooleanArray booleanArray2 = booleanArray;
        synchronized (booleanArray2) {
            return Algorithms.equal(this, booleanArray);
        }
    }

    public boolean equals(BooleanBuffer booleanBuffer) {
        BooleanBuffer booleanBuffer2 = booleanBuffer;
        synchronized (booleanBuffer2) {
            return Algorithms.equal(this, booleanBuffer);
        }
    }

    public boolean equals(Object object) {
        return object instanceof BooleanBuffer && this.equals((BooleanBuffer)object) || object instanceof BooleanArray && this.equals((BooleanArray)object);
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized boolean[] get() {
        boolean[] blArray = new boolean[this.size()];
        this.copyTo(blArray);
        return blArray;
    }

    public synchronized int hashCode() {
        return this.storage.hashCode();
    }

    public int indexOf(int n, int n2, Object object) {
        if (n2 < n) {
            return -1;
        }
        ArrayAdapter.checkRange(n, n2, this.size);
        int n3 = ((BooleanIterator)Algorithms.find(new BooleanIterator(this, n), new BooleanIterator(this, n2 + 1), object)).index();
        return n3 == n2 + 1 ? -1 : n3;
    }

    public synchronized int indexOf(int n, int n2, boolean bl) {
        return this.indexOf(n, n2, new Boolean(bl));
    }

    public int indexOf(boolean bl) {
        return this.indexOf(0, this.size() - 1, bl);
    }

    public void insert(int n, int n2, Object object) {
        ArrayAdapter.checkIndex(n, this.size + 1);
        this.insert(new BooleanIterator(this, n), n2, object);
    }

    public synchronized void insert(int n, int n2, boolean bl) {
        this.insert(n, n2, (Object)new Boolean(bl));
    }

    public synchronized void insert(int n, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        ArrayAdapter.checkIndex(n, this.size + 1);
        this.insert(new BooleanIterator(this, n), forwardIterator, forwardIterator2);
    }

    public void insert(int n, Object object) {
        this.insert(n, BooleanBuffer.asBoolean(object));
    }

    public synchronized void insert(int n, boolean bl) {
        ArrayAdapter.checkIndex(n, this.size + 1);
        this.insert(new BooleanIterator(this, n), bl);
    }

    public void insert(BooleanIterator booleanIterator, int n, Object object) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects.");
        }
        if (n == 0) {
            return;
        }
        if (this.capacity() - this.size >= n) {
            BooleanIterator booleanIterator2 = new BooleanIterator(this, this.size + n);
            Algorithms.copyBackward(booleanIterator, new BooleanIterator(this, this.size), booleanIterator2);
            Algorithms.fill(booleanIterator, new BooleanIterator(this, booleanIterator.index() + n), object);
            this.size += n;
        } else {
            BooleanBuffer booleanBuffer = new BooleanBuffer(new ByteBuffer(new byte[this.size + Math.max(this.size, n)], false));
            Algorithms.copy(this.storage.begin(), new ByteIterator(this.storage, booleanIterator.index() < this.size ? booleanIterator.index + 1 : booleanIterator.index), booleanBuffer.storage.begin());
            BooleanIterator booleanIterator3 = new BooleanIterator(booleanBuffer, booleanIterator.index());
            while (n-- > 0) {
                booleanIterator3.put(object);
                booleanIterator3.advance();
            }
            Algorithms.copy(booleanIterator, new BooleanIterator(this, this.size), booleanIterator3);
            this.copy(booleanBuffer);
        }
    }

    public void insert(BooleanIterator booleanIterator, int n, boolean bl) {
        this.insert(booleanIterator, n, (Object)new Boolean(bl));
    }

    public void insert(BooleanIterator booleanIterator, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        int n = forwardIterator.distance(forwardIterator2);
        if (n == 0) {
            return;
        }
        if (this.capacity() - this.size >= n) {
            BooleanIterator booleanIterator2 = new BooleanIterator(this, this.size + n);
            Algorithms.copyBackward(booleanIterator, new BooleanIterator(this, this.size), booleanIterator2);
            Algorithms.copy(forwardIterator, forwardIterator2, booleanIterator);
            this.size += n;
        } else {
            BooleanBuffer booleanBuffer = new BooleanBuffer(new ByteBuffer(new byte[this.size + Math.max(this.size, n)], false));
            Algorithms.copy(this.storage.begin(), new ByteIterator(this.storage, booleanIterator.index() < this.size ? booleanIterator.index + 1 : booleanIterator.index), booleanBuffer.storage.begin());
            BooleanIterator booleanIterator3 = new BooleanIterator(booleanBuffer, booleanIterator.index());
            Algorithms.copy(forwardIterator, forwardIterator2, booleanIterator3);
            booleanIterator3.advance(n);
            Algorithms.copy(booleanIterator, new BooleanIterator(this, this.size), booleanIterator3);
            this.copy(booleanBuffer);
        }
    }

    public BooleanIterator insert(BooleanIterator booleanIterator, Object object) {
        return this.insert(booleanIterator, BooleanBuffer.asBoolean(object));
    }

    public BooleanIterator insert(BooleanIterator booleanIterator, boolean bl) {
        int n = booleanIterator.index();
        if (n == this.size) {
            this.pushBack(bl);
        } else {
            this.insertAux(booleanIterator, bl);
        }
        return new BooleanIterator(this, n);
    }

    private void insertAux(BooleanIterator booleanIterator, boolean bl) {
        if (this.atEnd()) {
            BooleanBuffer booleanBuffer = new BooleanBuffer(new ByteBuffer(new byte[ArrayAdapter.getNextSize(this.size)], false));
            Algorithms.copy(this.storage.begin(), new ByteIterator(this.storage, booleanIterator.index() < this.size ? booleanIterator.index + 1 : booleanIterator.index), booleanBuffer.storage.begin());
            BooleanIterator booleanIterator2 = new BooleanIterator(booleanBuffer, booleanIterator.index());
            booleanIterator2.put(bl);
            booleanIterator2.advance();
            Algorithms.copy(booleanIterator, new BooleanIterator(this, this.size), booleanIterator2);
            this.copy(booleanBuffer);
        } else {
            Algorithms.copyBackward(booleanIterator, new BooleanIterator(this, this.size + 1), new BooleanIterator(this, this.size));
            booleanIterator.put(bl);
        }
    }

    public synchronized Object popBack() {
        if (this.size == 0) {
            throw new InvalidOperationException("BooleanBuffer is empty");
        }
        return new BooleanIterator(this, --this.size).get();
    }

    public synchronized Object popFront() {
        if (this.size() == 0) {
            throw new InvalidOperationException("BooleanBuffer is empty");
        }
        Object object = this.at(0);
        this.remove(0);
        return object;
    }

    public void pushBack(Object object) {
        this.add(BooleanBuffer.asBoolean(object));
    }

    public void pushBack(boolean bl) {
        this.add(bl);
    }

    public void pushFront(Object object) {
        this.insert(0, object);
    }

    public void pushFront(boolean bl) {
        this.insert(0, bl);
    }

    public void put(int n, Object object) {
        this.put(n, BooleanBuffer.asBoolean(object));
    }

    public synchronized void put(int n, boolean bl) {
        ArrayAdapter.checkIndex(n, this.size);
        this.begin().put(n, bl);
    }

    public synchronized Object remove(int n) {
        ArrayAdapter.checkIndex(n, this.size);
        return this.remove(new BooleanIterator(this, n));
    }

    public synchronized int remove(int n, int n2) {
        if (n2 < n) {
            return 0;
        }
        ArrayAdapter.checkRange(n, n2, this.size);
        return this.remove(new BooleanIterator(this, n), new BooleanIterator(this, n2));
    }

    public synchronized int remove(int n, int n2, Object object) {
        BooleanBuffer.asBoolean(object);
        if (n2 < n) {
            return 0;
        }
        ArrayAdapter.checkRange(n, n2, this.size);
        BooleanIterator booleanIterator = new BooleanIterator(this, n);
        BooleanIterator booleanIterator2 = new BooleanIterator(this, n2 + 1);
        BooleanIterator booleanIterator3 = (BooleanIterator)Algorithms.remove(booleanIterator, booleanIterator2, object);
        return this.remove(booleanIterator3.index(), n2);
    }

    public int remove(Object object) {
        return this.remove(object, this.size());
    }

    public synchronized int remove(Object object, int n) {
        boolean bl = BooleanBuffer.asBoolean(object);
        int n2 = 0;
        while (n > 0) {
            int n3 = this.indexOf(bl);
            if (n3 < 0) break;
            --n;
            ++n2;
            this.remove(n3);
        }
        return n2;
    }

    public Object remove(Enumeration enumeration) {
        BooleanIterator booleanIterator;
        if (!(enumeration instanceof BooleanIterator)) {
            throw new IllegalArgumentException("Enumeration not an BooleanIterator");
        }
        if (((BooleanBuffer)((BooleanIterator)enumeration).original).storage != this.storage) {
            throw new IllegalArgumentException("Enumeration not for this BooleanBuffer ");
        }
        Object object = ((BooleanIterator)enumeration).get();
        BooleanIterator booleanIterator2 = new BooleanIterator(this, ((BooleanIterator)enumeration).index() + 1);
        if (!booleanIterator2.equals(booleanIterator = new BooleanIterator(this, this.size))) {
            Algorithms.copy(booleanIterator2, booleanIterator, (BooleanIterator)enumeration);
        }
        --this.size;
        return object;
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        if (!(enumeration instanceof BooleanIterator) || !(enumeration2 instanceof BooleanIterator)) {
            throw new IllegalArgumentException("Enumeration not an BooleanIterator");
        }
        if (((BooleanBuffer)((BooleanIterator)enumeration).original).storage != this.storage || ((BooleanIterator)enumeration).isCompatibleWith((BooleanIterator)enumeration2)) {
            throw new IllegalArgumentException("Enumeration not compatible");
        }
        int n = ((BooleanIterator)enumeration).distance((BooleanIterator)enumeration2);
        BooleanIterator cfr_ignored_0 = (BooleanIterator)Algorithms.copy((BooleanIterator)enumeration2, new BooleanIterator(this, this.size), (BooleanIterator)enumeration);
        this.size -= n;
        return n;
    }

    public int replace(int n, int n2, Object object, Object object2) {
        if (n2 < n) {
            return -1;
        }
        ArrayAdapter.checkRange(n, n2, this.size);
        return Algorithms.replace(new BooleanIterator(this, n), new BooleanIterator(this, n2 + 1), object, object2);
    }

    public synchronized int replace(int n, int n2, boolean bl, boolean bl2) {
        return this.replace(n, n2, new Boolean(bl), new Boolean(bl2));
    }

    public int replace(Object object, Object object2) {
        return this.replace(BooleanBuffer.asBoolean(object), BooleanBuffer.asBoolean(object2));
    }

    public int replace(boolean bl, boolean bl2) {
        return this.replace(0, this.size() - 1, bl, bl2);
    }

    public synchronized void setSize(int n) {
        if (this.size() > n) {
            this.remove(n, this.size() - 1);
        } else if (this.size() < n) {
            this.insert(this.size(), n - this.size(), false);
        }
    }

    public int size() {
        return this.size;
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public synchronized void swap(BooleanBuffer booleanBuffer) {
        BooleanBuffer booleanBuffer2 = booleanBuffer;
        synchronized (booleanBuffer2) {
            int n = this.size;
            ByteBuffer byteBuffer = this.storage;
            this.size = booleanBuffer.size;
            this.storage = booleanBuffer.storage;
            booleanBuffer.size = n;
            booleanBuffer.storage = byteBuffer;
        }
    }

    public synchronized String toString() {
        return Algorithms.toString(this, "BooleanBuffer");
    }

    public synchronized void trimToSize() {
        if (this.size() < this.capacity()) {
            this.copy(new BooleanBuffer(this.get()));
        }
    }
}

