/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.adapters.Algorithms;
import java.util.Enumeration;

public abstract class ArrayAdapter
implements Sequence {
    static final int DEFAULT_SIZE = 10;
    static final int THRESHOLD = 2000;
    static final int MULTIPLIER = 2;
    static final long serialVersionUID = 6128010853760609317L;

    public Object add(Object object) {
        throw new InvalidOperationException("cannot execute add() on a native array");
    }

    public Object back() {
        return this.at(this.size() - 1);
    }

    protected static final void checkIndex(int n, int n2) {
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n + "; valid range is 0.." + (n2 - 1));
        }
    }

    protected static final void checkRange(int n, int n2, int n3) {
        ArrayAdapter.checkIndex(n, n3);
        ArrayAdapter.checkIndex(n2, n3);
    }

    public void clear() {
        throw new InvalidOperationException("cannot execute clear() on a native array");
    }

    public Object clone() {
        return null;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public synchronized int count(int n, int n2, Object object) {
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            if (this.at(n4).equals(object)) {
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    public int count(Object object) {
        return this.count(0, this.size() - 1, object);
    }

    public boolean equals(Object object) {
        return false;
    }

    public Object front() {
        return this.at(0);
    }

    static final int getNextSize(int n) {
        int n2 = n > 2000 ? n + 2000 : n * 2;
        return Math.max(1, n2);
    }

    public synchronized int hashCode() {
        return Algorithms.orderedHash(this.start(), this.size());
    }

    public synchronized int indexOf(int n, int n2, Object object) {
        int n3 = n;
        while (n3 <= n2) {
            if (this.at(n3).equals(object)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int indexOf(Object object) {
        return this.indexOf(0, this.size() - 1, object);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public Object popBack() {
        throw new InvalidOperationException("cannot execute popBack() on a native array");
    }

    public Object popFront() {
        throw new InvalidOperationException("cannot execute popFront() on a native array");
    }

    public void pushBack(Object object) {
        throw new InvalidOperationException("cannot execute pushBack() on a native array");
    }

    public void pushFront(Object object) {
        throw new InvalidOperationException("cannot execute pushFront() on a native array");
    }

    public int remove(int n, int n2, Object object) {
        throw new InvalidOperationException("cannot execute remove() on a native array");
    }

    public int remove(Object object) {
        throw new InvalidOperationException("cannot execute remove() on a native array");
    }

    public int remove(Object object, int n) {
        throw new InvalidOperationException("cannot execute remove() on a native array");
    }

    public Object remove(Enumeration enumeration) {
        throw new InvalidOperationException("cannot execute remove() on a native array");
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        throw new InvalidOperationException("cannot execute remove() on a native array");
    }

    public synchronized int replace(int n, int n2, Object object, Object object2) {
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            if (this.at(n4).equals(object)) {
                this.put(n4, object2);
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    public int replace(Object object, Object object2) {
        return this.replace(0, this.size() - 1, object, object2);
    }

    public abstract int size();

    public abstract Enumeration elements();

    public abstract void put(int var1, Object var2);

    public abstract ForwardIterator start();

    public abstract ForwardIterator finish();

    public abstract Object at(int var1);
}

