/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Algos;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.SListIterator;
import com.objectspace.jgl.SListNode;
import com.objectspace.jgl.Sequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;

public class SList
implements Sequence {
    transient SListNode myHead;
    transient SListNode myTail;
    transient int myLength;
    static final long serialVersionUID = -5092823079416449151L;

    public SList() {
    }

    public SList(int n) {
        while (--n >= 0) {
            this.add(null);
        }
    }

    public SList(int n, Object object) {
        while (--n >= 0) {
            this.add(object);
        }
    }

    public SList(SList sList) {
        this.copy(sList);
    }

    public synchronized Object add(Object object) {
        SListNode sListNode = new SListNode();
        sListNode.object = object;
        if (++this.myLength == 1) {
            this.myHead = sListNode;
        } else {
            this.myTail.next = sListNode;
        }
        this.myTail = sListNode;
        return null;
    }

    public synchronized Object at(int n) {
        if (n < 0 || n >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n + " when valid range is 0.." + (this.myLength - 1));
        }
        SListNode sListNode = this.myHead;
        while (n-- > 0) {
            sListNode = sListNode.next;
        }
        return sListNode.object;
    }

    public synchronized Object back() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("SList is empty");
        }
        return this.myTail.object;
    }

    public synchronized SListIterator begin() {
        return new SListIterator(this, this.myHead);
    }

    private void checkRange(int n, int n2) {
        if (n < 0 || n >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n + " when valid range is 0.." + (this.myLength - 1));
        }
        if (n2 < 0 || n2 >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n2 + " when valid range is 0.." + (this.myLength - 1));
        }
    }

    public synchronized void clear() {
        this.myHead = null;
        this.myTail = null;
        this.myLength = 0;
    }

    public synchronized Object clone() {
        return new SList(this);
    }

    public synchronized boolean contains(Object object) {
        return !this.find(object).equals(this.end());
    }

    public synchronized void copy(SList sList) {
        if (this == sList) {
            return;
        }
        SList sList2 = sList;
        synchronized (sList2) {
            this.myHead = null;
            this.myTail = null;
            SListNode sListNode = sList.myHead;
            while (sListNode != null) {
                SListNode sListNode2 = new SListNode();
                sListNode2.object = sListNode.object;
                if (this.myTail == null) {
                    this.myHead = sListNode2;
                } else {
                    this.myTail.next = sListNode2;
                }
                this.myTail = sListNode2;
                sListNode = sListNode.next;
            }
            this.myLength = sList.myLength;
        }
    }

    public synchronized int count(int n, int n2, Object object) {
        if (n2 < n) {
            return 0;
        }
        this.checkRange(n, n2);
        return Algos.count(this.iteratorAt(n), this.iteratorAt(n2 + 1), object);
    }

    public synchronized int count(SListIterator sListIterator, SListIterator sListIterator2, Object object) {
        return Algos.count(sListIterator, sListIterator2, object);
    }

    public int count(Object object) {
        return this.count(this.begin(), this.end(), object);
    }

    public synchronized Enumeration elements() {
        return new SListIterator(this, this.myHead);
    }

    public synchronized SListIterator end() {
        return new SListIterator(this, null);
    }

    public synchronized boolean equals(SList sList) {
        SList sList2 = sList;
        synchronized (sList2) {
            return Algos.equal(this, sList);
        }
    }

    public boolean equals(Object object) {
        return object instanceof SList && this.equals((SList)object);
    }

    public synchronized SListIterator find(SListIterator sListIterator, SListIterator sListIterator2, Object object) {
        return (SListIterator)Algos.find(sListIterator, sListIterator2, object);
    }

    public synchronized SListIterator find(Object object) {
        return (SListIterator)Algos.find(new SListIterator(this, this.myHead), new SListIterator(this, null), object);
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized Object front() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("SList is empty");
        }
        return this.myHead.object;
    }

    public synchronized int hashCode() {
        return Algos.orderedHash(this.begin(), this.myLength);
    }

    public synchronized int indexOf(int n, int n2, Object object) {
        if (n2 < n) {
            return 0;
        }
        this.checkRange(n, n2);
        SListIterator sListIterator = this.iteratorAt(n2 + 1);
        SListIterator sListIterator2 = (SListIterator)Algos.find(this.iteratorAt(n), sListIterator, object);
        return sListIterator2.myNode == sListIterator.myNode ? -1 : sListIterator2.index();
    }

    public synchronized int indexOf(Object object) {
        SListIterator sListIterator = (SListIterator)Algos.find(new SListIterator(this, this.myHead), new SListIterator(this, null), object);
        return sListIterator.myNode == null ? -1 : sListIterator.index();
    }

    public synchronized void insert(int n, int n2, Object object) {
        if (n > this.myLength || this.myLength == 0 && n > 0) {
            throw new IndexOutOfBoundsException("Attempt to insert at index " + n + " when valid range is 0.." + this.myLength);
        }
        if (this.myLength == 0) {
            this.pushFront(object);
            --n2;
        }
        this.insert(this.nodeAt(n), n2, object);
    }

    public synchronized void insert(int n, Object object) {
        if (n > this.myLength || this.myLength == 0 && n > 0) {
            throw new IndexOutOfBoundsException("Attempt to insert at index " + n + " when valid range is 0.." + this.myLength);
        }
        if (this.myLength == 0) {
            this.pushFront(object);
        } else {
            this.insert(this.nodeAt(n), object);
        }
    }

    public synchronized void insert(SListIterator sListIterator, int n, Object object) {
        this.insert(sListIterator.myNode, n, object);
    }

    public synchronized void insert(SListIterator sListIterator, InputIterator inputIterator, InputIterator inputIterator2) {
        InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
        while (!inputIterator3.equals(inputIterator2)) {
            this.insert(sListIterator, inputIterator3.nextElement());
        }
    }

    public synchronized SListIterator insert(SListIterator sListIterator, Object object) {
        return new SListIterator(this, this.insert(sListIterator.myNode, object));
    }

    private void insert(SListNode sListNode, int n, Object object) {
        SListNode sListNode2 = null;
        SListNode sListNode3 = null;
        this.myLength += n;
        SListNode sListNode4 = this.myHead;
        while (sListNode4 != sListNode) {
            sListNode2 = sListNode4;
            sListNode4 = sListNode4.next;
        }
        while (--n >= 0) {
            sListNode3 = new SListNode();
            sListNode3.object = object;
            if (sListNode2 == null) {
                this.myHead = sListNode3;
            } else {
                sListNode2.next = sListNode3;
            }
            sListNode2 = sListNode3;
        }
        sListNode3.next = sListNode;
    }

    private SListNode insert(SListNode sListNode, Object object) {
        SListNode sListNode2 = null;
        SListNode sListNode3 = this.myHead;
        while (sListNode3 != sListNode) {
            sListNode2 = sListNode3;
            sListNode3 = sListNode3.next;
        }
        sListNode3 = new SListNode();
        sListNode3.object = object;
        if (sListNode2 == null) {
            this.myHead = sListNode3;
        } else {
            sListNode2.next = sListNode3;
        }
        sListNode3.next = sListNode;
        ++this.myLength;
        return sListNode3;
    }

    public boolean isEmpty() {
        return this.myLength == 0;
    }

    SListIterator iteratorAt(int n) {
        SListNode sListNode = this.myHead;
        while (n-- > 0) {
            sListNode = sListNode.next;
        }
        return new SListIterator(this, sListNode);
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    SListNode nodeAt(int n) {
        SListNode sListNode = this.myHead;
        while (n-- > 0) {
            sListNode = sListNode.next;
        }
        return sListNode;
    }

    public synchronized Object popBack() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("SList is empty");
        }
        SListNode sListNode = null;
        Object object = this.myHead;
        while (object != this.myTail) {
            sListNode = object;
            object = ((SListNode)object).next;
        }
        if (sListNode == null) {
            object = this.myHead.object;
            this.myHead = null;
        } else {
            object = sListNode.next.object;
            sListNode.next = null;
        }
        this.myTail = sListNode;
        --this.myLength;
        return object;
    }

    public synchronized Object popFront() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("Slist is empty");
        }
        Object object = this.myHead.object;
        this.myHead = this.myHead.next;
        if (--this.myLength == 0) {
            this.myTail = null;
        }
        return object;
    }

    public void pushBack(Object object) {
        this.add(object);
    }

    public synchronized void pushFront(Object object) {
        SListNode sListNode = new SListNode();
        sListNode.object = object;
        sListNode.next = this.myHead;
        this.myHead = sListNode;
        if (++this.myLength == 1) {
            this.myTail = sListNode;
        }
    }

    public synchronized void put(int n, Object object) {
        if (n < 0 || n >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n + " when valid range is 0.." + (this.myLength - 1));
        }
        SListNode sListNode = this.myHead;
        while (n-- > 0) {
            sListNode = sListNode.next;
        }
        sListNode.object = object;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.clear();
        int n = objectInputStream.readInt();
        while (n-- > 0) {
            this.add(objectInputStream.readObject());
        }
    }

    public synchronized Object remove(int n) {
        if (n < 0 || n >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n + " when valid range is 0.." + (this.myLength - 1));
        }
        return this.remove(this.nodeAt(n));
    }

    public synchronized int remove(int n, int n2) {
        if (n2 < n) {
            return 0;
        }
        this.checkRange(n, n2);
        return this.remove(this.nodeAt(n), this.nodeAt(n2 + 1));
    }

    public synchronized int remove(int n, int n2, Object object) {
        if (n2 < n) {
            return 0;
        }
        this.checkRange(n, n2);
        return this.remove(this.nodeAt(n), this.nodeAt(n2 + 1), object, this.myLength);
    }

    private Object remove(SListNode sListNode) {
        SListNode sListNode2 = null;
        SListNode sListNode3 = this.myHead;
        while (sListNode3 != sListNode) {
            sListNode2 = sListNode3;
            sListNode3 = sListNode3.next;
        }
        if (sListNode2 == null) {
            this.myHead = sListNode.next;
        } else {
            sListNode2.next = sListNode.next;
        }
        if (sListNode == this.myTail) {
            this.myTail = sListNode2;
        }
        --this.myLength;
        return sListNode.object;
    }

    private int remove(SListNode sListNode, SListNode sListNode2) {
        SListNode sListNode3 = null;
        SListNode sListNode4 = this.myHead;
        while (sListNode4 != sListNode) {
            sListNode3 = sListNode4;
            sListNode4 = sListNode4.next;
        }
        if (sListNode3 == null) {
            this.myHead = sListNode2;
        } else {
            sListNode3.next = sListNode2;
        }
        if (sListNode2 == null) {
            this.myTail = sListNode3;
        }
        int n = 0;
        while (sListNode != sListNode2) {
            sListNode = sListNode.next;
            ++n;
        }
        this.myLength -= n;
        return n;
    }

    private int remove(SListNode sListNode, SListNode sListNode2, Object object, int n) {
        if (n <= 0) {
            return 0;
        }
        int n2 = 0;
        SListNode sListNode3 = null;
        SListNode sListNode4 = this.myHead;
        while (sListNode4 != sListNode) {
            sListNode3 = sListNode4;
            sListNode4 = sListNode4.next;
        }
        while (n > 0 && sListNode4 != sListNode2) {
            if (sListNode4.object.equals(object)) {
                if (sListNode3 == null) {
                    this.myHead = sListNode4.next;
                } else {
                    sListNode3.next = sListNode4.next;
                }
                if (sListNode4 == this.myTail) {
                    this.myTail = sListNode3;
                }
                ++n2;
                --n;
            } else {
                sListNode3 = sListNode4;
            }
            sListNode4 = sListNode4.next;
        }
        this.myLength -= n2;
        return n2;
    }

    public synchronized int remove(Object object) {
        return this.remove(this.myHead, null, object, this.myLength);
    }

    public synchronized int remove(Object object, int n) {
        return this.remove(this.myHead, null, object, n);
    }

    public synchronized Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof SListIterator)) {
            throw new IllegalArgumentException("Enumeration not a SListIterator");
        }
        if (((SListIterator)enumeration).mySList != this) {
            throw new IllegalArgumentException("Enumeration not for this SList");
        }
        Object object = ((SListIterator)enumeration).get();
        this.remove(((SListIterator)enumeration).myNode);
        return object;
    }

    public synchronized int remove(Enumeration enumeration, Enumeration enumeration2) {
        if (!(enumeration instanceof SListIterator) || !(enumeration2 instanceof SListIterator)) {
            throw new IllegalArgumentException("Enumeration not a SListIterator");
        }
        if (((SListIterator)enumeration).mySList != this || ((SListIterator)enumeration2).mySList != this) {
            throw new IllegalArgumentException("Enumeration not for this SList");
        }
        SListIterator sListIterator = (SListIterator)enumeration;
        SListIterator sListIterator2 = (SListIterator)enumeration2;
        return this.remove(sListIterator.myNode, sListIterator2.myNode);
    }

    public synchronized int remove(Enumeration enumeration, Enumeration enumeration2, Object object) {
        if (!(enumeration instanceof SListIterator) || !(enumeration2 instanceof SListIterator)) {
            throw new IllegalArgumentException("Enumeration not a SListIterator");
        }
        if (((SListIterator)enumeration).mySList != this || ((SListIterator)enumeration2).mySList != this) {
            throw new IllegalArgumentException("Enumeration not for this SList");
        }
        SListIterator sListIterator = (SListIterator)enumeration;
        SListIterator sListIterator2 = (SListIterator)enumeration2;
        return this.remove(sListIterator.myNode, sListIterator2.myNode, object, this.myLength);
    }

    public synchronized int replace(int n, int n2, Object object, Object object2) {
        if (n2 < n) {
            return 0;
        }
        this.checkRange(n, n2);
        return Algos.replace(this.iteratorAt(n), this.iteratorAt(n2 + 1), object, object2);
    }

    public synchronized int replace(SListIterator sListIterator, SListIterator sListIterator2, Object object, Object object2) {
        if (!sListIterator.isCompatibleWith(sListIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return Algos.replace(sListIterator, sListIterator2, object, object2);
    }

    public synchronized int replace(Object object, Object object2) {
        return Algos.replace(this.begin(), this.end(), object, object2);
    }

    public int size() {
        return this.myLength;
    }

    public synchronized void splice(int n, SList sList) {
        if (n > this.myLength || this.myLength == 0 && n > 0) {
            throw new IndexOutOfBoundsException("Attempt to insert at index " + n + " when valid range is 0.." + this.myLength);
        }
        if (this.myLength == 0) {
            this.swap(sList);
        } else {
            this.splice(this.nodeAt(n), sList);
        }
    }

    public synchronized void splice(int n, SList sList, int n2) {
        if (n > this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to insert at index " + n + " when valid range is 0.." + this.myLength);
        }
        if (n2 < 0 || n2 >= sList.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n2 + " when valid range is 0.." + (sList.myLength - 1));
        }
        this.splice(this.nodeAt(n), sList, sList.nodeAt(n2));
    }

    public synchronized void splice(int n, SList sList, int n2, int n3) {
        if (n > this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to insert at index " + n + " when valid range is 0.." + this.myLength);
        }
        if (n2 < 0 || n2 >= sList.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n2 + " when valid range is 0.." + (sList.myLength - 1));
        }
        if (n3 < 0 || n3 >= sList.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n3 + " when valid range is 0.." + (sList.myLength - 1));
        }
        this.splice(this.nodeAt(n), sList, sList.nodeAt(n2), sList.nodeAt(n3 + 1));
    }

    public synchronized void splice(SListIterator sListIterator, SList sList) {
        this.splice(sListIterator.myNode, sList);
    }

    public synchronized void splice(SListIterator sListIterator, SList sList, SListIterator sListIterator2) {
        this.splice(sListIterator.myNode, sList, sListIterator2.myNode);
    }

    public synchronized void splice(SListIterator sListIterator, SList sList, SListIterator sListIterator2, SListIterator sListIterator3) {
        this.splice(sListIterator.myNode, sList, sListIterator2.myNode, sListIterator3.myNode);
    }

    private void splice(SListNode sListNode, SList sList) {
        SList sList2 = sList;
        synchronized (sList2) {
            if (this == sList || sList.myLength == 0) {
                return;
            }
            SListNode sListNode2 = null;
            SListNode sListNode3 = this.myHead;
            while (sListNode3 != sListNode) {
                sListNode2 = sListNode3;
                sListNode3 = sListNode3.next;
            }
            if (sListNode2 == null) {
                this.myHead = sList.myHead;
            } else {
                sListNode2.next = sList.myHead;
            }
            if (sListNode == null) {
                this.myTail = sList.myTail;
            } else {
                sList.myTail.next = sListNode;
            }
            this.myLength += sList.myLength;
            sList.clear();
        }
    }

    private void splice(SListNode sListNode, SList sList, SListNode sListNode2) {
        SList sList2 = sList;
        synchronized (sList2) {
            if (sListNode == sListNode2 || sListNode == sListNode2.next) {
                return;
            }
            sList.remove(sListNode2);
            SListNode sListNode3 = null;
            SListNode sListNode4 = this.myHead;
            while (sListNode4 != sListNode) {
                sListNode3 = sListNode4;
                sListNode4 = sListNode4.next;
            }
            if (sListNode3 == null) {
                this.myHead = sListNode2;
            } else {
                sListNode3.next = sListNode2;
            }
            if (sListNode == null) {
                this.myTail = sListNode2;
            }
            sListNode2.next = sListNode;
            ++this.myLength;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void splice(SListNode sListNode, SList sList, SListNode sListNode2, SListNode sListNode3) {
        if (sListNode2 == sListNode3) {
            return;
        }
        SList sList2 = sList;
        synchronized (sList2) {
            SListNode sListNode4;
            block13: {
                SListNode sListNode5;
                if (sList == this) {
                    sListNode5 = sListNode2;
                    if (sListNode == sListNode2) return;
                    if (sListNode == sListNode3) {
                        return;
                    }
                    while (sListNode5 != sListNode3) {
                        if (sListNode == sListNode5) {
                            throw new InvalidOperationException("Tried to splice into an overlapping area.");
                        }
                        sListNode5 = sListNode5.next;
                    }
                }
                sList.remove(sListNode2, sListNode3);
                sListNode5 = null;
                sListNode4 = this.myHead;
                while (true) {
                    if (sListNode4 == sListNode) {
                        if (sListNode5 != null) break;
                        this.myHead = sListNode2;
                        break block13;
                    }
                    sListNode5 = sListNode4;
                    sListNode4 = sListNode4.next;
                }
                sListNode5.next = sListNode2;
            }
            sListNode4 = sListNode2;
            int n = 1;
            while (true) {
                if (sListNode4.next == sListNode3) {
                    if (sListNode == null) {
                        this.myTail = sListNode4;
                    }
                    sListNode4.next = sListNode;
                    this.myLength += n;
                    return;
                }
                sListNode4 = sListNode4.next;
                ++n;
            }
        }
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public synchronized void swap(SList sList) {
        SList sList2 = sList;
        synchronized (sList2) {
            SListNode sListNode = this.myHead;
            this.myHead = sList.myHead;
            sList.myHead = sListNode;
            SListNode sListNode2 = this.myTail;
            this.myTail = sList.myTail;
            sList.myTail = sListNode2;
            int n = this.myLength;
            this.myLength = sList.myLength;
            sList.myLength = n;
        }
    }

    public synchronized String toString() {
        return Algos.toString(this, "SList");
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        SListIterator sListIterator = this.begin();
        while (sListIterator.hasMoreElements()) {
            objectOutputStream.writeObject(sListIterator.nextElement());
        }
    }
}

