/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Array;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.xHashComparator;
import java.util.Enumeration;

public class PriorityQueue
implements Container {
    protected Array myArray;
    protected BinaryPredicate myComparator;
    static final long serialVersionUID = 6264990747843793967L;

    public PriorityQueue() {
        this(new xHashComparator());
    }

    public PriorityQueue(BinaryPredicate binaryPredicate) {
        this.myArray = new Array();
        this.myComparator = binaryPredicate;
    }

    public PriorityQueue(PriorityQueue priorityQueue) {
        PriorityQueue priorityQueue2 = priorityQueue;
        synchronized (priorityQueue2) {
            this.myArray = (Array)priorityQueue.myArray.clone();
            this.myComparator = priorityQueue.myComparator;
        }
    }

    public Object add(Object object) {
        this.push(object);
        return null;
    }

    public synchronized void clear() {
        this.myArray.clear();
    }

    public synchronized Object clone() {
        return new PriorityQueue(this);
    }

    public synchronized void copy(PriorityQueue priorityQueue) {
        PriorityQueue priorityQueue2 = priorityQueue;
        synchronized (priorityQueue2) {
            if (this != priorityQueue) {
                this.myArray = (Array)priorityQueue.myArray.clone();
                this.myComparator = priorityQueue.myComparator;
            }
        }
    }

    public synchronized Enumeration elements() {
        return this.myArray.elements();
    }

    public synchronized boolean equals(PriorityQueue priorityQueue) {
        PriorityQueue priorityQueue2 = priorityQueue;
        synchronized (priorityQueue2) {
            return this.myArray.equals(priorityQueue.myArray);
        }
    }

    public boolean equals(Object object) {
        return object instanceof PriorityQueue && this.equals((PriorityQueue)object);
    }

    public synchronized ForwardIterator finish() {
        return this.myArray.finish();
    }

    public synchronized BinaryPredicate getComparator() {
        return this.myComparator;
    }

    public synchronized int hashCode() {
        return this.myArray.hashCode();
    }

    public boolean isEmpty() {
        return this.myArray.isEmpty();
    }

    public int maxSize() {
        return this.myArray.maxSize();
    }

    public synchronized Object pop() {
        if (this.myArray.isEmpty()) {
            throw new InvalidOperationException("PriorityQueue is empty");
        }
        PriorityQueue.popHeap(this.myArray.start(), this.myArray.finish(), this.myComparator);
        return this.myArray.popBack();
    }

    private static void popHeap(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, BinaryPredicate binaryPredicate) {
        Object object = forwardIterator2.get(-1);
        forwardIterator2.put(-1, forwardIterator.get());
        int n = 0;
        int n2 = forwardIterator.distance(forwardIterator2) - 1;
        int n3 = n;
        int n4 = 2 * (n + 1);
        while (n4 < n2) {
            if (binaryPredicate.execute(forwardIterator.get(n4), forwardIterator.get(n4 - 1))) {
                --n4;
            }
            forwardIterator.put(n, forwardIterator.get(n4));
            n = n4;
            n4 = 2 * (n4 + 1);
        }
        if (n4 == n2) {
            forwardIterator.put(n, forwardIterator.get(n4 - 1));
            n = n4 - 1;
        }
        PriorityQueue.pushHeap(forwardIterator, n, n3, object, binaryPredicate);
    }

    public synchronized void push(Object object) {
        this.myArray.pushBack(object);
        PriorityQueue.pushHeap(this.myArray.start(), this.myArray.finish(), this.myComparator);
    }

    private static void pushHeap(ForwardIterator forwardIterator, int n, int n2, Object object, BinaryPredicate binaryPredicate) {
        int n3 = (n - 1) / 2;
        while (n > n2 && binaryPredicate.execute(forwardIterator.get(n3), object)) {
            forwardIterator.put(n, forwardIterator.get(n3));
            n = n3;
            n3 = (n - 1) / 2;
        }
        forwardIterator.put(n, object);
    }

    private static void pushHeap(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, BinaryPredicate binaryPredicate) {
        PriorityQueue.pushHeap(forwardIterator, forwardIterator.distance(forwardIterator2) - 1, 0, forwardIterator2.get(-1), binaryPredicate);
    }

    public Object remove(Enumeration enumeration) {
        throw new InvalidOperationException("cannot execute remove() on a priority queue");
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        throw new InvalidOperationException("cannot execute remove() on a priority queue");
    }

    public int size() {
        return this.myArray.size();
    }

    public synchronized ForwardIterator start() {
        return this.myArray.start();
    }

    public synchronized void swap(PriorityQueue priorityQueue) {
        PriorityQueue priorityQueue2 = priorityQueue;
        synchronized (priorityQueue2) {
            Array array = this.myArray;
            this.myArray = priorityQueue.myArray;
            priorityQueue.myArray = array;
            BinaryPredicate binaryPredicate = this.myComparator;
            this.myComparator = priorityQueue.myComparator;
            priorityQueue.myComparator = binaryPredicate;
        }
    }

    public synchronized Object top() {
        return this.myArray.front();
    }

    public synchronized String toString() {
        return "PriorityQueue( " + this.myArray.toString() + " )";
    }
}

