/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.Deque;
import com.objectspace.jgl.DequeInfo;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.Opaque;
import com.objectspace.jgl.RandomAccessIterator;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class DequeIterator
implements RandomAccessIterator,
Serializable,
Opaque {
    Deque myDeque;
    int myBlockIndex;
    int myMapIndex;
    static final long serialVersionUID = 8197515993982694406L;

    public DequeIterator() {
    }

    DequeIterator(Deque deque, int n, int n2) {
        this.myDeque = deque;
        this.myBlockIndex = n;
        this.myMapIndex = n2;
    }

    public DequeIterator(DequeIterator dequeIterator) {
        this.myDeque = dequeIterator.myDeque;
        this.myMapIndex = dequeIterator.myMapIndex;
        this.myBlockIndex = dequeIterator.myBlockIndex;
    }

    public void advance() {
        if (++this.myBlockIndex == 128) {
            ++this.myMapIndex;
            this.myBlockIndex = 0;
        }
    }

    public void advance(int n) {
        this.myBlockIndex += n;
        if (this.myBlockIndex >= 128) {
            int n2 = this.myBlockIndex / 128;
            this.myMapIndex += n2;
            this.myBlockIndex %= 128;
        } else if (this.myBlockIndex < 0) {
            int n3 = (127 - this.myBlockIndex) / 128;
            this.myMapIndex -= n3;
            this.myBlockIndex += n3 * 128;
        }
    }

    public boolean atBegin() {
        return this.equals(this.myDeque.myStart);
    }

    public boolean atEnd() {
        return this.equals(this.myDeque.myFinish);
    }

    public Object clone() {
        return new DequeIterator(this);
    }

    DequeIterator copy(int n) {
        DequeIterator dequeIterator = new DequeIterator(this);
        dequeIterator.advance(n);
        return dequeIterator;
    }

    public int distance(ForwardIterator forwardIterator) {
        DequeInfo dequeInfo = (DequeInfo)((Opaque)((Object)forwardIterator)).opaqueData();
        int n = dequeInfo.block - this.myBlockIndex;
        return this.myMapIndex == dequeInfo.map ? n : 128 * (dequeInfo.map - this.myMapIndex) + n;
    }

    public boolean equals(Object object) {
        if (object instanceof Opaque) {
            DequeInfo dequeInfo = (DequeInfo)((Opaque)object).opaqueData();
            return this.myMapIndex == dequeInfo.map && this.myBlockIndex == dequeInfo.block && this.isCompatibleWith((InputIterator)object);
        }
        return false;
    }

    public Object get() {
        return this.myDeque.myMap[this.myMapIndex][this.myBlockIndex];
    }

    public Object get(int n) {
        int n2 = this.myMapIndex;
        int n3 = this.myBlockIndex;
        this.advance(n);
        Object object = this.get();
        this.myMapIndex = n2;
        this.myBlockIndex = n3;
        return object;
    }

    public Container getContainer() {
        return this.myDeque;
    }

    public boolean hasMoreElements() {
        return !this.equals(this.myDeque.myFinish);
    }

    public int index() {
        return this.myDeque.myStart.distance(this);
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof Opaque && this.opaqueId() == ((Opaque)((Object)inputIterator)).opaqueId();
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        DequeInfo dequeInfo = (DequeInfo)((Opaque)((Object)randomAccessIterator)).opaqueData();
        return this.myMapIndex < dequeInfo.map || this.myMapIndex == dequeInfo.map && this.myBlockIndex < dequeInfo.block;
    }

    public Object nextElement() {
        try {
            Object object = this.get();
            this.advance();
            return object;
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchElementException("DequeIterator");
        }
    }

    public Object opaqueData() {
        return new DequeInfo(this.myBlockIndex, this.myMapIndex);
    }

    public int opaqueId() {
        return System.identityHashCode(this.myDeque);
    }

    public void put(int n, Object object) {
        int n2 = this.myMapIndex;
        int n3 = this.myBlockIndex;
        this.advance(n);
        this.put(object);
        this.myMapIndex = n2;
        this.myBlockIndex = n3;
    }

    public void put(Object object) {
        this.myDeque.myMap[this.myMapIndex][this.myBlockIndex] = object;
    }

    public void retreat() {
        if (--this.myBlockIndex == -1) {
            --this.myMapIndex;
            this.myBlockIndex = 127;
        }
    }

    public void retreat(int n) {
        this.advance(-n);
    }
}

