/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Algos;
import com.objectspace.jgl.BidirectionalIterator;
import com.objectspace.jgl.DequeIterator;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import java.util.Enumeration;

public class Deque
implements Sequence {
    DequeIterator myStart = new DequeIterator(this, 0, 0);
    DequeIterator myFinish = new DequeIterator(this, 0, 0);
    int myLength;
    Object[][] myMap;
    static final int pageSize = 1024;
    static final int BLOCK_SIZE = 128;
    static final long serialVersionUID = 8175162724553274000L;

    public Deque() {
    }

    public Deque(int n) {
        this.insert(this.myStart, n, null);
    }

    public Deque(int n, Object object) {
        this.insert(this.myStart, n, object);
    }

    public Deque(Deque deque) {
        Deque deque2 = deque;
        synchronized (deque2) {
            DequeIterator dequeIterator = deque.begin();
            while (dequeIterator.hasMoreElements()) {
                this.add(dequeIterator.nextElement());
            }
        }
    }

    public synchronized Object add(Object object) {
        if (this.myLength++ == 0) {
            this.createMap();
            this.myMap[this.myFinish.myMapIndex][this.myFinish.myBlockIndex++] = object;
        } else {
            this.myMap[this.myFinish.myMapIndex][this.myFinish.myBlockIndex++] = object;
            if (this.myFinish.myBlockIndex == 128) {
                if (this.myFinish.myMapIndex == this.myMap.length - 1) {
                    this.growMap();
                }
                this.myMap[++this.myFinish.myMapIndex] = new Object[128];
                this.myFinish.myBlockIndex = 0;
            }
        }
        return null;
    }

    public synchronized Object at(int n) {
        if (n < 0 || n >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n + " when valid range is 0.." + (this.myLength - 1));
        }
        int n2 = this.myStart.myBlockIndex + n;
        int n3 = this.myStart.myMapIndex;
        if (n2 >= 128) {
            int n4 = n2 / 128;
            n3 += n4;
            n2 %= 128;
        } else if (n2 < 0) {
            int n5 = (127 - n2) / 128;
            n3 -= n5;
            n2 += n5 * 128;
        }
        return this.myMap[n3][n2];
    }

    public synchronized Object back() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("Deque is empty");
        }
        if (this.myFinish.myBlockIndex > 0) {
            return this.myMap[this.myFinish.myMapIndex][this.myFinish.myBlockIndex - 1];
        }
        return this.myMap[this.myFinish.myMapIndex - 1][127];
    }

    public synchronized DequeIterator begin() {
        return new DequeIterator(this.myStart);
    }

    private void checkRange(int n, int n2) {
        if (n < 0 || n >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n + " when valid range is 0.." + (this.myLength - 1));
        }
        if (n2 < 0 || n2 >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n2 + " when valid range is 0.." + (this.myLength - 1));
        }
    }

    public synchronized void clear() {
        this.myMap = null;
        this.myStart.myMapIndex = 0;
        this.myStart.myBlockIndex = 0;
        this.myFinish.myMapIndex = 0;
        this.myFinish.myBlockIndex = 0;
        this.myLength = 0;
    }

    public synchronized Object clone() {
        return new Deque(this);
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    private static DequeIterator copy(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2, DequeIterator dequeIterator) {
        BidirectionalIterator bidirectionalIterator3 = (BidirectionalIterator)bidirectionalIterator.clone();
        DequeIterator dequeIterator2 = (DequeIterator)dequeIterator.clone();
        while (!bidirectionalIterator3.equals(bidirectionalIterator2)) {
            dequeIterator2.put(bidirectionalIterator3.nextElement());
            dequeIterator2.advance();
        }
        return dequeIterator2;
    }

    public synchronized void copy(Deque deque) {
        if (this == deque) {
            return;
        }
        Deque deque2 = deque;
        synchronized (deque2) {
            if (this.myLength >= deque.myLength) {
                DequeIterator dequeIterator = Deque.copy(deque.myStart, deque.myFinish, this.myStart);
                this.remove(dequeIterator, this.myFinish);
            } else {
                DequeIterator dequeIterator = deque.myStart.copy(this.myLength);
                Deque.copy(deque.myStart, dequeIterator, this.myStart);
                DequeIterator dequeIterator2 = dequeIterator;
                while (dequeIterator2.hasMoreElements()) {
                    this.add(dequeIterator2.get());
                    dequeIterator2.advance();
                }
            }
        }
    }

    private static void copyBackward(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2, DequeIterator dequeIterator) {
        BidirectionalIterator bidirectionalIterator3 = (BidirectionalIterator)bidirectionalIterator2.clone();
        DequeIterator dequeIterator2 = (DequeIterator)dequeIterator.clone();
        while (!bidirectionalIterator.equals(bidirectionalIterator3)) {
            dequeIterator2.retreat();
            bidirectionalIterator3.retreat();
            dequeIterator2.put(bidirectionalIterator3.get());
        }
    }

    public synchronized int count(int n, int n2, Object object) {
        if (n2 < n) {
            return 0;
        }
        this.checkRange(n, n2);
        return Algos.count(this.myStart.copy(n), this.myStart.copy(n2 + 1), object);
    }

    public int count(Object object) {
        if (this.size() == 0) {
            return 0;
        }
        return this.count(0, this.myLength - 1, object);
    }

    private void createMap() {
        int n;
        this.myMap = new Object[1024][];
        int n2 = this.myMap.length / 2;
        this.myMap[n2] = new Object[128];
        this.myStart.myBlockIndex = n = 64;
        this.myStart.myMapIndex = n2;
        this.myFinish.myBlockIndex = n;
        this.myFinish.myMapIndex = n2;
    }

    public synchronized Enumeration elements() {
        return new DequeIterator(this.myStart);
    }

    public synchronized DequeIterator end() {
        return new DequeIterator(this.myFinish);
    }

    public synchronized boolean equals(Deque deque) {
        Deque deque2 = deque;
        synchronized (deque2) {
            return Algos.equal(this, deque);
        }
    }

    public boolean equals(Object object) {
        return object instanceof Deque && this.equals((Deque)object);
    }

    private static void fill(DequeIterator dequeIterator, DequeIterator dequeIterator2, Object object) {
        while (!dequeIterator.equals(dequeIterator2)) {
            dequeIterator.put(object);
            dequeIterator.advance();
        }
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized Object front() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("Deque is empty");
        }
        return this.myMap[this.myStart.myMapIndex][this.myStart.myBlockIndex];
    }

    private void growMap() {
        int n = this.myMap.length * 2;
        Object[][] objectArray = new Object[n][];
        int n2 = n / 4;
        int n3 = this.myFinish.myMapIndex - this.myStart.myMapIndex + 1;
        System.arraycopy(this.myMap, this.myStart.myMapIndex, objectArray, n2, n3);
        this.myStart.myMapIndex = n2;
        this.myFinish.myMapIndex = n2 + n3 - 1;
        this.myMap = objectArray;
    }

    public synchronized int hashCode() {
        return Algos.orderedHash(this.start(), this.myLength);
    }

    public int indexOf(int n, int n2, Object object) {
        if (n2 < n) {
            return -1;
        }
        this.checkRange(n, n2);
        DequeIterator dequeIterator = this.myStart.copy(n2 + 1);
        return this.indexOf(this.myStart.copy(n), dequeIterator, object);
    }

    synchronized int indexOf(DequeIterator dequeIterator, DequeIterator dequeIterator2, Object object) {
        DequeIterator dequeIterator3 = (DequeIterator)Algos.find(dequeIterator, dequeIterator2, object);
        return dequeIterator3.equals(dequeIterator2) ? -1 : this.myStart.distance(dequeIterator3);
    }

    public int indexOf(Object object) {
        return this.indexOf(this.myStart, this.myFinish, object);
    }

    public synchronized void insert(int n, int n2, Object object) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative n1umber of objects.");
        }
        if (n < 0 || n > this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to insert at index " + n + " when valid range is 0.." + this.myLength);
        }
        this.insert(this.myStart.copy(n), n2, object);
    }

    public synchronized void insert(int n, BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2) {
        if (n < 0 || n > this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to insert at index " + n + " when valid range is 0.." + this.myLength);
        }
        this.insert(this.myStart.copy(n), bidirectionalIterator, bidirectionalIterator2);
    }

    public synchronized DequeIterator insert(int n, Object object) {
        if (n < 0 || n > this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to insert at index " + n + " when valid range is 0.." + this.myLength);
        }
        return this.insert(this.myStart.copy(n), object);
    }

    public synchronized void insert(DequeIterator dequeIterator, int n, Object object) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects");
        }
        if (n == 0) {
            return;
        }
        int n2 = this.myStart.distance(dequeIterator);
        int n3 = dequeIterator.distance(this.myFinish);
        if (n3 > n2) {
            if (n > n2) {
                int n4 = n - n2;
                while (n4-- > 0) {
                    this.pushFront(object);
                }
                int n5 = 1;
                while (n5 <= n2) {
                    this.pushFront(this.at(n - 1));
                    ++n5;
                }
                Deque.fill(this.myStart.copy(n), this.myStart.copy(n + n2), object);
            } else {
                int n6 = 1;
                while (n6 <= n) {
                    this.pushFront(this.at(n - 1));
                    ++n6;
                }
                DequeIterator dequeIterator2 = this.myStart.copy(n + n2);
                Deque.copy(this.myStart.copy(n + n), dequeIterator2, this.myStart.copy(n));
                Deque.fill(this.myStart.copy(n2), dequeIterator2, object);
            }
        } else {
            int n7 = this.size();
            if (n > n3) {
                int n8 = n - n3;
                while (n8-- > 0) {
                    this.pushBack(object);
                }
                int n9 = n2;
                while (n9 < n7) {
                    this.pushBack(this.at(n9));
                    ++n9;
                }
                Deque.fill(this.myStart.copy(n2), this.myStart.copy(n7), object);
            } else {
                int n10;
                int n11 = n10 = n7 - n;
                while (n11 < n7) {
                    this.pushBack(this.at(n11));
                    ++n11;
                }
                DequeIterator dequeIterator3 = this.myStart.copy(n2);
                Deque.copyBackward(dequeIterator3, this.myStart.copy(n10), this.myStart.copy(n7));
                Deque.fill(dequeIterator3, this.myStart.copy(n2 + n), object);
            }
        }
    }

    public synchronized void insert(DequeIterator dequeIterator, BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2) {
        int n = bidirectionalIterator.distance(bidirectionalIterator2);
        int n2 = this.myStart.distance(dequeIterator);
        int n3 = dequeIterator.distance(this.myFinish);
        if (n3 > n2) {
            if (n > n2) {
                BidirectionalIterator bidirectionalIterator3 = (BidirectionalIterator)bidirectionalIterator2.clone();
                bidirectionalIterator3.retreat(n2);
                BidirectionalIterator bidirectionalIterator4 = (BidirectionalIterator)bidirectionalIterator3.clone();
                while (!bidirectionalIterator3.equals(bidirectionalIterator)) {
                    bidirectionalIterator3.retreat();
                    this.pushFront(bidirectionalIterator3.get());
                }
                int n4 = 1;
                while (n4 <= n2) {
                    this.pushFront(this.at(n - 1));
                    ++n4;
                }
                Deque.copy(bidirectionalIterator4, bidirectionalIterator2, this.myStart.copy(n));
            } else {
                int n5 = 1;
                while (n5 <= n) {
                    this.pushFront(this.at(n - 1));
                    ++n5;
                }
                Deque.copy(this.myStart.copy(n + n), this.myStart.copy(n + n2), this.myStart.copy(n));
                Deque.copy(bidirectionalIterator, bidirectionalIterator2, this.myStart.copy(n2));
            }
        } else {
            int n6 = this.size();
            if (n > n3) {
                BidirectionalIterator bidirectionalIterator5 = (BidirectionalIterator)bidirectionalIterator.clone();
                bidirectionalIterator5.advance(n3);
                BidirectionalIterator bidirectionalIterator6 = (BidirectionalIterator)bidirectionalIterator5.clone();
                while (!bidirectionalIterator5.equals(bidirectionalIterator2)) {
                    this.pushBack(bidirectionalIterator5.nextElement());
                }
                int n7 = n2;
                while (n7 < n6) {
                    this.pushBack(this.at(n7));
                    ++n7;
                }
                Deque.copy(bidirectionalIterator, bidirectionalIterator6, this.myStart.copy(n2));
            } else {
                int n8;
                int n9 = n8 = n6 - n;
                while (n9 < n6) {
                    this.pushBack(this.at(n9));
                    ++n9;
                }
                DequeIterator dequeIterator2 = this.myStart.copy(n2);
                Deque.copyBackward(dequeIterator2, this.myStart.copy(n8), this.myStart.copy(n6));
                Deque.copy(bidirectionalIterator, bidirectionalIterator2, this.myStart.copy(n2));
            }
        }
    }

    public synchronized DequeIterator insert(DequeIterator dequeIterator, Object object) {
        if (dequeIterator.equals(this.myStart)) {
            this.pushFront(object);
            return new DequeIterator(this.myStart);
        }
        if (dequeIterator.equals(this.myFinish)) {
            this.pushBack(object);
            return this.myFinish.copy(-1);
        }
        int n = this.myStart.distance(dequeIterator);
        if (dequeIterator.distance(this.myFinish) > n) {
            this.pushFront(this.myStart.get());
            Deque.copy(this.myStart.copy(2), this.myStart.copy(n + 1), this.myStart.copy(1));
            DequeIterator dequeIterator2 = this.myStart.copy(n);
            dequeIterator2.put(object);
            return dequeIterator2;
        }
        DequeIterator dequeIterator3 = this.myFinish.copy(-1);
        this.pushBack(dequeIterator3.get());
        DequeIterator dequeIterator4 = this.myStart.copy(n);
        Deque.copyBackward(dequeIterator4, this.myFinish.copy(-2), this.myFinish.copy(-1));
        dequeIterator4.put(object);
        return dequeIterator4;
    }

    public boolean isEmpty() {
        return this.myLength == 0;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public synchronized Object popBack() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("Deque is empty");
        }
        Object object = this.at(0);
        if (--this.myLength == 0) {
            this.clear();
        } else {
            if (this.myFinish.myBlockIndex-- == 0) {
                this.myMap[this.myFinish.myMapIndex--] = null;
                this.myFinish.myBlockIndex = 127;
            }
            object = this.myMap[this.myFinish.myMapIndex][this.myFinish.myBlockIndex];
            this.myMap[this.myFinish.myMapIndex][this.myFinish.myBlockIndex] = null;
        }
        return object;
    }

    public synchronized Object popFront() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("Deque is empty");
        }
        Object object = this.at(0);
        if (--this.myLength == 0) {
            this.clear();
        } else {
            object = this.myMap[this.myStart.myMapIndex][this.myStart.myBlockIndex];
            this.myMap[this.myStart.myMapIndex][this.myStart.myBlockIndex++] = null;
            if (this.myStart.myBlockIndex == 128) {
                this.myMap[this.myStart.myMapIndex++] = null;
                this.myStart.myBlockIndex = 0;
            }
        }
        return object;
    }

    public void pushBack(Object object) {
        this.add(object);
    }

    public synchronized void pushFront(Object object) {
        if (this.myLength == 0) {
            this.add(object);
            return;
        }
        ++this.myLength;
        if (--this.myStart.myBlockIndex < 0) {
            if (this.myStart.myMapIndex == 0) {
                this.growMap();
            }
            this.myMap[--this.myStart.myMapIndex] = new Object[128];
            this.myStart.myBlockIndex = 127;
        }
        this.myMap[this.myStart.myMapIndex][this.myStart.myBlockIndex] = object;
    }

    public synchronized void put(int n, Object object) {
        if (n < 0 || n >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n + " when valid range is 0.." + (this.myLength - 1));
        }
        int n2 = this.myStart.myBlockIndex + n;
        int n3 = this.myStart.myMapIndex;
        if (n2 >= 128) {
            int n4 = n2 / 128;
            n3 += n4;
            n2 %= 128;
        } else if (n2 < 0) {
            int n5 = (127 - n2) / 128;
            n3 -= n5;
            n2 += n5 * 128;
        }
        this.myMap[n3][n2] = object;
    }

    public synchronized Object remove(int n) {
        if (n < 0 || n >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n + " when valid range is 0.." + (this.myLength - 1));
        }
        return this.remove(this.myStart.copy(n));
    }

    public synchronized int remove(int n, int n2) {
        if (n2 < n) {
            return 0;
        }
        this.checkRange(n, n2);
        return this.remove(this.myStart.copy(n), this.myStart.copy(n2 + 1));
    }

    public synchronized int remove(int n, int n2, Object object) {
        if (n2 < n) {
            return 0;
        }
        this.checkRange(n, n2);
        DequeIterator dequeIterator = this.myStart.copy(n);
        DequeIterator dequeIterator2 = this.myStart.copy(n2 + 1);
        DequeIterator dequeIterator3 = (DequeIterator)Algos.remove(dequeIterator, dequeIterator2, object);
        int n3 = dequeIterator3.distance(dequeIterator2);
        this.remove(dequeIterator3, dequeIterator2);
        return n3;
    }

    public int remove(Object object) {
        return this.remove(0, this.myLength - 1, object);
    }

    public synchronized int remove(Object object, int n) {
        int n2 = 0;
        while (n > 0) {
            int n3 = this.indexOf(object);
            if (n3 < 0) break;
            --n;
            ++n2;
            this.remove(n3);
        }
        return n2;
    }

    public synchronized Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof DequeIterator)) {
            throw new IllegalArgumentException("Enumeration not a DequeIterator");
        }
        if (((DequeIterator)enumeration).myDeque != this) {
            throw new IllegalArgumentException("Enumeration not for this Deque");
        }
        DequeIterator dequeIterator = (DequeIterator)enumeration;
        Object object = dequeIterator.get();
        DequeIterator dequeIterator2 = dequeIterator.copy(1);
        if (this.myStart.distance(dequeIterator) < dequeIterator.distance(this.myFinish)) {
            Deque.copy(dequeIterator2, this.myFinish, dequeIterator);
            this.popBack();
        } else {
            Deque.copyBackward(this.myStart, dequeIterator, dequeIterator2);
            this.popFront();
        }
        return object;
    }

    public synchronized int remove(Enumeration enumeration, Enumeration enumeration2) {
        int n;
        if (!(enumeration instanceof DequeIterator) || !(enumeration2 instanceof DequeIterator)) {
            throw new IllegalArgumentException("Enumeration not a DequeIterator");
        }
        if (((DequeIterator)enumeration).myDeque != this || ((DequeIterator)enumeration2).myDeque != this) {
            throw new IllegalArgumentException("Enumeration not for this Deque");
        }
        DequeIterator dequeIterator = (DequeIterator)enumeration;
        DequeIterator dequeIterator2 = (DequeIterator)enumeration2;
        int n2 = n = dequeIterator.distance(dequeIterator2);
        if (dequeIterator2.distance(this.myFinish) > this.myStart.distance(dequeIterator)) {
            Deque.copyBackward(this.myStart, dequeIterator, dequeIterator2);
            while (n-- > 0) {
                this.popFront();
            }
        } else {
            Deque.copy(dequeIterator2, this.myFinish, dequeIterator);
            while (n-- > 0) {
                this.popBack();
            }
        }
        return n2;
    }

    public synchronized int replace(int n, int n2, Object object, Object object2) {
        if (n2 < n) {
            return 0;
        }
        this.checkRange(n, n2);
        return Algos.replace(this.myStart.copy(n), this.myStart.copy(n2 + 1), object, object2);
    }

    public synchronized int replace(Object object, Object object2) {
        return Algos.replace(this.begin(), this.end(), object, object2);
    }

    public int size() {
        return this.myLength;
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public synchronized void swap(Deque deque) {
        Deque deque2 = deque;
        synchronized (deque2) {
            DequeIterator dequeIterator = this.myStart;
            this.myStart = deque.myStart;
            this.myStart.myDeque = this;
            deque.myStart = dequeIterator;
            deque.myStart.myDeque = deque;
            DequeIterator dequeIterator2 = this.myFinish;
            this.myFinish = deque.myFinish;
            this.myFinish.myDeque = this;
            deque.myFinish = dequeIterator2;
            deque.myFinish.myDeque = deque;
            int n = this.myLength;
            this.myLength = deque.myLength;
            deque.myLength = n;
            Object[][] objectArray = this.myMap;
            this.myMap = deque.myMap;
            deque.myMap = objectArray;
        }
    }

    public synchronized String toString() {
        return Algos.toString(this, "Deque");
    }
}

