/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Algos;
import com.objectspace.jgl.DListIterator;
import com.objectspace.jgl.DListNode;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;

public class DList
implements Sequence {
    transient DListNode myNode;
    transient int myLength;
    static final long serialVersionUID = 6393954640158620295L;

    public DList() {
        this.myNode.next = this.myNode = new DListNode();
        this.myNode.previous = this.myNode;
    }

    public DList(int n) {
        this();
        this.insert(this.myNode.next, n, null);
    }

    public DList(int n, Object object) {
        this();
        this.insert(this.myNode.next, n, object);
    }

    public DList(DList dList) {
        this();
        DList dList2 = dList;
        synchronized (dList2) {
            this.insert(this.myNode.next, dList.myNode.next, dList.myNode);
        }
    }

    public synchronized Object add(Object object) {
        this.insert(this.myNode, object);
        return null;
    }

    public synchronized Object at(int n) {
        if (n < 0 || n >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n + " when valid range is 0.." + (this.myLength - 1));
        }
        DListNode dListNode = this.myNode.next;
        while (n-- > 0) {
            dListNode = dListNode.next;
        }
        return dListNode.object;
    }

    public synchronized Object back() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("DList is empty");
        }
        return this.myNode.previous.object;
    }

    public synchronized DListIterator begin() {
        return new DListIterator(this, this.myNode.next);
    }

    private void checkRange(int n, int n2) {
        if (n < 0 || n >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n + " when valid range is 0.." + (this.myLength - 1));
        }
        if (n2 < 0 || n2 >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n2 + " when valid range is 0.." + (this.myLength - 1));
        }
    }

    public synchronized void clear() {
        this.myNode.next = this.myNode;
        this.myNode.previous = this.myNode;
        this.myLength = 0;
    }

    public synchronized Object clone() {
        return new DList(this);
    }

    public synchronized boolean contains(Object object) {
        return !this.find(object).equals(this.end());
    }

    public synchronized void copy(DList dList) {
        if (this == dList) {
            return;
        }
        DList dList2 = dList;
        synchronized (dList2) {
            DListNode dListNode = this.myNode.next;
            DListNode dListNode2 = this.myNode;
            DListNode dListNode3 = dList.myNode.next;
            DListNode dListNode4 = dList.myNode;
            while (dListNode != dListNode2 && dListNode3 != dListNode4) {
                dListNode.object = dListNode3.object;
                dListNode = dListNode.next;
                dListNode3 = dListNode3.next;
            }
            if (dListNode3 == dListNode4) {
                this.remove(dListNode, dListNode2);
            } else {
                this.insert(dListNode2, dListNode3, dListNode4);
            }
        }
    }

    public synchronized int count(int n, int n2, Object object) {
        if (n2 < n) {
            return 0;
        }
        this.checkRange(n, n2);
        return Algos.count(this.iteratorAt(n), this.iteratorAt(n2 + 1), object);
    }

    public synchronized int count(DListIterator dListIterator, DListIterator dListIterator2, Object object) {
        return Algos.count(dListIterator, dListIterator2, object);
    }

    public int count(Object object) {
        return this.count(this.begin(), this.end(), object);
    }

    public synchronized Enumeration elements() {
        return new DListIterator(this, this.myNode.next);
    }

    public synchronized DListIterator end() {
        return new DListIterator(this, this.myNode);
    }

    public synchronized boolean equals(DList dList) {
        DList dList2 = dList;
        synchronized (dList2) {
            return Algos.equal(this, dList);
        }
    }

    public boolean equals(Object object) {
        return object instanceof DList && this.equals((DList)object);
    }

    public synchronized DListIterator find(DListIterator dListIterator, DListIterator dListIterator2, Object object) {
        return (DListIterator)Algos.find(dListIterator, dListIterator2, object);
    }

    public synchronized DListIterator find(Object object) {
        return (DListIterator)Algos.find(new DListIterator(this, this.myNode.next), new DListIterator(this, this.myNode), object);
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized Object front() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("DList is empty");
        }
        return this.myNode.next.object;
    }

    public synchronized int hashCode() {
        return Algos.orderedHash(this.start(), this.myLength);
    }

    public synchronized int indexOf(int n, int n2, Object object) {
        if (n2 < n) {
            return 0;
        }
        this.checkRange(n, n2);
        DListIterator dListIterator = this.iteratorAt(n2 + 1);
        DListIterator dListIterator2 = this.find(this.iteratorAt(n), dListIterator, object);
        return dListIterator2.myNode == dListIterator.myNode ? -1 : dListIterator2.index();
    }

    public synchronized int indexOf(Object object) {
        DListIterator dListIterator = (DListIterator)Algos.find(new DListIterator(this, this.myNode.next), new DListIterator(this, this.myNode), object);
        return dListIterator.myNode == this.myNode ? -1 : dListIterator.index();
    }

    public synchronized void insert(int n, int n2, Object object) {
        if (n > this.myLength || this.myLength == 0 && n > 0) {
            throw new IndexOutOfBoundsException("Attempt to insert at index " + n + " when valid range is 0.." + this.myLength);
        }
        if (this.myLength == 0) {
            this.pushFront(object);
            --n2;
        }
        this.insert(this.nodeAt(n), n2, object);
    }

    public synchronized void insert(int n, Object object) {
        if (n > this.myLength || this.myLength == 0 && n > 0) {
            throw new IndexOutOfBoundsException("Attempt to insert at index " + n + " when valid range is 0.." + this.myLength);
        }
        if (this.myLength == 0) {
            this.pushFront(object);
        } else {
            this.insert(this.nodeAt(n), object);
        }
    }

    public synchronized void insert(DListIterator dListIterator, int n, Object object) {
        this.insert(dListIterator.myNode, n, object);
    }

    public synchronized void insert(DListIterator dListIterator, InputIterator inputIterator, InputIterator inputIterator2) {
        InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
        while (!inputIterator3.equals(inputIterator2)) {
            this.insert(dListIterator.myNode, inputIterator3.nextElement());
        }
    }

    public synchronized DListIterator insert(DListIterator dListIterator, Object object) {
        return new DListIterator(this, this.insert(dListIterator.myNode, object));
    }

    /*
     * Unable to fully structure code
     */
    private void insert(DListNode var1_1, int var2_2, Object var3_3) {
        if (var2_2 >= 0) ** GOTO lbl5
        throw new IllegalArgumentException("Attempt to specify a insert a negative number of objects");
lbl-1000:
        // 1 sources

        {
            this.insert(var1_1, var3_3);
lbl5:
            // 2 sources

            ** while (var2_2-- > 0)
        }
lbl6:
        // 1 sources

    }

    private void insert(DListNode dListNode, DListNode dListNode2, DListNode dListNode3) {
        while (dListNode2 != dListNode3) {
            this.insert(dListNode, dListNode2.object);
            dListNode2 = dListNode2.next;
        }
    }

    private DListNode insert(DListNode dListNode, Object object) {
        DListNode dListNode2 = new DListNode();
        dListNode2.object = object;
        dListNode2.next = dListNode;
        dListNode2.previous = dListNode.previous;
        dListNode.previous.next = dListNode2;
        dListNode.previous = dListNode2;
        ++this.myLength;
        return dListNode2;
    }

    public boolean isEmpty() {
        return this.myLength == 0;
    }

    DListIterator iteratorAt(int n) {
        DListNode dListNode = this.myNode.next;
        while (n-- > 0) {
            dListNode = dListNode.next;
        }
        return new DListIterator(this, dListNode);
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    DListNode nodeAt(int n) {
        DListNode dListNode = this.myNode.next;
        while (n-- > 0) {
            dListNode = dListNode.next;
        }
        return dListNode;
    }

    public synchronized Object popBack() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("DList is empty");
        }
        DListNode dListNode = this.myNode.previous;
        dListNode.previous.next = dListNode.next;
        dListNode.next.previous = dListNode.previous;
        --this.myLength;
        return dListNode.object;
    }

    public synchronized Object popFront() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("DList is empty");
        }
        DListNode dListNode = this.myNode.next;
        dListNode.previous.next = dListNode.next;
        dListNode.next.previous = dListNode.previous;
        --this.myLength;
        return dListNode.object;
    }

    public synchronized void pushBack(Object object) {
        this.insert(this.myNode, object);
    }

    public synchronized void pushFront(Object object) {
        this.insert(this.myNode.next, object);
    }

    public synchronized void put(int n, Object object) {
        if (n < 0 || n >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n + " when valid range is 0.." + (this.myLength - 1));
        }
        DListNode dListNode = this.myNode.next;
        while (n-- > 0) {
            dListNode = dListNode.next;
        }
        dListNode.object = object;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.myNode.next = this.myNode = new DListNode();
        this.myNode.previous = this.myNode;
        this.myLength = 0;
        int n = objectInputStream.readInt();
        while (n-- > 0) {
            this.add(objectInputStream.readObject());
        }
    }

    public synchronized Object remove(int n) {
        if (n < 0 || n >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n + " when valid range is 0.." + (this.myLength - 1));
        }
        return this.remove(this.nodeAt(n));
    }

    public synchronized int remove(int n, int n2) {
        if (n2 < n) {
            return 0;
        }
        this.checkRange(n, n2);
        return this.remove(this.nodeAt(n), this.nodeAt(n2 + 1));
    }

    public synchronized int remove(int n, int n2, Object object) {
        if (n2 < n) {
            return 0;
        }
        this.checkRange(n, n2);
        return this.remove(this.nodeAt(n), this.nodeAt(n2 + 1), object, this.myLength);
    }

    private Object remove(DListNode dListNode) {
        dListNode.previous.next = dListNode.next;
        dListNode.next.previous = dListNode.previous;
        --this.myLength;
        return dListNode.object;
    }

    private int remove(DListNode dListNode, DListNode dListNode2) {
        int n = 0;
        while (dListNode != dListNode2) {
            dListNode.previous.next = dListNode.next;
            dListNode.next.previous = dListNode.previous;
            ++n;
            dListNode = dListNode.next;
        }
        this.myLength -= n;
        return n;
    }

    private int remove(DListNode dListNode, DListNode dListNode2, Object object, int n) {
        if (n <= 0) {
            return 0;
        }
        int n2 = 0;
        DListNode dListNode3 = dListNode;
        while (n > 0 && dListNode3 != dListNode2) {
            if (dListNode3.object.equals(object)) {
                dListNode3.previous.next = dListNode3.next;
                dListNode3.next.previous = dListNode3.previous;
                ++n2;
                --n;
            }
            dListNode3 = dListNode3.next;
        }
        this.myLength -= n2;
        return n2;
    }

    public synchronized int remove(Object object) {
        return this.remove(this.myNode.next, this.myNode, object, this.myLength);
    }

    public synchronized int remove(Object object, int n) {
        return this.remove(this.myNode.next, this.myNode, object, n);
    }

    public synchronized Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof DListIterator)) {
            throw new IllegalArgumentException("Enumeration not a DListIterator");
        }
        if (((DListIterator)enumeration).myDList != this) {
            throw new IllegalArgumentException("Enumeration not for this DList");
        }
        Object object = ((DListIterator)enumeration).get();
        this.remove(((DListIterator)enumeration).myNode);
        return object;
    }

    public synchronized int remove(Enumeration enumeration, Enumeration enumeration2) {
        if (!(enumeration instanceof DListIterator) || !(enumeration2 instanceof DListIterator)) {
            throw new IllegalArgumentException("Enumeration not a DListIterator");
        }
        if (((DListIterator)enumeration).myDList != this || ((DListIterator)enumeration2).myDList != this) {
            throw new IllegalArgumentException("Enumeration not for this DList");
        }
        DListIterator dListIterator = (DListIterator)enumeration;
        DListIterator dListIterator2 = (DListIterator)enumeration2;
        return this.remove(dListIterator.myNode, dListIterator2.myNode);
    }

    public synchronized int remove(Enumeration enumeration, Enumeration enumeration2, Object object) {
        if (!(enumeration instanceof DListIterator) || !(enumeration2 instanceof DListIterator)) {
            throw new IllegalArgumentException("Enumeration not a DListIterator");
        }
        if (((DListIterator)enumeration).myDList != this || ((DListIterator)enumeration2).myDList != this) {
            throw new IllegalArgumentException("Enumeration not for this DList");
        }
        DListIterator dListIterator = (DListIterator)enumeration;
        DListIterator dListIterator2 = (DListIterator)enumeration2;
        return this.remove(dListIterator.myNode, dListIterator2.myNode, object, this.myLength);
    }

    public synchronized int replace(int n, int n2, Object object, Object object2) {
        if (n2 < n) {
            return 0;
        }
        this.checkRange(n, n2);
        return Algos.replace(this.iteratorAt(n), this.iteratorAt(n2 + 1), object, object2);
    }

    public synchronized int replace(DListIterator dListIterator, DListIterator dListIterator2, Object object, Object object2) {
        if (!dListIterator.isCompatibleWith(dListIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return Algos.replace(dListIterator, dListIterator2, object, object2);
    }

    public synchronized int replace(Object object, Object object2) {
        return Algos.replace(this.begin(), this.end(), object, object2);
    }

    public synchronized void reverse() {
        if (this.myLength < 2) {
            return;
        }
        DListNode dListNode = this.myNode.next.next;
        while (dListNode != this.myNode) {
            DListNode dListNode2 = dListNode;
            dListNode = dListNode.next;
            this.transfer(this.myNode.next, dListNode2, dListNode);
        }
    }

    public int size() {
        return this.myLength;
    }

    public synchronized void splice(int n, DList dList) {
        if (n > this.myLength || this.myLength == 0 && n > 0) {
            throw new IndexOutOfBoundsException("Attempt to insert at index " + n + " when valid range is 0.." + this.myLength);
        }
        if (this.myLength == 0) {
            this.swap(dList);
        } else {
            this.splice(this.nodeAt(n), dList);
        }
    }

    public synchronized void splice(int n, DList dList, int n2) {
        if (n > this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to insert at index " + n + " when valid range is 0.." + this.myLength);
        }
        if (n2 < 0 || n2 >= dList.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n2 + " when valid range is 0.." + (dList.myLength - 1));
        }
        this.splice(this.nodeAt(n), dList, dList.nodeAt(n2));
    }

    public synchronized void splice(int n, DList dList, int n2, int n3) {
        if (n > this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to insert at index " + n + " when valid range is 0.." + this.myLength);
        }
        if (n2 < 0 || n2 >= dList.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n2 + " when valid range is 0.." + (dList.myLength - 1));
        }
        if (n3 < 0 || n3 >= dList.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n3 + " when valid range is 0.." + (dList.myLength - 1));
        }
        this.splice(this.iteratorAt(n), dList, dList.iteratorAt(n2), dList.iteratorAt(n3 + 1));
    }

    public synchronized void splice(DListIterator dListIterator, DList dList) {
        this.splice(dListIterator.myNode, dList);
    }

    public synchronized void splice(DListIterator dListIterator, DList dList, DListIterator dListIterator2) {
        this.splice(dListIterator.myNode, dList, dListIterator2.myNode);
    }

    public synchronized void splice(DListIterator dListIterator, DList dList, DListIterator dListIterator2, DListIterator dListIterator3) {
        DList dList2 = dList;
        synchronized (dList2) {
            if (dListIterator2.myNode != dListIterator3.myNode) {
                if (dList != this) {
                    int n = dListIterator2.distance(dListIterator3);
                    dList.myLength -= n;
                    this.myLength += n;
                } else {
                    DListNode dListNode = dListIterator2.myNode.next;
                    while (dListNode != dListIterator3.myNode) {
                        if (dListIterator.myNode == dListNode) {
                            throw new InvalidOperationException("Tried to splice into an overlapping area.");
                        }
                        dListNode = dListNode.next;
                    }
                }
                this.transfer(dListIterator.myNode, dListIterator2.myNode, dListIterator3.myNode);
            }
        }
    }

    private void splice(DListNode dListNode, DList dList) {
        DList dList2 = dList;
        synchronized (dList2) {
            if (dList.myLength > 0) {
                this.transfer(dListNode, dList.myNode.next, dList.myNode);
                this.myLength += dList.myLength;
                dList.myLength = 0;
            }
        }
    }

    private void splice(DListNode dListNode, DList dList, DListNode dListNode2) {
        DList dList2 = dList;
        synchronized (dList2) {
            if (dListNode != dListNode2 && dListNode != dListNode2.next) {
                this.transfer(dListNode, dListNode2, dListNode2.next);
                ++this.myLength;
                --dList.myLength;
            }
        }
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public synchronized void swap(DList dList) {
        DList dList2 = dList;
        synchronized (dList2) {
            DListNode dListNode = this.myNode;
            int n = this.myLength;
            this.myNode = dList.myNode;
            this.myLength = dList.myLength;
            dList.myNode = dListNode;
            dList.myLength = n;
        }
    }

    public synchronized String toString() {
        return Algos.toString(this, "DList");
    }

    private void transfer(DListNode dListNode, DListNode dListNode2, DListNode dListNode3) {
        if (dListNode != dListNode2 && dListNode != dListNode3) {
            dListNode3.previous.next = dListNode;
            dListNode2.previous.next = dListNode3;
            dListNode.previous.next = dListNode2;
            DListNode dListNode4 = dListNode.previous;
            dListNode.previous = dListNode3.previous;
            dListNode3.previous = dListNode2.previous;
            dListNode2.previous = dListNode4;
        }
    }

    public synchronized void unique() {
        if (this.myLength == 0) {
            return;
        }
        DListNode dListNode = this.myNode.next;
        DListNode dListNode2 = this.myNode;
        DListNode dListNode3 = dListNode.next;
        while (dListNode3 != dListNode2) {
            if (dListNode.object.equals(dListNode3.object)) {
                dListNode3.previous.next = dListNode3.next;
                dListNode3.next.previous = dListNode3.previous;
                --this.myLength;
            } else {
                dListNode = dListNode3;
            }
            dListNode3 = dListNode.next;
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        DListIterator dListIterator = this.begin();
        while (dListIterator.hasMoreElements()) {
            objectOutputStream.writeObject(dListIterator.nextElement());
        }
    }
}

