/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Array;
import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.Opaque;
import com.objectspace.jgl.RandomAccessIterator;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class ArrayIterator
implements RandomAccessIterator,
Serializable,
Opaque {
    Array myArray;
    int myIndex;
    static final long serialVersionUID = 5656837180380660021L;

    public ArrayIterator() {
    }

    public ArrayIterator(Array array, int n) {
        this.myArray = array;
        this.myIndex = n;
    }

    public ArrayIterator(ArrayIterator arrayIterator) {
        this.myArray = arrayIterator.myArray;
        this.myIndex = arrayIterator.myIndex;
    }

    public void advance() {
        ++this.myIndex;
    }

    public void advance(int n) {
        this.myIndex += n;
    }

    public boolean atBegin() {
        return this.myIndex == 0;
    }

    public boolean atEnd() {
        return this.myIndex == this.myArray.size();
    }

    public Object clone() {
        return new ArrayIterator(this);
    }

    public int distance(ForwardIterator forwardIterator) {
        return forwardIterator instanceof RandomAccessIterator ? ((RandomAccessIterator)forwardIterator).index() - this.myIndex : -1;
    }

    public boolean equals(Object object) {
        if (object instanceof RandomAccessIterator) {
            RandomAccessIterator randomAccessIterator = (RandomAccessIterator)object;
            return this.myIndex == randomAccessIterator.index() && this.isCompatibleWith(randomAccessIterator);
        }
        return false;
    }

    public Object get() {
        return this.myArray.at(this.myIndex);
    }

    public Object get(int n) {
        return this.myArray.at(this.myIndex + n);
    }

    public Container getContainer() {
        return this.myArray;
    }

    public boolean hasMoreElements() {
        return this.myIndex < this.myArray.size();
    }

    public int index() {
        return this.myIndex;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof Opaque && this.opaqueId() == ((Opaque)((Object)inputIterator)).opaqueId();
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.myIndex < randomAccessIterator.index();
    }

    public Object nextElement() {
        try {
            return this.myArray.at(this.myIndex++);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("ArrayIterator");
        }
    }

    public Object opaqueData() {
        return null;
    }

    public int opaqueId() {
        return System.identityHashCode(this.myArray);
    }

    public void put(int n, Object object) {
        this.myArray.put(this.myIndex + n, object);
    }

    public void put(Object object) {
        this.myArray.put(this.myIndex, object);
    }

    public void retreat() {
        --this.myIndex;
    }

    public void retreat(int n) {
        this.myIndex -= n;
    }
}

