/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Algos;
import com.objectspace.jgl.ArrayIterator;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import java.util.Enumeration;

public class Array
implements Sequence {
    Object[] myStorage;
    int myLength;
    static final int DEFAULT_SIZE = 10;
    static final int THRESHOLD = 2000;
    static final int MULTIPLIER = 2;
    static final long serialVersionUID = 2600370816661330188L;

    public Array() {
        this.myStorage = new Object[10];
    }

    public Array(Object[] objectArray) {
        Object[] objectArray2 = objectArray;
        synchronized (objectArray) {
            this.myLength = objectArray.length;
            this.myStorage = new Object[this.myLength];
            System.arraycopy(objectArray, 0, this.myStorage, 0, this.myLength);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Array(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to create an Array with a negative size");
        }
        this.myLength = n;
        this.myStorage = new Object[this.myLength];
    }

    public Array(int n, Object object) {
        this(n);
        int n2 = 0;
        while (n2 < this.myLength) {
            this.myStorage[n2] = object;
            ++n2;
        }
    }

    public Array(Array array) {
        Array array2 = array;
        synchronized (array2) {
            this.myLength = array.myLength;
            this.myStorage = new Object[this.myLength];
            System.arraycopy(array.myStorage, 0, this.myStorage, 0, this.myLength);
        }
    }

    public synchronized Object add(Object object) {
        if (this.myLength == this.myStorage.length) {
            Object[] objectArray = this.getNextStorage(1);
            System.arraycopy(this.myStorage, 0, objectArray, 0, this.myLength);
            this.myStorage = objectArray;
        }
        this.myStorage[this.myLength++] = object;
        return null;
    }

    public synchronized Object at(int n) {
        Array.checkIndex(n, this.myLength);
        return this.myStorage[n];
    }

    public synchronized Object back() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("Array is empty");
        }
        return this.myStorage[this.myLength - 1];
    }

    public synchronized ArrayIterator begin() {
        return new ArrayIterator(this, 0);
    }

    public int capacity() {
        return this.myStorage.length;
    }

    protected static final void checkIndex(int n, int n2) {
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n + "; valid range is 0.." + (n2 - 1));
        }
    }

    protected static final void checkRange(int n, int n2, int n3) {
        Array.checkIndex(n, n3);
        Array.checkIndex(n2, n3);
    }

    public synchronized void clear() {
        this.myStorage = new Object[10];
        this.myLength = 0;
    }

    public synchronized Object clone() {
        return new Array(this);
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public synchronized void copy(Array array) {
        if (this == array) {
            return;
        }
        Array array2 = array;
        synchronized (array2) {
            if (array.myLength > this.myStorage.length) {
                this.myStorage = new Object[array.myLength];
                System.arraycopy(array.myStorage, 0, this.myStorage, 0, array.myLength);
            } else if (this.myLength > array.myLength) {
                System.arraycopy(array.myStorage, 0, this.myStorage, 0, array.myLength);
                int n = array.myLength;
                while (n < this.myLength) {
                    this.myStorage[n] = null;
                    ++n;
                }
            } else {
                System.arraycopy(array.myStorage, 0, this.myStorage, 0, array.myLength);
            }
            this.myLength = array.myLength;
        }
    }

    public synchronized void copyTo(Object[] objectArray) {
        Object[] objectArray2 = objectArray;
        synchronized (objectArray) {
            if (this.myLength < objectArray.length) {
                System.arraycopy(this.myStorage, 0, objectArray, 0, this.myLength);
            } else {
                System.arraycopy(this.myStorage, 0, objectArray, 0, objectArray.length);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public synchronized int count(int n, int n2, Object object) {
        if (n2 < n) {
            return 0;
        }
        Array.checkRange(n, n2, this.myLength);
        return Algos.count(new ArrayIterator(this, n), new ArrayIterator(this, n2 + 1), object);
    }

    public int count(Object object) {
        if (this.size() == 0) {
            return 0;
        }
        return this.count(0, this.myLength - 1, object);
    }

    public synchronized Enumeration elements() {
        return new ArrayIterator(this, 0);
    }

    public synchronized ArrayIterator end() {
        return new ArrayIterator(this, this.myLength);
    }

    public synchronized void ensureCapacity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to reserve a negative size.");
        }
        if (this.myStorage.length < n) {
            Object[] objectArray = new Object[n];
            if (this.myLength > 0) {
                System.arraycopy(this.myStorage, 0, objectArray, 0, this.myLength);
            }
            this.myStorage = objectArray;
        }
    }

    public synchronized boolean equals(Array array) {
        Array array2 = array;
        synchronized (array2) {
            return Algos.equal(this, array);
        }
    }

    public boolean equals(Object object) {
        return object instanceof Array && this.equals((Array)object);
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized Object front() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("Array is empty");
        }
        return this.myStorage[0];
    }

    static final int getNextSize(int n) {
        int n2 = n > 2000 ? n + 2000 : n * 2;
        return Math.max(1, n2);
    }

    private Object[] getNextStorage(int n) {
        int n2 = Math.max(Array.getNextSize(this.myLength), this.myLength + n);
        Object[] objectArray = new Object[n2];
        return objectArray;
    }

    public synchronized int hashCode() {
        return Algos.orderedHash(this.begin(), this.myLength);
    }

    public synchronized int indexOf(int n, int n2, Object object) {
        if (n2 < n) {
            return -1;
        }
        Array.checkRange(n, n2, this.myLength);
        int n3 = ((ArrayIterator)Algos.find((InputIterator)new ArrayIterator((Array)this, (int)n), (InputIterator)new ArrayIterator((Array)this, (int)(n2 + 1)), (Object)object)).myIndex;
        return n3 == n2 + 1 ? -1 : n3;
    }

    public int indexOf(Object object) {
        return this.indexOf(0, this.myLength - 1, object);
    }

    public synchronized void insert(int n, int n2, Object object) {
        Array.checkIndex(n, this.myLength + 1);
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects.");
        }
        if (n2 == 0) {
            return;
        }
        if (this.myStorage.length - this.myLength >= n2) {
            System.arraycopy(this.myStorage, n, this.myStorage, n + n2, this.myLength - n);
        } else {
            Object[] objectArray = this.getNextStorage(n2);
            System.arraycopy(this.myStorage, 0, objectArray, 0, n);
            System.arraycopy(this.myStorage, n, objectArray, n + n2, this.myLength - n);
            this.myStorage = objectArray;
        }
        int n3 = n;
        while (n3 < n + n2) {
            this.myStorage[n3] = object;
            ++n3;
        }
        this.myLength += n2;
    }

    public synchronized void insert(int n, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        Array.checkIndex(n, this.myLength + 1);
        int n2 = forwardIterator.distance(forwardIterator2);
        if (n2 == 0) {
            return;
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        if (this.myStorage.length - this.myLength >= n2) {
            System.arraycopy(this.myStorage, n, this.myStorage, n + n2, this.myLength - n);
        } else {
            Object[] objectArray = this.getNextStorage(n2);
            System.arraycopy(this.myStorage, 0, objectArray, 0, n);
            System.arraycopy(this.myStorage, n, objectArray, n + n2, this.myLength - n);
            this.myStorage = objectArray;
        }
        int n3 = n;
        while (n3 < n + n2) {
            this.myStorage[n3] = forwardIterator3.nextElement();
            ++n3;
        }
        this.myLength += n2;
    }

    public synchronized void insert(int n, Object object) {
        Array.checkIndex(n, this.myLength + 1);
        if (this.myLength != this.myStorage.length) {
            if (n != this.myLength) {
                System.arraycopy(this.myStorage, n, this.myStorage, n + 1, this.myLength - n);
            }
        } else {
            Object[] objectArray = this.getNextStorage(1);
            System.arraycopy(this.myStorage, 0, objectArray, 0, n);
            System.arraycopy(this.myStorage, n, objectArray, n + 1, this.myLength - n);
            this.myStorage = objectArray;
        }
        this.myStorage[n] = object;
        ++this.myLength;
    }

    public void insert(ArrayIterator arrayIterator, int n, Object object) {
        this.insert(arrayIterator.myIndex, n, object);
    }

    public void insert(ArrayIterator arrayIterator, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        this.insert(arrayIterator.myIndex, forwardIterator, forwardIterator2);
    }

    public ArrayIterator insert(ArrayIterator arrayIterator, Object object) {
        this.insert(arrayIterator.myIndex, object);
        return new ArrayIterator(this, arrayIterator.myIndex);
    }

    public boolean isEmpty() {
        return this.myLength == 0;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public synchronized Object popBack() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("Array is empty");
        }
        Object object = this.myStorage[--this.myLength];
        this.myStorage[this.myLength] = null;
        return object;
    }

    public synchronized Object popFront() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("Array is empty");
        }
        Object object = this.myStorage[0];
        this.remove(0);
        return object;
    }

    public void pushBack(Object object) {
        this.add(object);
    }

    public void pushFront(Object object) {
        this.insert(0, object);
    }

    public synchronized void put(int n, Object object) {
        Array.checkIndex(n, this.myLength);
        this.myStorage[n] = object;
    }

    public synchronized Object remove(int n) {
        Array.checkIndex(n, this.myLength);
        Object object = this.myStorage[n];
        System.arraycopy(this.myStorage, n + 1, this.myStorage, n, this.myLength - n - 1);
        this.myStorage[--this.myLength] = null;
        return object;
    }

    public synchronized int remove(int n, int n2) {
        if (n2 < n) {
            return 0;
        }
        Array.checkRange(n, n2, this.myLength);
        int n3 = n2 - n + 1;
        System.arraycopy(this.myStorage, n2 + 1, this.myStorage, n, this.myLength - n2 - 1);
        int n4 = this.myLength - n3;
        while (n4 < this.myLength) {
            this.myStorage[n4] = null;
            ++n4;
        }
        this.myLength -= n3;
        return n3;
    }

    public synchronized int remove(int n, int n2, Object object) {
        if (n2 < n) {
            return 0;
        }
        Array.checkRange(n, n2, this.myLength);
        ArrayIterator arrayIterator = new ArrayIterator(this, n);
        ArrayIterator arrayIterator2 = new ArrayIterator(this, n2 + 1);
        ArrayIterator arrayIterator3 = (ArrayIterator)Algos.remove(arrayIterator, arrayIterator2, object);
        return this.remove(arrayIterator3.myIndex, n2);
    }

    public int remove(Object object) {
        return this.remove(0, this.myLength - 1, object);
    }

    public synchronized int remove(Object object, int n) {
        int n2 = 0;
        while (n > 0) {
            int n3 = this.indexOf(object);
            if (n3 < 0) break;
            --n;
            ++n2;
            this.remove(n3);
        }
        return n2;
    }

    public Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof ArrayIterator)) {
            throw new IllegalArgumentException("Enumeration not an ArrayIterator");
        }
        if (((ArrayIterator)enumeration).myArray != this) {
            throw new IllegalArgumentException("Enumeration not for this Array ");
        }
        Object object = ((ArrayIterator)enumeration).get();
        this.remove(((ArrayIterator)enumeration).myIndex);
        return object;
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        if (!(enumeration instanceof ArrayIterator) || !(enumeration2 instanceof ArrayIterator)) {
            throw new IllegalArgumentException("Enumeration not an ArrayIterator");
        }
        if (((ArrayIterator)enumeration).myArray != this || ((ArrayIterator)enumeration2).myArray != this) {
            throw new IllegalArgumentException("Enumeration not for this Array ");
        }
        return this.remove(((ArrayIterator)enumeration).myIndex, ((ArrayIterator)enumeration2).myIndex - 1);
    }

    public synchronized int replace(int n, int n2, Object object, Object object2) {
        if (n2 < n) {
            return 0;
        }
        Array.checkRange(n, n2, this.myLength);
        return Algos.replace(new ArrayIterator(this, n), new ArrayIterator(this, n2 + 1), object, object2);
    }

    public synchronized int replace(Object object, Object object2) {
        return Algos.replace(this.begin(), this.end(), object, object2);
    }

    public synchronized void setSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to become a negative size.");
        }
        if (this.myLength > n) {
            this.remove(n, this.myLength - 1);
        } else if (this.myLength < n) {
            this.insert(this.myLength, n - this.myLength, null);
        }
    }

    public int size() {
        return this.myLength;
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public synchronized void swap(Array array) {
        Array array2 = array;
        synchronized (array2) {
            int n = this.myLength;
            Object[] objectArray = this.myStorage;
            this.myLength = array.myLength;
            this.myStorage = array.myStorage;
            array.myLength = n;
            array.myStorage = objectArray;
        }
    }

    public synchronized String toString() {
        return Algos.toString(this, "Array");
    }

    public synchronized void trimToSize() {
        if (this.myLength < this.myStorage.length) {
            Object[] objectArray = this.myStorage;
            this.myStorage = new Object[this.myLength];
            System.arraycopy(objectArray, 0, this.myStorage, 0, this.myLength);
        }
    }
}

