/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;

final class Algos {
    static final int HASH_SIZE = 16;

    private Algos() {
    }

    public static int count(InputIterator inputIterator, InputIterator inputIterator2, Object object) {
        InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
        int n = 0;
        while (!inputIterator3.equals(inputIterator2)) {
            if (!inputIterator3.nextElement().equals(object)) continue;
            ++n;
        }
        return n;
    }

    public static boolean equal(Container container, Container container2) {
        if (container.size() != container2.size()) {
            return false;
        }
        ForwardIterator forwardIterator = container.start();
        ForwardIterator forwardIterator2 = container2.start();
        while (forwardIterator.hasMoreElements()) {
            if (forwardIterator.nextElement().equals(forwardIterator2.nextElement())) continue;
            return false;
        }
        return true;
    }

    public static InputIterator find(InputIterator inputIterator, InputIterator inputIterator2, Object object) {
        InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
        while (!inputIterator3.equals(inputIterator2) && !inputIterator3.get().equals(object)) {
            inputIterator3.advance();
        }
        return inputIterator3;
    }

    public static int orderedHash(ForwardIterator forwardIterator, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        if (n >= 16) {
            n4 = n / 16;
            forwardIterator.advance(n % 16);
        }
        while (forwardIterator.hasMoreElements()) {
            if (forwardIterator.get() != null) {
                n2 ^= forwardIterator.get().hashCode() / (n3 % 16 + 1);
            }
            ++n3;
            forwardIterator.advance(n4);
        }
        return n2;
    }

    public static ForwardIterator remove(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, Object object) {
        if ((forwardIterator = (ForwardIterator)Algos.find(forwardIterator, forwardIterator2, object)).equals(forwardIterator2)) {
            return forwardIterator;
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        forwardIterator3.advance();
        while (!forwardIterator3.equals(forwardIterator2)) {
            if (!forwardIterator3.get().equals(object)) {
                forwardIterator.put(forwardIterator3.get());
                forwardIterator.advance();
            }
            forwardIterator3.advance();
        }
        return forwardIterator;
    }

    public static int replace(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, Object object, Object object2) {
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        int n = 0;
        while (!forwardIterator3.equals(forwardIterator2)) {
            if (forwardIterator3.get().equals(object)) {
                forwardIterator3.put(object2);
                ++n;
            }
            forwardIterator3.advance();
        }
        return n;
    }

    public static String toString(Container container, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("(");
        boolean bl = true;
        ForwardIterator forwardIterator = container.start();
        while (forwardIterator.hasMoreElements()) {
            if (bl) {
                stringBuffer.append(" ");
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(forwardIterator.nextElement());
        }
        if (bl) {
            stringBuffer.append(")");
        } else {
            stringBuffer.append(" )");
        }
        return stringBuffer.toString();
    }

    public static int unorderedHash(ForwardIterator forwardIterator) {
        int n = 0;
        while (forwardIterator.hasMoreElements()) {
            if (forwardIterator.get() != null) {
                n ^= forwardIterator.get().hashCode();
            }
            forwardIterator.advance();
        }
        return n;
    }
}

