/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.spinner;

import com.ibm.webrunner.spinner.SpinnerGUI;
import com.ibm.webrunner.spinner.StringSpinner;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

class StringSpinnerGUI
extends SpinnerGUI
implements ActionListener,
FocusListener,
KeyListener {
    private static final String COPYRIGHT = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 2.0\n(C) Copyright IBM Corp. 1998 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected transient PropertyChangeListener propertyChangeListener;
    protected transient ChangeListener changeListener = this.createChangeListener();

    public StringSpinnerGUI(JComponent jComponent) {
        super(jComponent);
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.installListeners(jComponent);
        this.initTextField();
    }

    protected StringSpinner getSpinner() {
        return (StringSpinner)this.spinner;
    }

    protected void installListeners(JComponent jComponent) {
        this.getSpinner().addChangeListener(this.changeListener);
        this.getSpinner().addPropertyChangeListener(this.propertyChangeListener);
    }

    private void initTextField() {
        this.textField.setText(this.getSpinner().getValue());
        this.textField.addActionListener((ActionListener)this);
        this.textField.addFocusListener(this);
        this.textField.addKeyListener(this);
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 38) {
            this.getSpinner().scrollUp();
            return;
        }
        if (n == 40) {
            this.getSpinner().scrollDown();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.textField.postActionEvent();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.getSpinner().setValue(this.textField.getText());
    }

    protected ChangeListener createChangeListener() {
        return new SpinnerChangeListener();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new SpinnerPropertyChangeListener();
    }

    protected class SpinnerChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            StringSpinnerGUI.this.textField.setText(StringSpinnerGUI.this.getSpinner().getValue());
        }

        protected SpinnerChangeListener() {
            StringSpinnerGUI.this = StringSpinnerGUI.this;
        }
    }

    protected class SpinnerPropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("orientation")) {
                StringSpinnerGUI.this.removeButtons();
                StringSpinnerGUI.this.addButtons();
            }
        }

        protected SpinnerPropertyChangeListener() {
            StringSpinnerGUI.this = StringSpinnerGUI.this;
        }
    }
}

