/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.spinner;

import com.ibm.webrunner.spinner.DefaultComboBoxModel;
import com.ibm.webrunner.spinner.Spinner;
import com.ibm.webrunner.spinner.SpinnerGUI;
import com.ibm.webrunner.spinner.StringSpinnerGUI;
import com.sun.java.swing.ComboBoxModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.event.ListDataEvent;
import com.sun.java.swing.event.ListDataListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Vector;

public class StringSpinner
extends Spinner
implements Serializable {
    private static final String COPYRIGHT = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 2.0\n(C) Copyright IBM Corp. 1998 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private ComboBoxModel fDataModel;
    private SpinnerGUI fGUI;
    private transient ListDataListener fDataModelListener;
    static /* synthetic */ Class class$com$sun$java$swing$event$ChangeListener;

    public StringSpinner() {
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        this.initMember(defaultComboBoxModel);
    }

    public StringSpinner(Object[] objectArray) {
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(objectArray);
        this.initMember(defaultComboBoxModel);
    }

    public StringSpinner(Vector vector) {
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(vector);
        this.initMember(defaultComboBoxModel);
    }

    private void initMember(ComboBoxModel comboBoxModel) {
        this.setModel(comboBoxModel);
        this.fGUI = new StringSpinnerGUI((JComponent)this);
    }

    private void setModel(ComboBoxModel comboBoxModel) {
        if (this.fDataModel != null) {
            this.fDataModel.removeListDataListener(this.fDataModelListener);
            this.fDataModelListener = null;
        }
        this.fDataModel = comboBoxModel;
        if (this.fDataModel != null) {
            this.fDataModelListener = new ComboBoxModelListener();
            this.fDataModel.addListDataListener(this.fDataModelListener);
        }
    }

    public String[] getStringList() {
        Object[] objectArray = ((DefaultComboBoxModel)this.fDataModel).toArray();
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof String) {
                stringArray[n] = (String)objectArray[n];
            } else {
                System.out.println("class cast exception in getStringList()");
            }
            ++n;
        }
        return stringArray;
    }

    public void setStringList(String[] stringArray) {
        ((DefaultComboBoxModel)this.fDataModel).setArray(stringArray);
    }

    SpinnerGUI getGUI() {
        return this.fGUI;
    }

    public int getSelectedIndex() {
        Object object = this.fDataModel.getSelectedItem();
        int n = 0;
        int n2 = this.fDataModel.getSize();
        while (n < n2) {
            Object object2 = this.fDataModel.getElementAt(n);
            if (object2.equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void setSelectedIndex(int n) {
        int n2 = this.fDataModel.getSize();
        if (n < 0) {
            n = n2 - 1;
        }
        if (n >= n2) {
            n = 0;
        }
        this.setValue((String)this.fDataModel.getElementAt(n));
    }

    public void scrollUp() {
        int n = this.getSelectedIndex();
        this.setSelectedIndex(++n);
    }

    public void scrollDown() {
        int n = this.getSelectedIndex();
        this.setSelectedIndex(--n);
    }

    public String getValue() {
        return (String)this.fDataModel.getSelectedItem();
    }

    public void setValue(String string) {
        String string2 = this.getValue();
        this.fDataModel.setSelectedItem((Object)string);
        this.firePropertyChange("value", string2, string);
    }

    private void checkDefaultComboBoxModel() {
        if (!(this.fDataModel instanceof DefaultComboBoxModel)) {
            throw new InternalError("Cannot use this method with a custom data model.");
        }
    }

    public void addItem(String string) {
        this.checkDefaultComboBoxModel();
        ((DefaultComboBoxModel)this.fDataModel).addObject(string);
    }

    public void removeItem(String string) {
        this.checkDefaultComboBoxModel();
        int n = ((DefaultComboBoxModel)this.fDataModel).getIndexOf(string);
        ((DefaultComboBoxModel)this.fDataModel).removeObject(string);
        this.setSelectedIndex(n);
    }

    public void addChangeListener(ChangeListener changeListener) {
        ((JComponent)this).listenerList.add(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = StringSpinner.class$("com.sun.java.swing.event.ChangeListener")), (EventListener)changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        ((JComponent)this).listenerList.remove(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = StringSpinner.class$("com.sun.java.swing.event.ChangeListener")), (EventListener)changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = ((JComponent)this).listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : StringSpinner.class$("com.sun.java.swing.event.ChangeListener"))) {
                ((ChangeListener)objectArray[n + 1]).stateChanged(new ChangeEvent((Object)this));
            }
            n -= 2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.read_init();
    }

    private void read_init() {
        this.fDataModelListener = new ComboBoxModelListener();
        this.fDataModel.addListDataListener(this.fDataModelListener);
        this.fGUI = new StringSpinnerGUI((JComponent)this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ComboBoxModelListener
    implements ListDataListener,
    Serializable {
        public void intervalAdded(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            StringSpinner.this.fireStateChanged();
        }

        ComboBoxModelListener() {
            StringSpinner.this = StringSpinner.this;
        }
    }
}

