/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.spinner;

import com.ibm.webrunner.spinner.BasicArrowButton;
import com.ibm.webrunner.spinner.Spinner;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.SwingConstants;
import com.sun.java.swing.Timer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;

class SpinnerGUI
implements SwingConstants,
Serializable {
    private static final String COPYRIGHT = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 2.0\n(C) Copyright IBM Corp. 1998 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Spinner spinner;
    protected JTextField textField;
    protected int caretPos;
    protected JButton incrButton;
    protected JButton decrButton;
    private JPanel p = new JPanel();
    protected transient Timer spinTimer;
    protected transient ArrowButtonListener buttonListener;
    protected transient SpinListener spinListener;

    public SpinnerGUI(JComponent jComponent) {
        this.spinner = (Spinner)jComponent;
        this.initializeGUI();
    }

    protected void initializeGUI() {
        this.incrButton = new BasicArrowButton(1);
        this.decrButton = new BasicArrowButton(5);
        this.textField = new JTextField(this.spinner.getColumns());
        ((Container)((Object)this.spinner)).setLayout(new BorderLayout());
        this.addSubComponents();
        this.buttonListener = new ArrowButtonListener();
        if (this.incrButton != null) {
            this.incrButton.addMouseListener(this.buttonListener);
        }
        if (this.decrButton != null) {
            this.decrButton.addMouseListener(this.buttonListener);
        }
        this.spinListener = this.createSpinListener();
        this.spinTimer = new Timer(100, (ActionListener)this.spinListener);
        this.spinTimer.setInitialDelay(100);
    }

    protected SpinListener createSpinListener() {
        return new SpinListener();
    }

    public void setColumns(int n) {
        this.textField.setColumns(n);
    }

    public int getColumns() {
        return this.textField.getColumns();
    }

    public void addButtons() {
        if (this.spinner.getOrientation() == 0) {
            this.p.setLayout(new GridLayout(2, 1, 0, 0));
        } else {
            this.p.setLayout(new GridLayout(1, 2, 0, 0));
        }
        this.p.add((Component)this.incrButton);
        this.p.add((Component)this.decrButton);
        ((Container)((Object)this.spinner)).add((Component)this.p, "East");
    }

    public void removeButtons() {
        ((Container)((Object)this.spinner)).remove((Component)this.incrButton);
        ((Container)((Object)this.spinner)).remove((Component)this.decrButton);
    }

    public void addTextField() {
        ((Container)((Object)this.spinner)).add((Component)this.textField, "Center");
    }

    protected void addSubComponents() {
        this.addTextField();
        this.addButtons();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = this.getMinimumSize(jComponent);
        dimension.width += 4;
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Insets insets = this.spinner.getInsets();
        Dimension dimension = this.textField.getPreferredSize();
        int n = dimension.height;
        dimension.height += insets.top + insets.bottom;
        dimension.width = this.spinner.getOrientation() == 0 ? (dimension.width += n + insets.left + insets.right) : (dimension.width += 2 * n + insets.left + insets.right);
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        dimension.width = Short.MAX_VALUE;
        return dimension;
    }

    private class ArrowButtonListener
    extends MouseAdapter
    implements Serializable {
        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getSource() == SpinnerGUI.this.incrButton ? 1 : -1;
            SpinnerGUI.this.spinListener.setDirection(n);
            SpinnerGUI.this.spinTimer.start();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            SpinnerGUI.this.spinTimer.stop();
        }

        ArrowButtonListener() {
            SpinnerGUI.this = SpinnerGUI.this;
        }
    }

    private class SpinListener
    implements ActionListener,
    Serializable {
        int fDirection = 1;

        public SpinListener() {
            SpinnerGUI.this = SpinnerGUI.this;
        }

        public void setDirection(int n) {
            this.fDirection = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SpinnerGUI.this.caretPos = SpinnerGUI.this.textField.getCaretPosition();
            if (this.fDirection > 0) {
                SpinnerGUI.this.spinner.scrollUp();
                return;
            }
            SpinnerGUI.this.spinner.scrollDown();
        }
    }
}

