/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.spinner;

import com.ibm.webrunner.spinner.SpinnerGUI;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JPanel;
import java.awt.Dimension;
import java.io.Serializable;

public abstract class Spinner
extends JPanel
implements Serializable {
    private static final String COPYRIGHT = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 2.0\n(C) Copyright IBM Corp. 1998 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int SPIN_VERTICAL = 0;
    public static final int SPIN_HORIZONTAL = 1;
    private int fOrientation = 0;
    private static final int DEFAULT_COL = 15;
    private int fcolNum = 15;

    abstract SpinnerGUI getGUI();

    public abstract void scrollUp();

    public abstract void scrollDown();

    public int getOrientation() {
        return this.fOrientation;
    }

    public void setOrientation(int n) {
        this.checkOrientation(n);
        int n2 = this.fOrientation;
        this.fOrientation = n;
        this.firePropertyChange("orientation", n2, this.fOrientation);
    }

    private void checkOrientation(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("orientation must be one of: SPIN_VERTICAL, SPIN_HORIZONTAL");
            }
            case 0: 
            case 1: 
        }
    }

    public Dimension getMinimumSize() {
        return this.getGUI().getMinimumSize((JComponent)this);
    }

    public Dimension getMaximumSize() {
        return this.getGUI().getMaximumSize((JComponent)this);
    }

    public Dimension getPreferredSize() {
        return this.getGUI().getPreferredSize((JComponent)this);
    }

    public void setColumns(int n) {
        this.fcolNum = n;
        this.getGUI().setColumns(n);
    }

    public int getColumns() {
        return this.fcolNum;
    }
}

