/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.spinner;

import com.ibm.webrunner.spinner.NumericSpinnerGUI;
import com.ibm.webrunner.spinner.Spinner;
import com.ibm.webrunner.spinner.SpinnerGUI;
import com.sun.java.swing.BoundedRangeModel;
import com.sun.java.swing.DefaultBoundedRangeModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.EventListener;

public class NumericSpinner
extends Spinner
implements Serializable {
    private static final String COPYRIGHT = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 2.0\n(C) Copyright IBM Corp. 1998 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private BoundedRangeModel fDataModel;
    private int fIncrement;
    private transient SpinnerGUI fGUI;
    private transient ChangeListener fDataModelListener;
    static /* synthetic */ Class class$com$sun$java$swing$event$ChangeListener;

    public NumericSpinner() {
        this(1);
    }

    public NumericSpinner(int n) {
        this(0, 0, 100, n);
    }

    public NumericSpinner(int n, int n2) {
        this(0, n, n2, 1);
    }

    public NumericSpinner(int n, int n2, int n3, int n4) {
        this.fIncrement = n4;
        DefaultBoundedRangeModel defaultBoundedRangeModel = new DefaultBoundedRangeModel(n, 0, n2, n3);
        this.setModel((BoundedRangeModel)defaultBoundedRangeModel);
        this.fGUI = new NumericSpinnerGUI((JComponent)this);
    }

    SpinnerGUI getGUI() {
        return this.fGUI;
    }

    public BoundedRangeModel getModel() {
        return this.fDataModel;
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        BoundedRangeModel boundedRangeModel2 = this.fDataModel;
        if (this.fDataModel != null) {
            this.fDataModel.removeChangeListener(this.fDataModelListener);
            this.fDataModel = null;
        }
        this.fDataModel = boundedRangeModel;
        if (this.fDataModel != null) {
            this.fDataModelListener = new ModelListener();
            this.fDataModel.addChangeListener(this.fDataModelListener);
        }
        this.firePropertyChange("model", boundedRangeModel2, this.fDataModel);
    }

    public int getValue() {
        return this.getModel().getValue();
    }

    public void setValue(int n) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        boundedRangeModel.getValue();
        boundedRangeModel.setValue(n);
    }

    public int getMinimum() {
        return this.getModel().getMinimum();
    }

    public void setMinimum(int n) {
        this.getModel().setMinimum(n);
    }

    public int getMaximum() {
        return this.getModel().getMaximum();
    }

    public void setMaximum(int n) {
        this.getModel().setMaximum(n);
    }

    public int getIncrement() {
        return this.fIncrement;
    }

    public void setIncrement(int n) {
        int n2 = this.fIncrement;
        this.fIncrement = n;
        this.firePropertyChange("increment", n2, this.fIncrement);
    }

    public void scrollUp() {
        int n = this.getValue();
        this.setValue(n + this.fIncrement);
    }

    public void scrollDown() {
        int n = this.getValue();
        this.setValue(n - this.fIncrement);
    }

    public void addChangeListener(ChangeListener changeListener) {
        ((JComponent)this).listenerList.add(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = NumericSpinner.class$("com.sun.java.swing.event.ChangeListener")), (EventListener)changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        ((JComponent)this).listenerList.remove(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = NumericSpinner.class$("com.sun.java.swing.event.ChangeListener")), (EventListener)changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = ((JComponent)this).listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : NumericSpinner.class$("com.sun.java.swing.event.ChangeListener"))) {
                ((ChangeListener)objectArray[n + 1]).stateChanged(new ChangeEvent((Object)this));
            }
            n -= 2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.read_init();
    }

    private void read_init() {
        this.fDataModelListener = new ModelListener();
        this.fDataModel.addChangeListener(this.fDataModelListener);
        this.fGUI = new NumericSpinnerGUI((JComponent)this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ModelListener
    implements ChangeListener,
    Serializable {
        public void stateChanged(ChangeEvent changeEvent) {
            NumericSpinner.this.fireStateChanged();
        }

        ModelListener() {
            NumericSpinner.this = NumericSpinner.this;
        }
    }
}

