/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.sdatepicker;

import com.ibm.webrunner.sdatepicker.DateChangedEvent;
import com.ibm.webrunner.sdatepicker.DateChangedListener;
import com.ibm.webrunner.sdatepicker.DateModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;

public class DatePickerModel
implements Serializable,
DateModel {
    private static final String COPYRIGHT = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 2.0\n(C) Copyright IBM Corp. 1998 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private transient Vector dateChangedListeners;
    GregorianCalendar fGC = new GregorianCalendar();
    DateFormat fSDF = DateFormat.getDateInstance();
    boolean dateIsNull = false;
    String dateFormatString = "";
    TimeZone timeZone;
    int pivotValue;
    boolean usingPivotValue = false;
    boolean nullDateAllowed = false;

    public DatePickerModel() {
        this.fSDF.setLenient(false);
        this.dateFormatString = ((SimpleDateFormat)this.fSDF).toPattern();
        TimeZone timeZone = TimeZone.getDefault();
        this.setTimeZone(timeZone);
        this.setPivotValue(18);
        this.setUsingPivotValue(false);
        this.init();
    }

    public void setDateFormatString(String string) {
        String string2 = this.dateFormatString;
        try {
            this.dateFormatString = string;
            this.fSDF = new SimpleDateFormat(string);
            this.fSDF.setTimeZone(this.getTimeZone());
            return;
        }
        catch (Exception exception) {
            this.dateFormatString = string2;
            this.fSDF = new SimpleDateFormat(string2);
            this.fSDF.setTimeZone(this.getTimeZone());
            return;
        }
    }

    public String getDateFormatString() {
        return this.dateFormatString;
    }

    public void setDateByFields(int n, int n2, int n3) {
        this.fGC.set(n, n2, n3);
        this.fGC.clear(10);
        this.fGC.clear(11);
        this.fGC.clear(12);
        this.fGC.clear(13);
        this.fGC.clear(14);
        this.fGC.set(10, 0);
        this.fGC.set(11, 0);
        this.fGC.setTime(this.fGC.getTime());
        this.dateIsNull = false;
        this.fireDateChangedEvent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDateWithOptionalEvent(Date date, boolean bl) {
        if (date == null) {
            if (!this.nullDateAllowed) return;
            this.dateIsNull = true;
        } else {
            this.fGC.setTime(date);
            this.dateIsNull = false;
        }
        if (!bl) return;
        this.fireDateChangedEvent();
    }

    public int getDay() {
        return this.fGC.get(5);
    }

    public int getMonth() {
        return this.fGC.get(2);
    }

    public int getYear() {
        return this.fGC.get(1);
    }

    public void setDate(Date date) {
        this.setDateWithOptionalEvent(date, true);
    }

    public Date getDate() {
        if (this.dateIsNull) {
            return null;
        }
        return this.fGC.getTime();
    }

    public java.sql.Date getSQLDate() {
        if (this.dateIsNull) {
            return null;
        }
        Date date = this.fGC.getTime();
        return new java.sql.Date(date.getTime());
    }

    protected int countYearDigits(String string) {
        int n = 0;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        boolean bl = false;
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '\'') {
                bl = !bl;
            } else if (!(c != 'y' && c != 'Y' || bl)) {
                ++n;
            }
            c = stringCharacterIterator.next();
        }
        return n;
    }

    protected int adjustYearUsingPivotValue(int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
        int n2 = gregorianCalendar.get(1);
        int n3 = n2 / 100 * 100;
        int n4 = 0;
        int n5 = 0;
        int n6 = n2 % 100 < 50 ? n3 : n3 + 100;
        int n7 = n6 - n2;
        n4 = n % 100;
        n5 = this.getPivotValue();
        if (Math.abs(n7) <= n5) {
            if (n7 > 0) {
                n4 = n4 <= n5 ? n4 + n3 + 100 : (n4 += n3);
            } else if (n7 <= 0) {
                n4 = n4 < 100 - n5 ? (n4 += n3) : n4 + n3 - 100;
            }
        } else {
            n4 += n3;
        }
        return n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDateString(String string) {
        Date date = null;
        boolean bl = true;
        if (string == "" || string.length() == 0) {
            if (!this.nullDateAllowed) return;
            this.dateIsNull = true;
        } else {
            try {
                date = this.fSDF.parse(string);
                this.fGC.setTime(date);
                String string2 = this.getDateFormatString();
                int n = this.countYearDigits(string2);
                if (n > 0 && n <= 2 && this.isUsingPivotValue()) {
                    int n2 = this.fGC.get(1);
                    int n3 = this.fGC.get(2);
                    int n4 = this.fGC.get(5);
                    int n5 = this.adjustYearUsingPivotValue(n2);
                    this.fGC.set(n5, n3, n4);
                    this.fGC.setTime(this.fGC.getTime());
                }
                this.dateIsNull = false;
            }
            catch (Exception exception) {
                return;
            }
        }
        if (!bl) return;
        this.fireDateChangedEvent();
    }

    public String getDateString() {
        if (this.dateIsNull) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        this.fSDF.format(this.fGC.getTime(), stringBuffer, fieldPosition);
        return stringBuffer.toString();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        ((Calendar)this.fGC).setTimeZone(timeZone);
        this.fGC.setTime(this.fGC.getTime());
        this.fSDF.setTimeZone(timeZone);
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setPivotValue(int n) {
        if (n >= 0 & n < 100) {
            this.pivotValue = n;
        }
    }

    public int getPivotValue() {
        return this.pivotValue;
    }

    public void setUsingPivotValue(boolean bl) {
        this.usingPivotValue = bl;
    }

    public boolean isUsingPivotValue() {
        return this.usingPivotValue;
    }

    public boolean isNullDateAllowed() {
        return this.nullDateAllowed;
    }

    public void setNullDateAllowed(boolean bl) {
        this.nullDateAllowed = bl;
        if (!bl && this.dateIsNull) {
            Date date = new Date();
            this.setDateWithOptionalEvent(date, false);
            this.dateIsNull = false;
        }
    }

    public synchronized void addDateChangedListener(DateChangedListener dateChangedListener) {
        this.dateChangedListeners.addElement(dateChangedListener);
    }

    public synchronized void removeDateChangedListener(DateChangedListener dateChangedListener) {
        this.dateChangedListeners.removeElement(dateChangedListener);
    }

    protected void fireDateChangedEvent() {
        Object object;
        Serializable serializable;
        String string;
        if (this.dateIsNull) {
            string = "";
        } else {
            serializable = new StringBuffer();
            object = new FieldPosition(0);
            this.fSDF.format(this.fGC.getTime(), (StringBuffer)serializable, (FieldPosition)object);
            string = ((StringBuffer)serializable).toString();
        }
        serializable = new DateChangedEvent(this, 20000, string, this.getDate(), this.getSQLDate());
        DatePickerModel datePickerModel = this;
        synchronized (datePickerModel) {
            object = (Vector)this.dateChangedListeners.clone();
        }
        int n = 0;
        while (n < ((Vector)object).size()) {
            ((DateChangedListener)((Vector)object).elementAt(n)).dateChanged((DateChangedEvent)serializable);
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("date=" + this.getDateString());
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    private void init() {
        this.dateChangedListeners = new Vector();
    }
}

