/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.sdatepicker;

import com.ibm.webrunner.sdatepicker.CalendarChooser;
import com.ibm.webrunner.sdatepicker.DateChangedEvent;
import com.ibm.webrunner.sdatepicker.DateChangedListener;
import com.ibm.webrunner.sdatepicker.DateModel;
import com.ibm.webrunner.sdatepicker.DatePickerModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.JWindow;
import com.sun.java.swing.UIManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Date;
import java.util.TimeZone;
import java.util.Vector;

public class DatePicker
extends JPanel
implements Serializable {
    private static final String COPYRIGHT = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 2.0\n(C) Copyright IBM Corp. 1998 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String VERSION = "Swing 1.00";
    static final long kLostThreshold = 300L;
    private static final int DROP_DOWN_HEIGHT = 25;
    private static final int DROP_DOWN_WIDTH = 15;
    private static int fNumber;
    DateModel model;
    transient JTextField dateEntryField;
    transient JButton dropDownButton;
    transient CalendarChooser calendar;
    transient JWindow win;
    transient Icon calIcon;
    private transient Vector dateChangedListeners = new Vector();
    private transient EventHandler fEventHandler;
    String fDateFormatString = "";
    boolean enabled = true;
    int pivotValue;
    boolean usingPivotValue = false;
    TimeZone timeZone;
    boolean nullDateAllowed = false;
    boolean dropDownButtonVisible = true;
    long lostTime;
    boolean ignoreNextArrowClick = false;

    public DatePicker() {
        this(TimeZone.getDefault(), new DatePickerModel());
    }

    public DatePicker(TimeZone timeZone) {
        this(timeZone, new DatePickerModel());
    }

    private DatePicker(TimeZone timeZone, DateModel dateModel) {
        int n = ++fNumber;
        ((Component)((Object)this)).setName("DatePicker" + n);
        this.timeZone = timeZone;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.model = dateModel;
        this.fDateFormatString = dateModel.getDateFormatString();
        this.setPivotValue(18);
        this.init();
    }

    private void init() {
        this.fEventHandler = new EventHandler();
        this.setModel(this.model);
        this.dateEntryField = new JTextField();
        this.dateEntryField.setHorizontalAlignment(0);
        ((Container)((Object)this)).add("Center", (Component)this.dateEntryField);
        this.dateEntryField.setText(this.model.getDateString());
        this.dateEntryField.addKeyListener(this.fEventHandler);
        Image image = this.createCalIconImage();
        this.calIcon = new ImageIcon(image);
        this.dropDownButton = new JButton(this.calIcon);
        this.dropDownButton.setBackground(UIManager.getColor((Object)"control"));
        Insets insets = new Insets(1, 1, 1, 1);
        this.dropDownButton.setMargin(insets);
        this.dropDownButton.setSize(new Dimension(15, 25));
        ((Container)((Object)this)).add("East", (Component)this.dropDownButton);
        this.dropDownButton.addActionListener((ActionListener)this.fEventHandler);
        this.calendar = new CalendarChooser();
        this.calendar.setTimeZone(this.timeZone);
        this.calendar.setModel(this.getModel());
        this.calendar.setDateFormatString(this.fDateFormatString);
        ((Component)((Object)this)).setSize(this.getPreferredSize());
        this.win = null;
    }

    public String getVersion() {
        return VERSION;
    }

    public void setVersion(String string) {
    }

    public Dimension getPreferredSize() {
        int n = this.dropDownButton.getHeight();
        int n2 = 0;
        if (this.isDropDownButtonVisible()) {
            n2 = this.dropDownButton.getWidth();
        }
        int n3 = 190 + n2;
        try {
            FontMetrics fontMetrics = this.dateEntryField.getFontMetrics(this.dateEntryField.getFont());
            if (fontMetrics != null) {
                int n4 = fontMetrics.stringWidth(this.getDateString());
                int n5 = fontMetrics.stringWidth(this.getDateFormatString());
                n3 = 20 + n2 + Math.max(n4, n5);
            }
        }
        catch (Exception exception) {}
        return new Dimension(n3, n);
    }

    public Dimension getMinimumSize() {
        int n = this.dropDownButton.getHeight();
        int n2 = 20 + this.dropDownButton.getWidth();
        return new Dimension(n2, n);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (this.isDropDownButtonVisible()) {
            int n5 = this.dropDownButton.getWidth();
            this.dateEntryField.setBounds(0, 0, n3 - n5, n4);
            this.dropDownButton.setBounds(n3 - n5, 0, n5, n4);
            return;
        }
        this.dateEntryField.setBounds(0, 0, n3, n4);
    }

    private DateModel createDefaultModel() {
        return new DatePickerModel();
    }

    private DateModel getModel() {
        return this.model;
    }

    private void setModel(DateModel dateModel) {
        DateModel dateModel2 = this.getModel();
        if (dateModel2 != null) {
            dateModel2.removeDateChangedListener(this.fEventHandler);
        }
        this.model = dateModel;
        if (dateModel != null) {
            dateModel.addDateChangedListener(this.fEventHandler);
            dateModel.setTimeZone(this.timeZone);
            dateModel.setDateFormatString(this.fDateFormatString);
            dateModel.setPivotValue(this.pivotValue);
            dateModel.setUsingPivotValue(this.usingPivotValue);
            dateModel.setNullDateAllowed(this.nullDateAllowed);
        }
    }

    public void setDateFormatString(String string) {
        if (this.model == null) {
            this.setModel(this.createDefaultModel());
        }
        this.model.setDateFormatString(string);
        this.fDateFormatString = this.model.getDateFormatString();
        this.calendar.setDateFormatString(this.fDateFormatString);
        this.dateEntryField.setText(this.model.getDateString());
        this.dateEntryField.invalidate();
        this.dropDownButton.invalidate();
        ((Container)((Object)this)).invalidate();
        ((Component)((Object)this)).repaint();
    }

    public String getDateFormatString() {
        return this.fDateFormatString;
    }

    public void setTimeZone(String string) {
        if (this.timeZone.getID() != string) {
            TimeZone timeZone = TimeZone.getTimeZone(string);
            if (timeZone.getID() == "GMT") {
                if (string == "GMT") {
                    this.timeZone = timeZone;
                }
            } else {
                this.timeZone = timeZone;
            }
            if (this.model == null) {
                this.setModel(this.createDefaultModel());
            }
            this.model.setTimeZone(this.timeZone);
            this.calendar.setTimeZone(this.timeZone);
            this.dateEntryField.setText(this.model.getDateString());
        }
    }

    public String getTimeZone() {
        return this.timeZone.getID();
    }

    public void setPivotValue(int n) {
        if (this.model == null) {
            this.setModel(this.createDefaultModel());
        }
        this.model.setPivotValue(n);
        this.pivotValue = this.model.getPivotValue();
    }

    public int getPivotValue() {
        return this.pivotValue;
    }

    public void setUsingPivotValue(boolean bl) {
        this.usingPivotValue = bl;
        if (this.model == null) {
            this.setModel(this.createDefaultModel());
        }
        this.model.setUsingPivotValue(bl);
    }

    public boolean isUsingPivotValue() {
        return this.usingPivotValue;
    }

    public synchronized void setEnabled(boolean bl) {
        if (this.win != null) {
            this.win.setVisible(false);
        }
        this.enabled = bl;
        this.dateEntryField.setEnabled(this.enabled);
        this.dropDownButton.setEnabled(this.enabled);
        super.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isNullDateAllowed() {
        return this.nullDateAllowed;
    }

    public void setNullDateAllowed(boolean bl) {
        this.nullDateAllowed = bl;
        if (this.model == null) {
            this.setModel(this.createDefaultModel());
        }
        this.model.setNullDateAllowed(bl);
    }

    public boolean isDropDownButtonVisible() {
        return this.dropDownButtonVisible;
    }

    public void setDropDownButtonVisible(boolean bl) {
        this.dropDownButtonVisible = bl;
        this.dropDownButton.setVisible(bl);
        this.dateEntryField.invalidate();
        this.dropDownButton.invalidate();
        ((Container)((Object)this)).invalidate();
        ((Component)((Object)this)).repaint();
    }

    public void setDateByFields(int n, int n2, int n3) {
        if (this.model == null) {
            this.setModel(this.createDefaultModel());
        }
        this.model.setDateByFields(n, n2, n3);
    }

    public void setDateWithOptionalEvent(java.util.Date date, boolean bl) {
        if (this.model == null) {
            this.setModel(this.createDefaultModel());
        }
        this.model.setDateWithOptionalEvent(date, bl);
    }

    public void setDate(java.util.Date date) {
        if (this.model == null) {
            this.setModel(this.createDefaultModel());
        }
        this.model.setDateWithOptionalEvent(date, true);
    }

    public java.util.Date getDate() {
        if (this.model == null) {
            this.setModel(this.createDefaultModel());
        }
        return this.model.getDate();
    }

    public Date getSQLDate() {
        if (this.model == null) {
            this.setModel(this.createDefaultModel());
        }
        if (this.model instanceof DatePickerModel) {
            return this.model.getSQLDate();
        }
        java.util.Date date = this.model.getDate();
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    public void setObject(Object object) {
        try {
            this.setDate((Date)object);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public Object getObject() {
        if (this.model == null) {
            this.setModel(this.createDefaultModel());
        }
        return this.model.getSQLDate();
    }

    public void setDateString(String string) {
        if (this.model == null) {
            this.setModel(this.createDefaultModel());
        }
        this.model.setDateString(string);
        this.dateEntryField.setText(this.model.getDateString());
    }

    public String getDateString() {
        if (this.model == null) {
            this.setModel(this.createDefaultModel());
        }
        return this.model.getDateString();
    }

    public synchronized void addDateChangedListener(DateChangedListener dateChangedListener) {
        this.dateChangedListeners.addElement(dateChangedListener);
    }

    public synchronized void removeDateChangedListener(DateChangedListener dateChangedListener) {
        this.dateChangedListeners.removeElement(dateChangedListener);
    }

    protected void fireDateChangedEvent() {
        Vector vector;
        if (this.model == null) {
            this.setModel(this.createDefaultModel());
        }
        String string = this.model.getDateString();
        DateChangedEvent dateChangedEvent = new DateChangedEvent(this, 20000, string, this.getDate(), this.getSQLDate());
        DatePicker datePicker = this;
        synchronized (datePicker) {
            vector = (Vector)this.dateChangedListeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            ((DateChangedListener)vector.elementAt(n)).dateChanged(dateChangedEvent);
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    private Image createCalIconImage() {
        byte[] byArray = new byte[123];
        byArray[0] = 71;
        byArray[1] = 73;
        byArray[2] = 70;
        byArray[3] = 56;
        byArray[4] = 57;
        byArray[5] = 97;
        byArray[6] = 16;
        byArray[8] = 15;
        byArray[10] = -94;
        byArray[11] = -1;
        byArray[15] = -128;
        byArray[19] = -1;
        byArray[20] = -5;
        byArray[21] = -16;
        byArray[22] = -128;
        byArray[23] = -128;
        byArray[24] = -128;
        byArray[27] = -1;
        byArray[28] = -64;
        byArray[29] = -64;
        byArray[30] = -64;
        byArray[31] = -1;
        byArray[32] = -1;
        byArray[33] = -1;
        byArray[37] = 33;
        byArray[38] = -7;
        byArray[39] = 4;
        byArray[40] = 1;
        byArray[43] = 5;
        byArray[45] = 44;
        byArray[50] = 16;
        byArray[52] = 15;
        byArray[55] = 3;
        byArray[56] = 64;
        byArray[57] = 72;
        byArray[58] = -70;
        byArray[59] = -84;
        byArray[60] = 81;
        byArray[61] = -112;
        byArray[62] = -128;
        byArray[63] = 73;
        byArray[64] = 43;
        byArray[65] = 120;
        byArray[66] = 112;
        byArray[67] = -104;
        byArray[68] = -67;
        byArray[69] = 7;
        byArray[70] = 48;
        byArray[71] = -98;
        byArray[72] = -127;
        byArray[73] = 21;
        byArray[74] = 26;
        byArray[75] = 7;
        byArray[76] = 26;
        byArray[77] = -126;
        byArray[78] = 38;
        byArray[79] = -116;
        byArray[80] = 67;
        byArray[81] = -21;
        byArray[82] = -66;
        byArray[83] = 45;
        byArray[84] = -5;
        byArray[85] = -123;
        byArray[86] = -12;
        byArray[87] = -57;
        byArray[88] = -94;
        byArray[89] = 106;
        byArray[90] = -114;
        byArray[91] = -78;
        byArray[92] = 112;
        byArray[93] = 47;
        byArray[94] = -125;
        byArray[95] = -77;
        byArray[96] = -96;
        byArray[97] = 8;
        byArray[98] = 66;
        byArray[99] = -62;
        byArray[100] = 25;
        byArray[101] = 83;
        byArray[102] = 59;
        byArray[103] = 98;
        byArray[104] = 96;
        byArray[105] = -55;
        byArray[106] = 108;
        byArray[107] = 50;
        byArray[108] = -119;
        byArray[109] = -48;
        byArray[110] = -88;
        byArray[111] = 116;
        byArray[112] = 26;
        byArray[113] = 117;
        byArray[114] = 82;
        byArray[115] = -95;
        byArray[116] = -49;
        byArray[117] = 43;
        byArray[118] = 22;
        byArray[119] = -110;
        byArray[122] = 59;
        byte[] byArray2 = byArray;
        return Toolkit.getDefaultToolkit().createImage(byArray2);
    }

    class EventHandler
    implements DateChangedListener,
    ActionListener,
    FocusListener,
    KeyListener {
        public void dateChanged(DateChangedEvent dateChangedEvent) {
            Object object = dateChangedEvent.getSource();
            if (object == DatePicker.this.model) {
                DatePicker.this.dateEntryField.setText(DatePicker.this.model.getDateString());
                if (DatePicker.this.win != null) {
                    DatePicker.this.win.setVisible(false);
                }
                DatePicker.this.fireDateChangedEvent();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (object == DatePicker.this.win) {
                java.util.Date date = new java.util.Date();
                DatePicker.this.lostTime = date.getTime();
                DatePicker.this.ignoreNextArrowClick = true;
                if (DatePicker.this.win != null) {
                    DatePicker.this.win.setVisible(false);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DatePicker.this.ignoreNextArrowClick) {
                java.util.Date date = new java.util.Date();
                if (date.getTime() - DatePicker.this.lostTime < 300L) {
                    DatePicker.this.ignoreNextArrowClick = false;
                    return;
                }
                DatePicker.this.ignoreNextArrowClick = false;
            }
            if (DatePicker.this.win != null) {
                if (DatePicker.this.win.isVisible()) {
                    DatePicker.this.win.setVisible(false);
                    return;
                }
                DatePicker.this.win.setVisible(true);
            }
            boolean bl = false;
            Frame frame = null;
            Container container = ((Component)((Object)DatePicker.this)).getParent();
            while (!bl) {
                block8: {
                    try {
                        frame = (Frame)container;
                        bl = true;
                    }
                    catch (Exception exception) {
                        if (container != null) break block8;
                        return;
                    }
                }
                container = container.getParent();
            }
            if (DatePicker.this.win == null) {
                DatePicker.this.win = new JWindow(frame);
                DatePicker.this.win.addKeyListener(this);
                DatePicker.this.win.addFocusListener(this);
            }
            DatePicker.this.win.setSize(DatePicker.this.calendar.getPreferredSize());
            DatePicker.this.win.setLocation(new Point(DatePicker.this.dropDownButton.getLocationOnScreen().x - DatePicker.this.win.getSize().width + DatePicker.this.dropDownButton.getSize().width, DatePicker.this.dropDownButton.getLocationOnScreen().y + DatePicker.this.dropDownButton.getSize().height));
            DatePicker.this.win.getContentPane().add((Component)((Object)DatePicker.this.calendar), "Center");
            DatePicker.this.win.pack();
            DatePicker.this.calendar.paint(DatePicker.this.calendar.getGraphics());
            DatePicker.this.win.setVisible(true);
            DatePicker.this.win.toFront();
        }

        public void keyPressed(KeyEvent keyEvent) {
            Object object = keyEvent.getSource();
            int n = keyEvent.getKeyCode();
            if (object == DatePicker.this.dateEntryField && (n == 10 || n == 9)) {
                if (DatePicker.this.model == null) {
                    DatePicker.this.setModel(DatePicker.this.createDefaultModel());
                }
                DatePicker.this.model.setDateString(DatePicker.this.dateEntryField.getText());
                DatePicker.this.dateEntryField.setText(DatePicker.this.model.getDateString());
            }
            if (n == 27) {
                if (DatePicker.this.model == null) {
                    DatePicker.this.setModel(DatePicker.this.createDefaultModel());
                }
                DatePicker.this.dateEntryField.setText(DatePicker.this.model.getDateString());
                if (DatePicker.this.win != null) {
                    DatePicker.this.win.setVisible(false);
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        EventHandler() {
            DatePicker.this = DatePicker.this;
        }
    }
}

