/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.sdatepicker;

import com.ibm.webrunner.sdatepicker.DateChangedEvent;
import com.ibm.webrunner.sdatepicker.DateChangedListener;
import com.ibm.webrunner.sdatepicker.DateModel;
import com.ibm.webrunner.sdatepicker.DatePickerModel;
import com.ibm.webrunner.spinner.NumericSpinner;
import com.ibm.webrunner.spinner.StringSpinner;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.BevelBorder;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;

public class CalendarChooser
extends JPanel
implements ItemListener,
ChangeListener,
MouseListener,
DateChangedListener {
    private static final String COPYRIGHT = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 2.0\n(C) Copyright IBM Corp. 1998 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    DateModel model;
    transient StringSpinner monSpinner;
    transient NumericSpinner yearSpinner;
    transient String sat = "";
    transient String sun = "";
    transient String mon = "";
    transient String tue = "";
    transient String wed = "";
    transient String thu = "";
    transient String fri = "";
    BevelBorder border;
    String dateFormatString;
    static ResourceBundle res = null;
    int[][] valid = new int[6][7];
    GregorianCalendar gc = new GregorianCalendar();
    GregorianCalendar today = new GregorianCalendar();
    TimeZone tz;
    Font fb = new Font("Dialog", 1, 12);
    Font fn = new Font("Dialog", 0, 11);
    Font fnb = new Font("Dialog", 1, 11);
    int xWidth = 30;
    int halfXWidth = 15;
    int todayYear;
    int todayMonth;
    int todayDay;
    boolean modelDateIsNull = false;

    public CalendarChooser() {
        this.border = new BevelBorder(0);
        this.setBorder((Border)this.border);
        ((Component)((Object)this)).setSize(this.getPreferredSize());
        ((Container)((Object)this)).setLayout(null);
        this.createModel();
        ((Component)((Object)this)).setSize(this.getPreferredSize());
        ((Container)((Object)this)).setLayout(null);
        this.initialize();
        int n = 0;
        while (n < 6) {
            int n2 = 0;
            while (n2 < 7) {
                this.valid[n][n2] = 0;
                ++n2;
            }
            ++n;
        }
        TimeZone timeZone = TimeZone.getDefault();
        this.setTimeZone(timeZone);
        ((Component)((Object)this)).addMouseListener(this);
    }

    private void initialize() {
        CalendarChooser.loadResources();
        Insets insets = this.border.getBorderInsets((Component)((Object)this));
        ((Component)((Object)this)).getSize();
        this.sun = res.getString("Sun");
        this.mon = res.getString("Mon");
        this.tue = res.getString("Tue");
        this.wed = res.getString("Wed");
        this.thu = res.getString("Thu");
        this.fri = res.getString("Fri");
        this.sat = res.getString("Sat");
        Vector<String> vector = new Vector<String>();
        vector.addElement(res.getString("January"));
        vector.addElement(res.getString("February"));
        vector.addElement(res.getString("March"));
        vector.addElement(res.getString("April"));
        vector.addElement(res.getString("May"));
        vector.addElement(res.getString("June"));
        vector.addElement(res.getString("July"));
        vector.addElement(res.getString("August"));
        vector.addElement(res.getString("September"));
        vector.addElement(res.getString("October"));
        vector.addElement(res.getString("November"));
        vector.addElement(res.getString("December"));
        this.monSpinner = new StringSpinner(vector);
        int n = this.gc.get(2);
        this.monSpinner.setSelectedIndex(n);
        this.monSpinner.addChangeListener(this);
        int n2 = this.gc.get(1);
        int n3 = this.gc.getMaximum(1);
        int n4 = this.gc.getMinimum(1);
        this.yearSpinner = new NumericSpinner(n2, n4, n3, 1);
        this.yearSpinner.addChangeListener(this);
        ((Container)((Object)this)).add((Component)((Object)this.monSpinner));
        ((Container)((Object)this)).add((Component)((Object)this.yearSpinner));
        ((Component)((Object)this.monSpinner)).setBounds(30 + insets.left, 5 + insets.top, 100, 16);
        ((Component)((Object)this.yearSpinner)).setBounds(140 + insets.left, 5 + insets.top, 50, 16);
    }

    private static void loadResources() {
        CalendarChooser.loadResources(Locale.getDefault());
    }

    private static void loadResources(Locale locale) {
        try {
            res = ResourceBundle.getBundle("com.ibm.webrunner.sdatepicker.CalendarChooserResources");
            return;
        }
        catch (MissingResourceException missingResourceException) {
            return;
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        this.tz = timeZone;
        ((Calendar)this.gc).setTimeZone(timeZone);
        this.gc.setTime(this.gc.getTime());
        ((Calendar)this.today).setTimeZone(timeZone);
        this.today.setTime(this.today.getTime());
        this.todayYear = this.today.get(1);
        this.todayMonth = this.today.get(2);
        this.todayDay = this.today.get(5);
    }

    public TimeZone getTimeZone() {
        return this.tz;
    }

    protected void createModel() {
        if (this.model == null) {
            DatePickerModel datePickerModel = new DatePickerModel();
            this.setModel(datePickerModel);
        }
    }

    public DateModel getModel() {
        return this.model;
    }

    public void setModel(DateModel dateModel) {
        DateModel dateModel2 = this.getModel();
        if (dateModel2 != null) {
            dateModel2.removeDateChangedListener(this);
        }
        this.model = dateModel;
        if (dateModel != null) {
            dateModel.addDateChangedListener(this);
            Date date = dateModel.getDate();
            if (date == null) {
                this.modelDateIsNull = true;
                return;
            }
            this.modelDateIsNull = false;
        }
    }

    public String getDateString() {
        return this.model.getDateString();
    }

    public void setDateFormatString(String string) {
        this.model.setDateFormatString(string);
        ((Container)((Object)this)).invalidate();
    }

    public String getDateFormatString() {
        return this.model.getDateFormatString();
    }

    public void paintComponent(Graphics graphics) {
        boolean bl = false;
        Color color = UIManager.getColor((Object)"control");
        Color color2 = color.brighter().brighter();
        Color color3 = color.darker().darker();
        if (graphics == null) {
            graphics = this.getGraphics();
        }
        graphics.setColor(color);
        Insets insets = this.border.getBorderInsets((Component)((Object)this));
        graphics.fillRect(insets.left, insets.top, ((Component)((Object)this)).getSize().width - (insets.left + insets.right), ((Component)((Object)this)).getSize().height - (insets.top + insets.bottom));
        int n = this.gc.get(2);
        int n2 = this.gc.get(1);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
        gregorianCalendar.set(n2, n, 1);
        gregorianCalendar.setTime(gregorianCalendar.getTime());
        int n3 = ((Component)((Object)this)).getSize().width;
        DateModel dateModel = this.getModel();
        int n4 = dateModel.getDay();
        int n5 = dateModel.getMonth();
        int n6 = dateModel.getYear();
        String string = "";
        int n7 = 34 + insets.top;
        int n8 = 5 + insets.left;
        graphics.setFont(this.fn);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n9 = fontMetrics.stringWidth(this.sun);
        int n10 = fontMetrics.stringWidth(this.mon);
        int n11 = fontMetrics.stringWidth(this.tue);
        int n12 = fontMetrics.stringWidth(this.wed);
        int n13 = fontMetrics.stringWidth(this.thu);
        int n14 = fontMetrics.stringWidth(this.fri);
        int n15 = fontMetrics.stringWidth(this.sat);
        graphics.setColor(Color.black);
        graphics.drawString(this.sun, n8 + this.halfXWidth - n9 / 2, n7);
        graphics.drawString(this.mon, (n8 += this.xWidth) + this.halfXWidth - n10 / 2, n7);
        graphics.drawString(this.tue, (n8 += this.xWidth) + this.halfXWidth - n11 / 2, n7);
        graphics.drawString(this.wed, (n8 += this.xWidth) + this.halfXWidth - n12 / 2, n7);
        graphics.drawString(this.thu, (n8 += this.xWidth) + this.halfXWidth - n13 / 2, n7);
        graphics.drawString(this.fri, (n8 += this.xWidth) + this.halfXWidth - n14 / 2, n7);
        graphics.drawString(this.sat, (n8 += this.xWidth) + this.halfXWidth - n15 / 2, n7);
        graphics.setColor(color3);
        graphics.drawRect(5 + insets.left, 38 + insets.top, n8 + this.xWidth - 5, 0);
        graphics.setColor(color2);
        graphics.drawRect(5 + insets.left, 38 + insets.top + 2, n8 + this.xWidth - 5, 0);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(this.getTimeZone());
        gregorianCalendar2.set(n2, n, 1);
        gregorianCalendar2.setTime(gregorianCalendar2.getTime());
        int n16 = gregorianCalendar2.get(7) - 1;
        gregorianCalendar.set(n2, n, 1);
        int n17 = gregorianCalendar.get(5);
        int n18 = n;
        int n19 = 0;
        boolean bl2 = true;
        graphics.setColor(Color.black);
        graphics.setFont(this.fnb);
        fontMetrics = graphics.getFontMetrics();
        int n20 = fontMetrics.stringWidth("00");
        int n21 = n20 / 2;
        int n22 = fontMetrics.getMaxAscent();
        while (n18 == n) {
            if (n16 == 0 && !bl2) {
                ++n19;
            }
            if (n17 > 31) break;
            bl2 = false;
            this.valid[n19][n16] = n17;
            string = String.valueOf(n17);
            graphics.setColor(Color.black);
            graphics.setFont(this.fn);
            fontMetrics = graphics.getFontMetrics();
            bl = false;
            if (n17 == this.todayDay && n == this.todayMonth && n2 == this.todayYear) {
                graphics.setFont(this.fnb);
            }
            if (n17 == n4 && n == n5 && n2 == n6 && !this.modelDateIsNull) {
                bl = true;
            }
            ++n17;
            n8 = n16 * this.xWidth + 10 + this.halfXWidth - fontMetrics.stringWidth(string) + insets.left;
            n7 = 54 + insets.top + 12 * n19;
            if (bl) {
                if (fontMetrics.stringWidth(string) < n20) {
                    graphics.setColor(color3);
                    graphics.drawLine(n8 - n21 - 1, n7 + 1, n8 - n21 - 1, n7 - n22 + 1);
                    graphics.drawLine(n8 - n21 - 1, n7 - n22 + 1, n8 - n21 + n20 + 1, n7 - n22 + 1);
                    graphics.setColor(color2);
                    graphics.drawLine(n8 - n21 - 1, n7 + 1, n8 - n21 + n20 + 1, n7 + 1);
                    graphics.drawLine(n8 - n21 + n20 + 1, n7 + 1, n8 - n21 + n20 + 1, n7 - n22 + 1);
                    graphics.setColor(Color.black);
                } else {
                    graphics.setColor(color3);
                    graphics.drawLine(n8 - 1, n7 + 1, n8 - 1, n7 - n22 + 1);
                    graphics.drawLine(n8 - 1, n7 - n22 + 1, n8 + n20 + 1, n7 - n22 + 1);
                    graphics.setColor(color2);
                    graphics.drawLine(n8 - 1, n7 + 1, n8 + n20 + 1, n7 + 1);
                    graphics.drawLine(n8 + n20 + 1, n7 + 1, n8 + n20 + 1, n7 - n22 + 1);
                    graphics.setColor(Color.black);
                }
            }
            graphics.drawString(string, n8, n7);
            gregorianCalendar.add(5, 1);
            gregorianCalendar.setTime(gregorianCalendar.getTime());
            n18 = gregorianCalendar.get(2);
            ++n16;
            n16 %= 7;
        }
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateModel.getDateFormatString());
        simpleDateFormat.setTimeZone(this.getTimeZone());
        ((DateFormat)simpleDateFormat).format(this.today.getTime(), stringBuffer, fieldPosition);
        graphics.setFont(this.fb);
        String string2 = res.getString("Today:");
        graphics.drawString(string2, 12 + insets.left, ((Component)((Object)this)).getSize().height - 8 - insets.bottom);
        fontMetrics = graphics.getFontMetrics();
        graphics.setColor(Color.black);
        graphics.drawString(stringBuffer.toString(), 24 + fontMetrics.stringWidth(string2) + insets.left, ((Component)((Object)this)).getSize().height - 8 - insets.bottom);
    }

    public Dimension getPreferredSize() {
        int n = 140;
        int n2 = 223;
        Insets insets = this.border.getBorderInsets((Component)((Object)this));
        if (this.border != null) {
            n += insets.top + insets.bottom;
            n2 += insets.left + insets.right;
        }
        return new Dimension(n2, n);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        DateModel dateModel = this.getModel();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = n - 10;
        int n4 = n2 - 54 + 6;
        if ((n3 /= this.xWidth) < 0 || n3 > 6 || (n4 /= 12) < 0 || n4 > 5) {
            if (n2 >= ((Component)((Object)this)).getSize().height - 18) {
                this.gc.setTime(this.today.getTime());
                int n5 = this.gc.get(1);
                int n6 = this.gc.get(2);
                int n7 = this.gc.get(5);
                this.monSpinner.setSelectedIndex(n6);
                this.yearSpinner.setValue(n5);
                dateModel.setDateByFields(n5, n6, n7);
            }
            return;
        }
        int n8 = this.valid[n4][n3];
        if (n8 != 0) {
            int n9 = this.gc.get(1);
            int n10 = this.gc.get(2);
            this.gc.set(n9, n10, n8);
            this.gc.setTime(this.gc.getTime());
            this.monSpinner.setSelectedIndex(n10);
            this.yearSpinner.setValue(n9);
            dateModel.setDateByFields(n9, n10, n8);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.monSpinner.getSelectedIndex();
        this.gc.set(2, n);
        this.gc.setTime(this.gc.getTime());
        ((Component)((Object)this)).repaint();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        Object object = changeEvent.getSource();
        if (object == this.yearSpinner) {
            n = this.yearSpinner.getValue();
            this.gc.set(1, n);
            this.gc.setTime(this.gc.getTime());
            ((Component)((Object)this)).repaint();
        }
        if (object == this.monSpinner) {
            n = this.monSpinner.getSelectedIndex();
            this.gc.set(2, n);
            this.gc.setTime(this.gc.getTime());
            ((Component)((Object)this)).repaint();
        }
    }

    public void dateChanged(DateChangedEvent dateChangedEvent) {
        Date date;
        if (this.model == null) {
            this.createModel();
        }
        if ((date = this.model.getDate()) == null) {
            this.modelDateIsNull = true;
            this.gc.setTime(new Date());
        } else {
            this.modelDateIsNull = false;
            this.gc.setTime(date);
        }
        int n = this.gc.get(1);
        this.yearSpinner.setValue(n);
        int n2 = this.gc.get(2);
        this.monSpinner.setSelectedIndex(n2);
    }
}

