/*
 * Decompiled with CFR 0.152.
 */
package javachart.utility.app;

import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;

class RangeComponent
extends Panel {
    Label labelL;
    Label valueL;
    Scrollbar slider;
    GridBagLayout l = new GridBagLayout();
    GridBagConstraints c;

    public RangeComponent(String string, double d) {
        this.setLayout(this.l);
        this.c = new GridBagConstraints();
        this.add(new Label(string));
        this.c.weightx = 1.0;
        this.c.fill = 2;
        this.slider = new Scrollbar(0, (int)(d * 100.0), 1, 0, 100);
        this.l.setConstraints(this.slider, this.c);
        this.add(this.slider);
        this.valueL = new Label("blank");
        this.setLabelText((int)(d * 100.0));
        this.add(this.valueL);
    }

    public double getValue() {
        return (double)this.slider.getValue() / 100.0;
    }

    public boolean handleEvent(Event event) {
        if (event.target.equals(this.slider)) {
            int n = this.slider.getValue();
            this.setLabelText(n);
        }
        return true;
    }

    private void setLabelText(int n) {
        if (n == 100) {
            this.valueL.setText("1.0");
        } else if (n < 10) {
            this.valueL.setText("0.0" + String.valueOf(n));
        } else {
            this.valueL.setText("0." + String.valueOf(n));
        }
    }

    public void setValue(double d) {
        this.slider.setValue((int)(d * 100.0));
        this.setLabelText(this.slider.getValue());
    }
}

