/*
 * Decompiled with CFR 0.152.
 */
package javachart.utility.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import javachart.applet.ChartAppShell;
import javachart.chart.ChartInterface;
import javachart.utility.app.ColorComponent;
import javachart.utility.app.OacComponent;
import javachart.utility.app.OnOffComponent;

class PlotDialog
extends Frame {
    ChartInterface chart;
    ChartAppShell shell;
    Label title;
    Label gridLabel;
    ColorComponent yGridColor;
    ColorComponent xGridColor;
    ColorComponent backgroundColor;
    OnOffComponent yGridVis;
    OnOffComponent xGridVis;
    OnOffComponent threeD;
    OacComponent oac;
    GridBagLayout layout;
    GridBagConstraints constraints;
    Color saveColor1;
    Color saveColor2;
    Color saveColor3;
    boolean saveVis1;
    boolean saveVis2;
    boolean save3d;

    public PlotDialog(ChartAppShell chartAppShell) {
        this.shell = chartAppShell;
        this.chart = chartAppShell.chart;
        this.saveVals();
        this.layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.setLayout(this.layout);
        this.constraints.ipady = 10;
        this.constraints.gridheight = 1;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 0;
        this.title = new Label("Plotting Area Background");
        this.layout.setConstraints(this.title, this.constraints);
        this.add(this.title);
        this.constraints.ipady = 0;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 0;
        this.backgroundColor = new ColorComponent("Background Color", this.chart.getPlotarea().getGc().getFillColor());
        this.layout.setConstraints(this.backgroundColor, this.constraints);
        this.add(this.backgroundColor);
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 0;
        this.threeD = new OnOffComponent("3D Effects", this.chart.isThreeD());
        this.layout.setConstraints(this.threeD, this.constraints);
        this.add(this.threeD);
        this.gridLabel = new Label("Grids");
        this.layout.setConstraints(this.gridLabel, this.constraints);
        this.add(this.gridLabel);
        this.xGridColor = new ColorComponent("X Axis", this.chart.getXAxis().getGridGc().getLineColor());
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 2;
        this.layout.setConstraints(this.xGridColor, this.constraints);
        this.add(this.xGridColor);
        this.yGridColor = new ColorComponent("Y Axis", this.chart.getYAxis().getGridGc().getLineColor());
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.layout.setConstraints(this.yGridColor, this.constraints);
        this.add(this.yGridColor);
        this.constraints.ipady = 0;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 2;
        this.xGridVis = new OnOffComponent("X Axis", this.chart.getXAxis().getGridVis());
        this.layout.setConstraints(this.xGridVis, this.constraints);
        this.add(this.xGridVis);
        this.constraints.ipady = 0;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 0;
        this.yGridVis = new OnOffComponent("Y Axis", this.chart.getYAxis().getGridVis());
        this.layout.setConstraints(this.yGridVis, this.constraints);
        this.add(this.yGridVis);
        this.constraints.weighty = 1.0;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.constraints.anchor = 15;
        this.oac = new OacComponent();
        this.layout.setConstraints(this.oac, this.constraints);
        this.add(this.oac);
        this.resize(340, 300);
        this.setResizable(false);
        this.setTitle("Plotting Area");
    }

    public boolean action(Event event, Object object) {
        if (this.oac.status == 0) {
            this.getVals();
            ((Component)this).hide();
        }
        if (this.oac.status == 1) {
            this.getVals();
        }
        if (this.oac.status == 2) {
            this.restoreVals();
            ((Component)this).hide();
        }
        this.shell.repaint();
        return true;
    }

    void getVals() {
        this.chart.setThreeD(this.threeD.getValue());
        this.chart.getPlotarea().getGc().setFillColor(this.backgroundColor.getValue());
        this.chart.getXAxis().getGridGc().setLineColor(this.xGridColor.getValue());
        this.chart.getYAxis().getGridGc().setLineColor(this.yGridColor.getValue());
        this.chart.getXAxis().setGridVis(this.xGridVis.getValue());
        this.chart.getYAxis().setGridVis(this.yGridVis.getValue());
    }

    void restoreVals() {
        this.chart.getPlotarea().getGc().setFillColor(this.saveColor1);
        this.chart.getXAxis().getGridGc().setLineColor(this.saveColor2);
        this.chart.getYAxis().getGridGc().setLineColor(this.saveColor3);
        this.chart.getXAxis().setGridVis(this.saveVis1);
        this.chart.getYAxis().setGridVis(this.saveVis2);
        this.chart.setThreeD(this.save3d);
    }

    void saveVals() {
        this.saveColor1 = this.chart.getPlotarea().getGc().getFillColor();
        this.saveColor2 = this.chart.getXAxis().getGridGc().getLineColor();
        this.saveColor3 = this.chart.getYAxis().getGridGc().getLineColor();
        this.saveVis1 = this.chart.getXAxis().getGridVis();
        this.saveVis2 = this.chart.getYAxis().getGridVis();
        this.save3d = this.chart.isThreeD();
    }

    public void show() {
        this.saveVals();
        super.show();
    }
}

