/*
 * Decompiled with CFR 0.152.
 */
package javachart.utility.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import javachart.applet.ChartAppShell;
import javachart.chart.ChartInterface;
import javachart.utility.app.ColorComponent;
import javachart.utility.app.FontComponent;
import javachart.utility.app.OacComponent;
import javachart.utility.app.OnOffComponent;
import javachart.utility.app.RangeComponent;

class LegendDialog
extends Frame {
    ChartInterface chart;
    ChartAppShell shell;
    Label title;
    ColorComponent labelColor;
    ColorComponent backgroundColor;
    FontComponent labelFont;
    RangeComponent llXloc;
    RangeComponent llYloc;
    OnOffComponent legendVis;
    OnOffComponent legendVertical;
    OacComponent oac;
    GridBagLayout layout;
    GridBagConstraints constraints;
    Color saveColor1;
    Color saveColor2;
    Font saveFont;
    double saveDouble1;
    double saveDouble2;
    boolean saveVis;
    boolean saveVert;

    public LegendDialog(ChartAppShell chartAppShell) {
        this.shell = chartAppShell;
        this.chart = chartAppShell.chart;
        this.saveVals();
        this.layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.setLayout(this.layout);
        this.constraints.ipady = 10;
        this.constraints.gridheight = 1;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 0;
        this.title = new Label("Legend Information");
        this.layout.setConstraints(this.title, this.constraints);
        this.add(this.title);
        this.constraints.ipady = 0;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 0;
        this.legendVis = new OnOffComponent("Legend Visible", this.chart.isLegendVisible());
        this.layout.setConstraints(this.legendVis, this.constraints);
        this.add(this.legendVis);
        this.legendVertical = new OnOffComponent("Vertical Layout", this.chart.getLegend().getVerticalLayout());
        this.layout.setConstraints(this.legendVertical, this.constraints);
        this.add(this.legendVertical);
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 1;
        this.backgroundColor = new ColorComponent("Background Color", this.chart.getLegend().getBackgroundGc().getFillColor());
        this.layout.setConstraints(this.backgroundColor, this.constraints);
        this.add(this.backgroundColor);
        this.labelColor = new ColorComponent("Label Color", this.chart.getLegend().getLabelColor());
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.layout.setConstraints(this.labelColor, this.constraints);
        this.add(this.labelColor);
        this.labelFont = new FontComponent("Label Font", this.chart.getLegend().getLabelFont());
        this.constraints.weightx = 1.0;
        this.constraints.fill = 2;
        this.constraints.ipady = 10;
        this.layout.setConstraints(this.labelFont, this.constraints);
        this.add(this.labelFont);
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 2;
        this.constraints.gridwidth = 2;
        this.llXloc = new RangeComponent("X Location", this.chart.getLegend().getLlX());
        this.layout.setConstraints(this.llXloc, this.constraints);
        this.add(this.llXloc);
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 2;
        this.constraints.gridwidth = 0;
        this.llYloc = new RangeComponent("Y Location", this.chart.getLegend().getLlY());
        this.layout.setConstraints(this.llYloc, this.constraints);
        this.add(this.llYloc);
        this.constraints.weighty = 1.0;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.constraints.anchor = 15;
        this.oac = new OacComponent();
        this.layout.setConstraints(this.oac, this.constraints);
        this.add(this.oac);
        this.resize(470, 310);
        this.setResizable(false);
        this.setTitle("Legend Options");
    }

    public boolean action(Event event, Object object) {
        if (this.oac.status == 0) {
            this.getVals();
            ((Component)this).hide();
        }
        if (this.oac.status == 1) {
            this.getVals();
        }
        if (this.oac.status == 2) {
            this.restoreVals();
            ((Component)this).hide();
        }
        this.shell.repaint();
        return true;
    }

    void getVals() {
        this.chart.getLegend().setLabelColor(this.labelColor.getValue());
        this.chart.getLegend().setLabelFont(this.labelFont.getValue());
        this.chart.getLegend().getBackgroundGc().setFillColor(this.backgroundColor.getValue());
        this.chart.setLegendVisible(this.legendVis.getValue());
        this.chart.getLegend().setVerticalLayout(this.legendVertical.getValue());
        this.chart.getLegend().setLlX(this.llXloc.getValue());
        this.chart.getLegend().setLlY(this.llYloc.getValue());
    }

    void restoreVals() {
        this.chart.getLegend().setLabelColor(this.saveColor1);
        this.chart.getLegend().getBackgroundGc().setFillColor(this.saveColor2);
        this.chart.getLegend().setVerticalLayout(this.saveVert);
        this.chart.setLegendVisible(this.saveVis);
        this.chart.getLegend().setLabelFont(this.saveFont);
        this.chart.getLegend().setLlX(this.saveDouble1);
        this.chart.getLegend().setLlY(this.saveDouble2);
    }

    void saveVals() {
        this.saveColor1 = this.chart.getLegend().getLabelColor();
        this.saveColor2 = this.chart.getLegend().getBackgroundGc().getFillColor();
        this.saveVis = this.chart.isLegendVisible();
        this.saveVert = this.chart.getLegend().getVerticalLayout();
        this.saveFont = this.chart.getLegend().getLabelFont();
        this.saveDouble1 = this.chart.getLegend().getLlX();
        this.saveDouble2 = this.chart.getPlotarea().getLlY();
    }

    public void show() {
        this.saveVals();
        super.show();
    }
}

