/*
 * Decompiled with CFR 0.152.
 */
package javachart.utility.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import javachart.applet.ChartAppShell;
import javachart.chart.ChartInterface;
import javachart.chart.Datum;
import javachart.utility.app.ColorComponent;
import javachart.utility.app.DoubleComponent;
import javachart.utility.app.OacComponent;
import javachart.utility.app.StringComponent;

class DatumDialog
extends Frame {
    ChartInterface chart;
    ChartAppShell shell;
    Datum datum;
    Label title;
    StringComponent label;
    ColorComponent fillColor;
    ColorComponent lineColor;
    DoubleComponent xVal;
    DoubleComponent yVal;
    OacComponent oac;
    GridBagLayout layout;
    GridBagConstraints constraints;
    Color saveColor1;
    Color saveColor2;
    Font saveFont;
    String saveString;
    double saveX;
    double saveY;

    public DatumDialog(ChartAppShell chartAppShell, Datum datum) {
        this.shell = chartAppShell;
        this.chart = chartAppShell.chart;
        this.datum = datum;
        this.saveVals();
        this.layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.setLayout(this.layout);
        this.constraints.ipady = 10;
        this.constraints.gridheight = 1;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 0;
        this.title = new Label("Data Point Attributes");
        this.layout.setConstraints(this.title, this.constraints);
        this.add(this.title);
        this.constraints.ipady = 3;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 0;
        this.label = new StringComponent("Label", this.datum.getLabel(), 20);
        this.layout.setConstraints(this.label, this.constraints);
        this.add(this.label);
        this.constraints.gridwidth = 2;
        this.fillColor = new ColorComponent("Fill Color", this.datum.getGc().getFillColor());
        this.layout.setConstraints(this.fillColor, this.constraints);
        this.add(this.fillColor);
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 0;
        this.lineColor = new ColorComponent("Line Color", this.datum.getGc().getLineColor());
        this.layout.setConstraints(this.lineColor, this.constraints);
        this.add(this.lineColor);
        this.xVal = new DoubleComponent("X Value", this.datum.getX());
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.layout.setConstraints(this.xVal, this.constraints);
        this.add(this.xVal);
        this.yVal = new DoubleComponent("Y Value", this.datum.getY());
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.layout.setConstraints(this.yVal, this.constraints);
        this.add(this.yVal);
        this.constraints.weighty = 1.0;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.constraints.anchor = 15;
        this.oac = new OacComponent();
        this.layout.setConstraints(this.oac, this.constraints);
        this.add(this.oac);
        this.resize(400, 300);
        this.setResizable(false);
        this.setTitle(this.datum.getLabel());
    }

    public boolean action(Event event, Object object) {
        if (this.oac.status == 0) {
            this.getVals();
            ((Component)this).hide();
        }
        if (this.oac.status == 1) {
            this.getVals();
        }
        if (this.oac.status == 2) {
            this.restoreVals();
            ((Component)this).hide();
        }
        this.shell.repaint();
        return true;
    }

    void getVals() {
        this.datum.getGc().setFillColor(this.fillColor.getValue());
        this.datum.getGc().setLineColor(this.lineColor.getValue());
        this.datum.setLabel(this.label.getValue());
        this.datum.setX(this.xVal.getValue());
        this.datum.setY(this.yVal.getValue());
    }

    void restoreVals() {
        this.datum.getGc().setFillColor(this.saveColor1);
        this.datum.getGc().setLineColor(this.saveColor2);
        this.datum.setLabel(this.saveString);
        this.datum.setX(this.saveX);
        this.datum.setY(this.saveY);
    }

    void saveVals() {
        this.saveColor1 = this.datum.getGc().getFillColor();
        this.saveColor2 = this.datum.getGc().getLineColor();
        this.saveString = this.datum.getLabel();
        this.saveX = this.datum.getX();
        this.saveY = this.datum.getY();
    }

    void setVals() {
        this.fillColor.setValue(this.datum.getGc().getFillColor());
        this.lineColor.setValue(this.datum.getGc().getLineColor());
        this.label.setValue(this.datum.getLabel());
        this.xVal.setValue(this.datum.getX());
        this.yVal.setValue(this.datum.getY());
    }

    public void show() {
        this.saveVals();
        super.show();
    }

    public void show(Datum datum) {
        this.datum = datum;
        this.saveVals();
        this.setTitle(this.datum.getLabel());
        this.setVals();
        super.show();
    }
}

