/*
 * Decompiled with CFR 0.152.
 */
package javachart.utility.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import javachart.applet.ChartAppShell;
import javachart.chart.ChartInterface;
import javachart.chart.Dataset;
import javachart.utility.app.ColorComponent;
import javachart.utility.app.FontComponent;
import javachart.utility.app.OacComponent;
import javachart.utility.app.StringComponent;

class DatasetDialog
extends Frame {
    ChartInterface chart;
    ChartAppShell shell;
    Dataset dataset;
    Label title;
    StringComponent nameField;
    ColorComponent fillColor;
    ColorComponent lineColor;
    ColorComponent labelColor;
    Label labelLabel;
    FontComponent labelFont;
    OacComponent oac;
    GridBagLayout layout;
    GridBagConstraints constraints;
    Color saveColor1;
    Color saveColor2;
    Color saveColor3;
    Font saveFont;
    String saveString;

    public DatasetDialog(ChartAppShell chartAppShell, Dataset dataset) {
        this.shell = chartAppShell;
        this.chart = chartAppShell.chart;
        this.dataset = dataset;
        this.saveVals();
        this.layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.setLayout(this.layout);
        this.constraints.ipady = 10;
        this.constraints.gridheight = 1;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 0;
        this.title = new Label("Dataset Attributes");
        this.layout.setConstraints(this.title, this.constraints);
        this.add(this.title);
        this.constraints.ipady = 3;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 0;
        this.nameField = new StringComponent("Dataset Name", this.dataset.getName(), 20);
        this.layout.setConstraints(this.nameField, this.constraints);
        this.add(this.nameField);
        this.constraints.gridwidth = 2;
        this.fillColor = new ColorComponent("Fill Color", this.dataset.getGc().getFillColor());
        this.layout.setConstraints(this.fillColor, this.constraints);
        this.add(this.fillColor);
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 0;
        this.lineColor = new ColorComponent("Line Color", this.dataset.getGc().getLineColor());
        this.layout.setConstraints(this.lineColor, this.constraints);
        this.add(this.lineColor);
        this.labelLabel = new Label("Labels");
        this.layout.setConstraints(this.labelLabel, this.constraints);
        this.add(this.labelLabel);
        this.labelColor = new ColorComponent("Label Color", this.dataset.getLabelColor());
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.layout.setConstraints(this.labelColor, this.constraints);
        this.add(this.labelColor);
        this.labelFont = new FontComponent("Label Font", this.dataset.getLabelFont());
        this.constraints.gridheight = 1;
        this.constraints.fill = 2;
        this.constraints.gridwidth = 0;
        this.layout.setConstraints(this.labelFont, this.constraints);
        this.add(this.labelFont);
        this.constraints.weighty = 1.0;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.constraints.anchor = 15;
        this.oac = new OacComponent();
        this.layout.setConstraints(this.oac, this.constraints);
        this.add(this.oac);
        this.resize(400, 320);
        this.setResizable(false);
        this.setTitle(this.dataset.getName());
    }

    public boolean action(Event event, Object object) {
        if (this.oac.status == 0) {
            this.getVals();
            ((Component)this).hide();
        }
        if (this.oac.status == 1) {
            this.getVals();
        }
        if (this.oac.status == 2) {
            this.restoreVals();
            ((Component)this).hide();
        }
        this.shell.repaint();
        return true;
    }

    void getVals() {
        this.dataset.getGc().setFillColor(this.fillColor.getValue());
        this.dataset.getGc().setLineColor(this.lineColor.getValue());
        this.dataset.setLabelColor(this.labelColor.getValue());
        this.dataset.setLabelFont(this.labelFont.getValue());
        this.dataset.setName(this.nameField.getValue());
    }

    void restoreVals() {
        this.dataset.getGc().setFillColor(this.saveColor1);
        this.dataset.getGc().setLineColor(this.saveColor2);
        this.dataset.setLabelColor(this.saveColor3);
        this.dataset.setLabelFont(this.saveFont);
        this.dataset.setName(this.saveString);
    }

    void saveVals() {
        this.saveColor1 = this.dataset.getGc().getFillColor();
        this.saveColor2 = this.dataset.getGc().getLineColor();
        this.saveColor3 = this.dataset.getLabelColor();
        this.saveFont = this.dataset.getLabelFont();
        this.saveString = this.dataset.getName();
    }

    void setVals() {
        this.fillColor.setValue(this.dataset.getGc().getFillColor());
        this.lineColor.setValue(this.dataset.getGc().getLineColor());
        this.labelColor.setValue(this.dataset.getLabelColor());
        this.labelFont.setValue(this.dataset.getLabelFont());
        this.nameField.setValue(this.dataset.getName());
    }

    public void show() {
        this.saveVals();
        super.show();
    }

    public void show(Dataset dataset) {
        this.dataset = dataset;
        this.saveVals();
        this.setTitle(this.dataset.getName());
        this.setVals();
        super.show();
    }
}

