/*
 * Decompiled with CFR 0.152.
 */
package javachart.utility.app;

import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import javachart.applet.ChartAppShell;
import javachart.chart.Bar;
import javachart.chart.ChartInterface;
import javachart.utility.app.DoubleComponent;
import javachart.utility.app.OacComponent;
import javachart.utility.app.OnOffComponent;
import javachart.utility.app.RangeComponent;

class BarDialog
extends Frame {
    ChartInterface chart;
    ChartAppShell shell;
    Bar bar;
    Label title;
    OnOffComponent labelsOn;
    RangeComponent clusterWidth;
    DoubleComponent barBaseline;
    OacComponent oac;
    GridBagLayout layout;
    GridBagConstraints constraints;
    boolean saveBool;
    double saveDouble1;
    double saveDouble2;

    public BarDialog(ChartAppShell chartAppShell, Bar bar) {
        this.shell = chartAppShell;
        this.chart = chartAppShell.chart;
        this.bar = bar;
        this.saveVals();
        this.layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.setLayout(this.layout);
        this.constraints.ipady = 10;
        this.constraints.gridheight = 1;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 0;
        this.title = new Label("Bar Chart Attributes");
        this.layout.setConstraints(this.title, this.constraints);
        this.add(this.title);
        this.constraints.ipady = 3;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 0;
        this.labelsOn = new OnOffComponent("Labels", this.bar.getLabelsOn());
        this.layout.setConstraints(this.labelsOn, this.constraints);
        this.add(this.labelsOn);
        this.constraints.fill = 2;
        this.clusterWidth = new RangeComponent("Cluster Width", this.bar.getClusterWidth());
        this.layout.setConstraints(this.clusterWidth, this.constraints);
        this.add(this.clusterWidth);
        this.barBaseline = new DoubleComponent("Baseline", this.bar.getBaseline());
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.layout.setConstraints(this.barBaseline, this.constraints);
        this.add(this.barBaseline);
        this.constraints.weighty = 1.0;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.constraints.anchor = 15;
        this.oac = new OacComponent();
        this.layout.setConstraints(this.oac, this.constraints);
        this.add(this.oac);
        this.resize(240, 220);
        this.setResizable(false);
        this.setTitle("Bar Chart Attributes");
    }

    public boolean action(Event event, Object object) {
        if (this.oac.status == 0) {
            this.getVals();
            ((Component)this).hide();
        }
        if (this.oac.status == 1) {
            this.getVals();
        }
        if (this.oac.status == 2) {
            this.restoreVals();
            ((Component)this).hide();
        }
        this.shell.repaint();
        return true;
    }

    void getVals() {
        this.bar.setLabelsOn(this.labelsOn.getValue());
        this.bar.setBaseline(this.barBaseline.getValue());
        this.bar.setClusterWidth(this.clusterWidth.getValue());
    }

    void restoreVals() {
        this.bar.setLabelsOn(this.saveBool);
        this.bar.setBaseline(this.saveDouble1);
        this.bar.setClusterWidth(this.saveDouble2);
    }

    void saveVals() {
        this.saveBool = this.bar.getLabelsOn();
        this.saveDouble1 = this.bar.getBaseline();
        this.saveDouble2 = this.bar.getClusterWidth();
    }

    void setVals() {
        this.labelsOn.setValue(this.bar.getLabelsOn());
        this.barBaseline.setValue(this.bar.getBaseline());
        this.clusterWidth.setValue(this.bar.getClusterWidth());
    }

    public void show() {
        this.saveVals();
        super.show();
    }

    public void show(Bar bar) {
        this.bar = bar;
        this.saveVals();
        this.setVals();
        super.show();
    }
}

