/*
 * Decompiled with CFR 0.152.
 */
package javachart.utility.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import javachart.applet.ChartAppShell;
import javachart.chart.ChartInterface;
import javachart.utility.app.ColorComponent;
import javachart.utility.app.FontComponent;
import javachart.utility.app.OacComponent;
import javachart.utility.app.OnOffComponent;
import javachart.utility.app.RangeComponent;
import javachart.utility.app.StringComponent;

class BackgroundDialog
extends Frame {
    ChartInterface chart;
    ChartAppShell shell;
    StringComponent titleField;
    ColorComponent titleColor;
    ColorComponent backgroundColor;
    FontComponent titleFont;
    RangeComponent lmargin;
    RangeComponent rmargin;
    RangeComponent tmargin;
    RangeComponent bmargin;
    OnOffComponent threeD;
    OnOffComponent legendVis;
    OacComponent oac;
    Label marginLabel;
    GridBagLayout layout;
    GridBagConstraints constraints;
    Color saveColor1;
    Color saveColor2;
    Color saveColor3;
    String saveString;
    Font saveFont;
    double saveLmargin;
    double saveRmargin;
    double saveTmargin;
    double saveBmargin;
    boolean saveBoolean;
    boolean saveThreeD;

    public BackgroundDialog(ChartAppShell chartAppShell) {
        this.shell = chartAppShell;
        this.chart = chartAppShell.chart;
        this.saveVals();
        this.layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.setLayout(this.layout);
        this.constraints.fill = 1;
        this.constraints.gridheight = 1;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 0;
        this.titleField = new StringComponent("Title", this.chart.getBackground().getTitleString(), 40);
        this.layout.setConstraints(this.titleField, this.constraints);
        this.add(this.titleField);
        this.titleColor = new ColorComponent("Title Color", this.chart.getBackground().getTitleColor());
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.layout.setConstraints(this.titleColor, this.constraints);
        this.add(this.titleColor);
        this.titleFont = new FontComponent("Title Font", this.chart.getBackground().getTitleFont());
        this.constraints.ipady = 30;
        this.layout.setConstraints(this.titleFont, this.constraints);
        this.add(this.titleFont);
        this.constraints.fill = 1;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.constraints.ipady = 0;
        this.backgroundColor = new ColorComponent("Background Color", this.chart.getBackground().getGc().getFillColor());
        this.layout.setConstraints(this.backgroundColor, this.constraints);
        this.add(this.backgroundColor);
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 2;
        this.threeD = new OnOffComponent("3D Effects", this.chart.isThreeD());
        this.layout.setConstraints(this.threeD, this.constraints);
        this.add(this.threeD);
        this.constraints.gridwidth = 0;
        this.legendVis = new OnOffComponent("Legend Visible", this.chart.isLegendVisible());
        this.layout.setConstraints(this.legendVis, this.constraints);
        this.add(this.legendVis);
        this.marginLabel = new Label("Margins");
        this.constraints.ipady = 10;
        this.constraints.gridheight = 1;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 0;
        this.layout.setConstraints(this.marginLabel, this.constraints);
        this.add(this.marginLabel);
        this.constraints.ipady = 5;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 2;
        this.lmargin = new RangeComponent("Left ", this.chart.getPlotarea().getLlX());
        this.layout.setConstraints(this.lmargin, this.constraints);
        this.add(this.lmargin);
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 2;
        this.constraints.gridwidth = 0;
        this.tmargin = new RangeComponent("Top   ", this.chart.getPlotarea().getUrY());
        this.layout.setConstraints(this.tmargin, this.constraints);
        this.add(this.tmargin);
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.rmargin = new RangeComponent("Right", this.chart.getPlotarea().getUrX());
        this.layout.setConstraints(this.rmargin, this.constraints);
        this.add(this.rmargin);
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 2;
        this.constraints.gridwidth = 0;
        this.bmargin = new RangeComponent("Bottom", this.chart.getPlotarea().getLlY());
        this.layout.setConstraints(this.bmargin, this.constraints);
        this.add(this.bmargin);
        this.constraints.weighty = 1.0;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.constraints.anchor = 15;
        this.oac = new OacComponent();
        this.layout.setConstraints(this.oac, this.constraints);
        this.add(this.oac);
        this.resize(450, 400);
        this.setResizable(false);
        this.setTitle("Background Options");
    }

    public boolean action(Event event, Object object) {
        if (this.oac.status == 0) {
            this.getVals();
            ((Component)this).hide();
        }
        if (this.oac.status == 1) {
            this.getVals();
        }
        if (this.oac.status == 2) {
            this.restoreVals();
            ((Component)this).hide();
        }
        this.shell.repaint();
        return true;
    }

    void getVals() {
        this.chart.getBackground().setTitleString(this.titleField.getValue());
        this.chart.getBackground().setTitleColor(this.titleColor.getValue());
        this.chart.getBackground().setTitleFont(this.titleFont.getValue());
        this.chart.getBackground().getGc().setFillColor(this.backgroundColor.getValue());
        this.chart.setLegendVisible(this.legendVis.getValue());
        this.chart.getPlotarea().setLlX(this.lmargin.getValue());
        this.chart.getPlotarea().setLlY(this.bmargin.getValue());
        this.chart.getPlotarea().setUrX(this.rmargin.getValue());
        this.chart.getPlotarea().setUrY(this.tmargin.getValue());
        this.chart.setThreeD(this.threeD.getValue());
    }

    void restoreVals() {
        this.chart.getBackground().setTitleString(this.saveString);
        this.chart.getBackground().setTitleColor(this.saveColor1);
        this.chart.getBackground().setTitleFont(this.saveFont);
        this.chart.getBackground().getGc().setFillColor(this.saveColor2);
        this.chart.getPlotarea().getGc().setFillColor(this.saveColor3);
        this.chart.getPlotarea().setLlX(this.saveLmargin);
        this.chart.getPlotarea().setLlY(this.saveBmargin);
        this.chart.getPlotarea().setUrX(this.saveRmargin);
        this.chart.getPlotarea().setUrY(this.saveTmargin);
        this.chart.setThreeD(this.saveThreeD);
        this.chart.setLegendVisible(this.saveBoolean);
    }

    void saveVals() {
        this.saveColor1 = this.chart.getBackground().getTitleColor();
        this.saveColor2 = this.chart.getBackground().getGc().getFillColor();
        this.saveString = this.chart.getBackground().getTitleString();
        this.saveFont = this.chart.getBackground().getTitleFont();
        this.saveLmargin = this.chart.getPlotarea().getLlX();
        this.saveRmargin = this.chart.getPlotarea().getUrX();
        this.saveTmargin = this.chart.getPlotarea().getUrY();
        this.saveBmargin = this.chart.getPlotarea().getLlY();
        this.saveThreeD = this.chart.isThreeD();
        this.saveBoolean = this.chart.isLegendVisible();
    }

    public void show() {
        this.saveVals();
        super.show();
    }
}

