/*
 * Decompiled with CFR 0.152.
 */
package javachart.utility.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import javachart.applet.ChartAppShell;
import javachart.chart.AxisInterface;
import javachart.chart.ChartInterface;
import javachart.utility.app.ColorComponent;
import javachart.utility.app.FontComponent;
import javachart.utility.app.IntComponent;
import javachart.utility.app.OacComponent;
import javachart.utility.app.OnOffComponent;
import javachart.utility.app.StringComponent;

class AxisDialog
extends Frame {
    ChartInterface chart;
    ChartAppShell shell;
    AxisInterface axis;
    Label title;
    StringComponent titleString;
    ColorComponent titleColor;
    ColorComponent tickColor;
    ColorComponent lineColor;
    ColorComponent labelColor;
    ColorComponent gridColor;
    FontComponent titleFont;
    FontComponent labelFont;
    OnOffComponent gridVis;
    OnOffComponent minTickVis;
    OnOffComponent majTickVis;
    OnOffComponent labelVis;
    OnOffComponent lineVis;
    OnOffComponent commaFormat;
    IntComponent labelAngle;
    OacComponent oac;
    GridBagLayout layout;
    GridBagConstraints constraints;
    Color saveColor1;
    Color saveColor2;
    Color saveColor3;
    Color saveColor4;
    Color saveColor5;
    Font saveFont1;
    Font saveFont2;
    String saveString;
    boolean saveOnOff1;
    boolean saveOnOff2;
    boolean saveOnOff3;
    boolean saveOnOff4;
    boolean saveOnOff5;
    int saveInt1;
    int saveInt2;

    public AxisDialog(ChartAppShell chartAppShell, AxisInterface axisInterface) {
        this.shell = chartAppShell;
        this.chart = chartAppShell.chart;
        this.axis = axisInterface;
        this.saveVals();
        this.layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.setLayout(this.layout);
        this.constraints.ipady = 10;
        this.constraints.gridheight = 1;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 0;
        this.title = new Label("General Axis Attributes");
        this.layout.setConstraints(this.title, this.constraints);
        this.add(this.title);
        this.constraints.ipady = 3;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 0;
        this.titleString = new StringComponent("Axis Title", this.axis.getTitleString(), 20);
        this.layout.setConstraints(this.titleString, this.constraints);
        this.add(this.titleString);
        this.constraints.gridwidth = 0;
        this.titleColor = new ColorComponent("Title Color", this.axis.getTitleColor());
        this.layout.setConstraints(this.titleColor, this.constraints);
        this.add(this.titleColor);
        this.titleFont = new FontComponent("Title Font", this.axis.getTitleFont());
        this.constraints.gridheight = 1;
        this.constraints.fill = 2;
        this.constraints.gridwidth = 0;
        this.layout.setConstraints(this.titleFont, this.constraints);
        this.add(this.titleFont);
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 2;
        this.labelVis = new OnOffComponent("Axis Labels", this.axis.getLabelVis());
        this.layout.setConstraints(this.labelVis, this.constraints);
        this.add(this.labelVis);
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 2;
        this.constraints.gridwidth = 0;
        this.labelAngle = new IntComponent("Label Angle", this.axis.getLabelAngle(), -90, 90);
        this.layout.setConstraints(this.labelAngle, this.constraints);
        this.add(this.labelAngle);
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 2;
        this.labelColor = new ColorComponent("Label Color", this.axis.getLabelColor());
        this.layout.setConstraints(this.labelColor, this.constraints);
        this.add(this.labelColor);
        this.constraints.gridwidth = 0;
        this.constraints.gridheight = 1;
        this.commaFormat = new OnOffComponent("Comma Format", this.axis.getLabelFormat() != 0);
        this.layout.setConstraints(this.commaFormat, this.constraints);
        this.add(this.commaFormat);
        this.labelFont = new FontComponent("Label Font", this.axis.getLabelFont());
        this.constraints.gridheight = 1;
        this.constraints.fill = 2;
        this.constraints.gridwidth = 0;
        this.layout.setConstraints(this.labelFont, this.constraints);
        this.add(this.labelFont);
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 2;
        this.lineVis = new OnOffComponent("Axis Line", this.axis.getLineVis());
        this.layout.setConstraints(this.lineVis, this.constraints);
        this.add(this.lineVis);
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 0;
        this.lineColor = new ColorComponent("Line Color", this.axis.getLineGc().getLineColor());
        this.layout.setConstraints(this.lineColor, this.constraints);
        this.add(this.lineColor);
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 2;
        this.gridVis = new OnOffComponent("Grid Lines", this.axis.getGridVis());
        this.layout.setConstraints(this.gridVis, this.constraints);
        this.add(this.gridVis);
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 0;
        this.gridColor = new ColorComponent("Grid Color", this.axis.getGridGc().getLineColor());
        this.layout.setConstraints(this.gridColor, this.constraints);
        this.add(this.gridColor);
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 2;
        this.majTickVis = new OnOffComponent("Major Ticks", this.axis.getMajTickVis());
        this.layout.setConstraints(this.majTickVis, this.constraints);
        this.add(this.majTickVis);
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 0;
        this.tickColor = new ColorComponent("Tick Color", this.axis.getTickGc().getLineColor());
        this.layout.setConstraints(this.tickColor, this.constraints);
        this.add(this.tickColor);
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.gridwidth = 0;
        this.minTickVis = new OnOffComponent("Minor Ticks", this.axis.getMinTickVis());
        this.layout.setConstraints(this.minTickVis, this.constraints);
        this.add(this.minTickVis);
        this.constraints.weighty = 1.0;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.constraints.anchor = 15;
        this.oac = new OacComponent();
        this.layout.setConstraints(this.oac, this.constraints);
        this.add(this.oac);
        this.resize(450, 570);
        this.setResizable(false);
        if (this.axis.getTitleString() != null) {
            this.setTitle(this.axis.getTitleString());
        } else {
            this.setTitle("Axis");
        }
    }

    public boolean action(Event event, Object object) {
        if (this.oac.status == 0) {
            this.getVals();
            ((Component)this).hide();
        }
        if (this.oac.status == 1) {
            this.getVals();
        }
        if (this.oac.status == 2) {
            this.restoreVals();
            ((Component)this).hide();
        }
        this.shell.repaint();
        return true;
    }

    void getVals() {
        this.axis.setTitleString(this.titleString.getValue());
        this.axis.setTitleColor(this.titleColor.getValue());
        this.axis.getTickGc().setLineColor(this.tickColor.getValue());
        this.axis.getLineGc().setLineColor(this.lineColor.getValue());
        this.axis.getGridGc().setLineColor(this.gridColor.getValue());
        this.axis.setLabelColor(this.labelColor.getValue());
        this.axis.setTitleFont(this.titleFont.getValue());
        this.axis.setLabelFont(this.labelFont.getValue());
        this.axis.setGridVis(this.gridVis.getValue());
        this.axis.setMinTickVis(this.minTickVis.getValue());
        this.axis.setMajTickVis(this.majTickVis.getValue());
        this.axis.setLabelVis(this.labelVis.getValue());
        this.axis.setLabelAngle(this.labelAngle.getValue());
        this.axis.setLabelFormat(this.commaFormat.getValue() ? 1 : 0);
        this.axis.setLineVis(this.lineVis.getValue());
    }

    void restoreVals() {
        this.axis.setTitleString(this.saveString);
        this.axis.setTitleColor(this.saveColor1);
        this.axis.getTickGc().setLineColor(this.saveColor2);
        this.axis.getLineGc().setLineColor(this.saveColor3);
        this.axis.getGridGc().setLineColor(this.saveColor4);
        this.axis.setLabelColor(this.saveColor5);
        this.axis.setTitleFont(this.saveFont1);
        this.axis.setLabelFont(this.saveFont2);
        this.axis.setGridVis(this.saveOnOff1);
        this.axis.setMinTickVis(this.saveOnOff2);
        this.axis.setMajTickVis(this.saveOnOff3);
        this.axis.setLabelVis(this.saveOnOff4);
        this.axis.setLineVis(this.saveOnOff5);
        this.axis.setLabelAngle(this.saveInt1);
        this.axis.setLabelFormat(this.saveInt2);
    }

    void saveVals() {
        this.saveString = this.axis.getTitleString();
        this.saveColor1 = this.axis.getTitleColor();
        this.saveColor2 = this.axis.getTickGc().getLineColor();
        this.saveColor3 = this.axis.getLineGc().getLineColor();
        this.saveColor4 = this.axis.getGridGc().getLineColor();
        this.saveColor5 = this.axis.getLabelColor();
        this.saveFont1 = this.axis.getTitleFont();
        this.saveFont2 = this.axis.getLabelFont();
        this.saveOnOff1 = this.axis.getGridVis();
        this.saveOnOff2 = this.axis.getMinTickVis();
        this.saveOnOff3 = this.axis.getMajTickVis();
        this.saveOnOff4 = this.axis.getLabelVis();
        this.saveOnOff5 = this.axis.getLineVis();
        this.saveInt1 = this.axis.getLabelAngle();
        this.saveInt2 = this.axis.getLabelFormat();
    }

    void setVals() {
        this.titleString.setValue(this.axis.getTitleString());
        this.titleColor.setValue(this.axis.getTitleColor());
        this.tickColor.setValue(this.axis.getTickGc().getLineColor());
        this.lineColor.setValue(this.axis.getLineGc().getLineColor());
        this.gridColor.setValue(this.axis.getGridGc().getLineColor());
        this.labelColor.setValue(this.axis.getLabelColor());
        this.titleFont.setValue(this.axis.getTitleFont());
        this.labelFont.setValue(this.axis.getLabelFont());
        this.gridVis.setValue(this.axis.getGridVis());
        this.minTickVis.setValue(this.axis.getMinTickVis());
        this.majTickVis.setValue(this.axis.getMajTickVis());
        this.labelVis.setValue(this.axis.getLabelVis());
        this.labelAngle.setValue(this.axis.getLabelAngle());
        this.commaFormat.setValue(this.axis.getLabelFormat() != 0);
        this.lineVis.setValue(this.axis.getLineVis());
    }

    public void show() {
        this.saveVals();
        super.show();
    }

    public void show(AxisInterface axisInterface) {
        this.axis = axisInterface;
        this.saveVals();
        this.setTitle(this.axis.getTitleString());
        this.setVals();
        super.show();
    }
}

