/*
 * Decompiled with CFR 0.152.
 */
package javachart.utility;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;

public class GifMaker {
    OutputStream myOutputStream;
    Image myImage;
    byte[] byteArray;
    int bytesInArray;
    Component myProgressBar;
    static final int RMASK = 224;
    static final int RSHIFT = 0;
    static final int GMASK = 224;
    static final int GSHIFT = 3;
    static final int BMASK = 192;
    static final int BSHIFT = 6;
    static final int MAX_LZW_BITS = 12;
    static final int TABLE_SIZE = 5003;
    static final int LARGEST_CODE = 4095;
    static byte[] code_buffer;
    static int[] stack;
    static int code_size;
    static int set_code_size;
    static int free_code;
    static int max_code;
    static int max_code_size;
    static int clear_code;
    static int eof_code;
    static int curbit;
    static int lastbit;
    static int get_done;
    static int last_byte;
    static int return_clear;
    static byte[] outpol;

    public GifMaker() {
        this(null, null);
    }

    public GifMaker(OutputStream outputStream, Image image) {
        this.setOutputStream(outputStream);
        this.setImage(image);
    }

    public void setImage(Image image) {
        this.myImage = image;
        this.bytesInArray = 0;
    }

    public Image getImage() {
        return this.myImage;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.myOutputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.myOutputStream;
    }

    public void setProgressBar(Component component) {
        this.myProgressBar = component;
    }

    public void write() throws IOException {
        if (this.myOutputStream == null) {
            System.out.println("no OutputStream");
            return;
        }
        if (this.myImage == null) {
            System.out.println("no Image");
            return;
        }
        if (this.bytesInArray == 0) {
            this.generate();
        }
        this.myOutputStream.write(this.byteArray, 0, this.bytesInArray);
        this.myOutputStream.flush();
    }

    public int getSize() {
        if (this.myImage == null) {
            return 0;
        }
        if (this.bytesInArray == 0) {
            this.generate();
        }
        return this.bytesInArray;
    }

    public byte[] getByteArray() {
        if (this.myImage == null) {
            return null;
        }
        if (this.bytesInArray == 0) {
            this.generate();
        }
        byte[] byArray = new byte[this.bytesInArray];
        int n = 0;
        while (n < this.bytesInArray) {
            byArray[n] = this.byteArray[n];
            ++n;
        }
        return byArray;
    }

    public void generate() {
        if (this.myImage == null) {
            return;
        }
        this.save(this.myImage);
    }

    public void generate(int[] nArray, int n, int n2) {
        if (this.myImage == null) {
            return;
        }
        this.save(nArray, n, n2);
    }

    private void dither(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n * 3;
        int n6 = n2 - 1;
        int n7 = n - 1;
        int n8 = 0;
        while (n8 < 256) {
            nArray3[n8] = ((n8 & 0xE0) * 255 + 112) / 224;
            nArray4[n8] = ((n8 << 3 & 0xE0) * 255 + 112) / 224;
            nArray5[n8] = ((n8 << 6 & 0xC0) * 255 + 96) / 192;
            ++n8;
        }
        int[] nArray6 = new int[n5];
        int[] nArray7 = new int[n5];
        int n9 = 0;
        while (n9 < n5) {
            nArray7[n9] = (nArray[n3] & 0xFF0000) >> 16;
            nArray7[n9 + 1] = (nArray[n3] & 0xFF00) >> 8;
            nArray7[n9 + 2] = nArray[n3] & 0xFF;
            ++n3;
            n9 += 3;
        }
        n8 = 0;
        while (n8 < n2) {
            if (n8 % 100 == 0) {
                this.progressBar("Dithering Image", n2, n8, Color.blue);
            }
            int[] nArray8 = nArray6;
            nArray6 = nArray7;
            nArray7 = nArray8;
            if (n8 != n6) {
                n9 = 0;
                while (n9 < n5) {
                    nArray7[n9] = (nArray[n3] & 0xFF0000) >> 16;
                    nArray7[n9 + 1] = (nArray[n3] & 0xFF00) >> 8;
                    nArray7[n9 + 2] = nArray[n3] & 0xFF;
                    ++n3;
                    n9 += 3;
                }
            }
            n9 = 0;
            int n10 = 0;
            int n11 = 0;
            while (n9 < n) {
                int n12;
                int n13 = nArray6[n10++];
                int n14 = nArray6[n10++];
                int n15 = nArray6[n10++];
                if (n13 < 0) {
                    n13 = 0;
                }
                if (n13 > 255) {
                    n13 = 255;
                }
                if (n14 < 0) {
                    n14 = 0;
                }
                if (n14 > 255) {
                    n14 = 255;
                }
                if (n15 < 0) {
                    n15 = 0;
                }
                if (n15 > 255) {
                    n15 = 255;
                }
                nArray2[n4] = n12 = n13 & 0xE0 | (n14 & 0xE0) >> 3 | (n15 & 0xC0) >> 6;
                ++n4;
                n13 -= nArray3[n12];
                n14 -= nArray4[n12];
                n15 -= nArray5[n12];
                if (n9 != n7) {
                    int n16 = n10;
                    nArray6[n16] = nArray6[n16] + n13 * 7 / 16;
                    int n17 = n10 + 1;
                    nArray6[n17] = nArray6[n17] + n14 * 7 / 16;
                    int n18 = n10 + 2;
                    nArray6[n18] = nArray6[n18] + n15 * 7 / 16;
                }
                if (n8 != n6) {
                    int n19 = n11;
                    nArray7[n19] = nArray7[n19] + n13 * 5 / 16;
                    int n20 = n11 + 1;
                    nArray7[n20] = nArray7[n20] + n14 * 5 / 16;
                    int n21 = n11 + 2;
                    nArray7[n21] = nArray7[n21] + n15 * 5 / 16;
                    if (n9 > 0) {
                        int n22 = n11 - 3;
                        nArray7[n22] = nArray7[n22] + n13 * 3 / 16;
                        int n23 = n11 - 2;
                        nArray7[n23] = nArray7[n23] + n14 * 3 / 16;
                        int n24 = n11 - 1;
                        nArray7[n24] = nArray7[n24] + n15 * 3 / 16;
                    }
                    if (n9 != n7) {
                        int n25 = n11 + 3;
                        nArray7[n25] = nArray7[n25] + n13 / 16;
                        int n26 = n11 + 4;
                        nArray7[n26] = nArray7[n26] + n14 / 16;
                        int n27 = n11 + 5;
                        nArray7[n27] = nArray7[n27] + n15 / 16;
                    }
                    n11 += 3;
                }
                ++n9;
            }
            ++n8;
        }
    }

    private static void initLZW(int n) {
        stack = new int[8192];
        set_code_size = n;
        code_size = set_code_size + 1;
        clear_code = 1 << set_code_size;
        eof_code = clear_code + 1;
        free_code = clear_code + 2;
        max_code = 1 << code_size;
        max_code_size = 2 * clear_code;
        int n2 = 0;
        while (n2 < 5003) {
            GifMaker.stack[n2] = 0;
            ++n2;
        }
    }

    private void WriteByte(int n) {
        this.byteArray[this.bytesInArray] = (byte)n;
        ++this.bytesInArray;
    }

    private void cflush(int n) {
        this.WriteByte(n);
        int n2 = 0;
        while (n2 < n) {
            this.WriteByte(code_buffer[n2]);
            ++n2;
        }
    }

    private void write_code(int n) {
        last_byte = curbit >> 3;
        lastbit = curbit & 7;
        if (last_byte >= 254) {
            this.cflush(last_byte);
            GifMaker.code_buffer[0] = code_buffer[last_byte];
            curbit = lastbit;
            last_byte = 0;
        }
        if (lastbit > 0) {
            long l = (long)n << lastbit | (long)code_buffer[last_byte];
            GifMaker.code_buffer[GifMaker.last_byte] = (byte)l;
            GifMaker.code_buffer[GifMaker.last_byte + 1] = (byte)(l >> 8);
            GifMaker.code_buffer[GifMaker.last_byte + 2] = (byte)(l >> 16);
        } else {
            GifMaker.code_buffer[GifMaker.last_byte] = (byte)n;
            GifMaker.code_buffer[GifMaker.last_byte + 1] = (byte)(n >> 8);
        }
        curbit += code_size;
    }

    private void compressImage(int[] nArray, int n, int n2) {
        int n3;
        int[] nArray2 = new int[5003];
        int[] nArray3 = new int[5003];
        if (n == 1) {
            n = 2;
        }
        this.WriteByte(n);
        int n4 = 0;
        curbit = 0;
        GifMaker.initLZW(n);
        this.write_code(clear_code);
        int n5 = n3 = nArray[n4++];
        block0: while (n4 < n2) {
            if (n4 % 1000 == 0) {
                this.progressBar("compressing image", n2, n4, Color.green);
            }
            n3 = nArray[n4++];
            int n6 = (n5 ^ n3 << 5) % 5003;
            int n7 = 1;
            while (true) {
                if (stack[n6] == 0) {
                    this.write_code(n5);
                    n7 = free_code;
                    if (free_code <= 4095) {
                        nArray3[n6] = n5;
                        nArray2[n6] = n3;
                        GifMaker.stack[n6] = free_code++;
                    }
                    if (n7 == max_code) {
                        if (code_size < 12) {
                            ++code_size;
                            max_code <<= 1;
                        } else {
                            this.write_code(clear_code);
                            GifMaker.initLZW(n);
                        }
                    }
                    n5 = n3;
                    continue block0;
                }
                if (nArray3[n6] == n5 && nArray2[n6] == n3) {
                    n5 = stack[n6];
                    continue block0;
                }
                if (++n6 < 5003) continue;
                n6 -= 5003;
            }
        }
        this.write_code(n5);
        this.write_code(eof_code);
        if (curbit > 0) {
            this.cflush((curbit + 7) / 8);
        }
        this.cflush(0);
    }

    private void save(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n, int n2) {
        this.byteArray = new byte[n * n2];
        code_buffer = new byte[260];
        outpol = new byte[1];
        int n3 = 255;
        this.WriteByte(71);
        this.WriteByte(73);
        this.WriteByte(70);
        this.WriteByte(56);
        this.WriteByte(55);
        this.WriteByte(97);
        this.WriteByte(n & 0xFF);
        this.WriteByte(n >> 8 & 0xFF);
        this.WriteByte(n2 & 0xFF);
        this.WriteByte(n2 >> 8 & 0xFF);
        this.WriteByte(n3);
        this.WriteByte(0);
        this.WriteByte(0);
        int n4 = 0;
        while (n4 < 256) {
            this.WriteByte(nArray2[n4]);
            this.WriteByte(nArray3[n4]);
            this.WriteByte(nArray4[n4]);
            ++n4;
        }
        this.WriteByte(44);
        this.WriteByte(0);
        this.WriteByte(0);
        this.WriteByte(0);
        this.WriteByte(0);
        this.WriteByte(n & 0xFF);
        this.WriteByte(n >> 8 & 0xFF);
        this.WriteByte(n2 & 0xFF);
        this.WriteByte(n2 >> 8 & 0xFF);
        this.WriteByte(n3 & 7);
        this.compressImage(nArray, (n3 & 7) + 1, n * n2);
        this.WriteByte(59);
    }

    private void save(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n * n2];
        int[] nArray3 = new int[256];
        int[] nArray4 = new int[256];
        int[] nArray5 = new int[256];
        this.dither(nArray, nArray2, nArray3, nArray4, nArray5, n, n2);
        this.save(nArray2, nArray3, nArray4, nArray5, n, n2);
    }

    private void save(Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("interrupted grab");
        }
        this.save(nArray, n, n2);
    }

    private void progressBar(String string, int n, int n2, Color color) {
        if (this.myProgressBar == null) {
            return;
        }
        Graphics graphics = this.myProgressBar.getGraphics();
        graphics.setColor(color);
        graphics.fillRect(0, 0, this.myProgressBar.size().width * n2 / n, this.myProgressBar.size().height);
    }
}

