/*
 * Decompiled with CFR 0.152.
 */
package javachart.servlet;

import java.io.InputStream;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javachart.chart.DateAxis;
import javachart.chart.DateLineChart;
import javachart.chart.Datum;
import javachart.chart.Globals;
import javachart.servlet.ChartBuilder;
import javax.servlet.http.HttpServletRequest;

public class dateLineChartBuilder
extends ChartBuilder {
    StringTokenizer tokenLine;
    protected Vector dataBlockStrings;
    String urlString;
    protected InputStream myInputStream;
    protected boolean incrementalData = false;
    String incrementalUrl;

    public void getMyDatasets(String string) {
        this.myInputStream = this.openURL(string);
        if (this.myInputStream == null) {
            return;
        }
        this.urlString = new String(string);
        this.dataBlockStrings = new Vector();
        this.readDataBlock();
        this.convertDataBlockToChartData(true);
        if (!this.closeURL(this.myInputStream)) {
            return;
        }
    }

    protected void reReadURLDatasets() {
        if (this.incrementalData) {
            this.myInputStream = this.openURL(this.incrementalUrl);
            if (this.myInputStream == null) {
                return;
            }
            this.dataBlockStrings = new Vector();
            this.readDataBlock();
            this.convertDataBlockToIncrementalData(false);
            if (!this.closeURL(this.myInputStream)) {
                return;
            }
        } else {
            this.myInputStream = this.openURL(this.urlString);
            if (this.myInputStream == null) {
                return;
            }
            this.dataBlockStrings = new Vector();
            this.readDataBlock();
            this.convertDataBlockToChartData(false);
            if (!this.closeURL(this.myInputStream)) {
                return;
            }
        }
    }

    public void init(HttpServletRequest httpServletRequest) {
        this.request = httpServletRequest;
        this.chart = new DateLineChart("My Chart");
        this.getOptions();
        this.getMyOptions();
    }

    public void getMyOptions() {
        DateLineChart dateLineChart = (DateLineChart)this.chart;
        DateAxis dateAxis = (DateAxis)dateLineChart.getXAxis();
        String string = this.getParameter("plotLinesOn");
        if (string != null) {
            dateLineChart.setLineVisible(true);
        }
        if ((string = this.getParameter("plotLinesOff")) != null) {
            dateLineChart.setLineVisible(false);
        }
        this.getAxisOptions();
        string = this.getParameter("startDate");
        if (string != null) {
            dateAxis.setAxisStart(Date.parse(string));
        }
        if ((string = this.getParameter("endDate")) != null) {
            dateAxis.setAxisEnd(Date.parse(string));
        }
        if ((string = this.getParameter("scalingType")) != null) {
            dateAxis.setScalingType(Integer.parseInt(string));
        }
        if ((string = this.getParameter("incrementalDataURL")) != null) {
            this.incrementalData = true;
            this.incrementalUrl = string;
        }
    }

    protected void readDataBlock() {
        String string = this.getLineFromURL(this.myInputStream);
        while (string != null) {
            if (string.length() > 1) {
                this.dataBlockStrings.addElement(new StringTokenizer(string, ","));
            }
            string = this.getLineFromURL(this.myInputStream);
        }
    }

    protected void convertDataBlockToChartData(boolean bl) {
        int n = this.dataBlockStrings.size();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = this.getTimeElement(n2);
            ++n2;
        }
        int n3 = ((StringTokenizer)this.dataBlockStrings.elementAt(0)).countTokens();
        int n4 = 1;
        while (n4 <= n3) {
            n2 = 0;
            while (n2 < n) {
                dArray2[n2] = this.getDoubleElement(n2);
                ++n2;
            }
            if (bl) {
                this.getDatasetParameters(n4 - 1, dArray, dArray2, null, null);
            } else {
                this.chart.getDatasets()[n4 - 1].replaceXData(dArray);
                this.chart.getDatasets()[n4 - 1].replaceYData(dArray2);
            }
            ++n4;
        }
    }

    protected void convertDataBlockToIncrementalData(boolean bl) {
        int n = this.dataBlockStrings.size();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = this.getTimeElement(n2);
            ++n2;
        }
        int n3 = ((StringTokenizer)this.dataBlockStrings.elementAt(0)).countTokens();
        int n4 = 1;
        while (n4 <= n3) {
            n2 = 0;
            while (n2 < n) {
                dArray2[n2] = this.getDoubleElement(n2);
                ++n2;
            }
            if (bl) {
                this.getDatasetParameters(n4 - 1, dArray, dArray2, null, null);
            } else {
                Vector vector = this.chart.getDatasets()[n4 - 1].getData();
                Globals globals = this.chart.getGlobals();
                int n5 = 0;
                while (n5 < dArray.length) {
                    Datum datum = new Datum(dArray[n5], dArray2[n5], globals);
                    vector.addElement(datum);
                    ++n5;
                }
            }
            ++n4;
        }
    }

    protected double getTimeElement(int n) {
        StringTokenizer stringTokenizer = (StringTokenizer)this.dataBlockStrings.elementAt(n);
        String string = stringTokenizer.nextToken().trim();
        try {
            long l = Date.parse(string);
            return l;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("can't parse " + string);
            return 0.0;
        }
    }

    protected double getDoubleElement(int n) {
        StringTokenizer stringTokenizer = (StringTokenizer)this.dataBlockStrings.elementAt(n);
        String string = stringTokenizer.nextToken().trim();
        return Double.valueOf(string);
    }
}

