/*
 * Decompiled with CFR 0.152.
 */
package javachart.servlet;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Vector;
import javachart.chart.AxisInterface;
import javachart.chart.ChartInterface;
import javachart.chart.Dataset;
import javachart.chart.Datum;
import javachart.chart.Gc;
import javax.servlet.http.HttpServletRequest;

public abstract class ChartBuilder {
    public ChartInterface chart;
    double[] yArr = new double[1];
    boolean gotDatasets = false;
    URL myUrl;
    Thread getThread;
    MediaTracker imageTracker;
    boolean gotImages;
    char[] buff = new char[8192];
    String delimiter;
    boolean home = false;
    HttpServletRequest request;

    public abstract void init(HttpServletRequest var1);

    protected String getParameter(String string) {
        return this.request.getParameter(string);
    }

    protected void getOptions() {
        this.gotDatasets = false;
        String string = this.getParameter("CopyrightNotification");
        if (string != null && string.equals("JavaChart is a copyrighted work, and subject to full legal protection")) {
            this.home = true;
        }
        this.delimiter = string != null ? new String(string) : new String(",");
        string = this.getParameter("URLDataBlock");
        if (string != null) {
            this.getURLDataBlock(string);
        }
        if ((string = this.getParameter("URLXYDataRows")) != null) {
            this.getURLXYDataRows(string);
        }
        if ((string = this.getParameter("URLXYDataColumns")) != null) {
            this.getURLXYDataColumns(string);
        }
        if ((string = this.getParameter("dataset0xURL")) != null) {
            this.getURLDatasets();
        }
        if ((string = this.getParameter("dataset0yURL")) != null) {
            this.getURLDatasets();
        }
        if ((string = this.getParameter("dataset0xyURL")) != null) {
            this.getURLDatasets();
        }
        if ((string = this.getParameter("dataset0xValues")) != null) {
            this.getDatasets();
        }
        if ((string = this.getParameter("dataset0yValues")) != null) {
            this.getDatasets();
        }
        if ((string = this.getParameter("dataset0xyValues")) != null) {
            this.getDatasets();
        }
        if ((string = this.getParameter("customDatasetHandler")) != null) {
            this.getMyDatasets(string);
        }
        if ((string = this.getParameter("legendOn")) != null) {
            this.chart.setLegendVisible(true);
        }
        if ((string = this.getParameter("legendOff")) != null) {
            this.chart.setLegendVisible(false);
        }
        if ((string = this.getParameter("legendColor")) != null) {
            this.chart.getLegend().getBackgroundGc().setFillColor(this.getColor(string));
            this.chart.getLegend().getBackgroundGc().setLineColor(this.getColor(string));
        }
        if ((string = this.getParameter("legendVertical")) != null) {
            this.chart.getLegend().setVerticalLayout(true);
        }
        if ((string = this.getParameter("legendHorizontal")) != null) {
            this.chart.getLegend().setVerticalLayout(false);
        }
        if ((string = this.getParameter("legendLabelColor")) != null) {
            this.chart.getLegend().setLabelColor(this.getColor(string));
        }
        if ((string = this.getParameter("legendLabelFont")) != null) {
            this.chart.getLegend().setLabelFont(this.getFont(string));
        }
        if ((string = this.getParameter("legendllX")) != null) {
            this.chart.getLegend().setLlX(Double.valueOf(string));
        }
        if ((string = this.getParameter("legendllY")) != null) {
            this.chart.getLegend().setLlY(Double.valueOf(string));
        }
        if ((string = this.getParameter("iconWidth")) != null) {
            this.chart.getLegend().setIconWidth(Double.valueOf(string.trim()));
        }
        if ((string = this.getParameter("iconHeight")) != null) {
            this.chart.getLegend().setIconHeight(Double.valueOf(string.trim()));
        }
        if ((string = this.getParameter("iconGap")) != null) {
            this.chart.getLegend().setIconGap(Double.valueOf(string.trim()));
        }
        if ((string = this.getParameter("plotAreaTop")) != null) {
            this.chart.getPlotarea().setUrY(Double.valueOf(string));
        }
        if ((string = this.getParameter("plotAreaBottom")) != null) {
            this.chart.getPlotarea().setLlY(Double.valueOf(string));
        }
        if ((string = this.getParameter("plotAreaLeft")) != null) {
            this.chart.getPlotarea().setLlX(Double.valueOf(string));
        }
        if ((string = this.getParameter("plotAreaRight")) != null) {
            this.chart.getPlotarea().setUrX(Double.valueOf(string));
        }
        if ((string = this.getParameter("plotAreaColor")) != null) {
            this.chart.getPlotarea().getGc().setFillColor(this.getColor(string));
        }
        if ((string = this.getParameter("backgroundColor")) != null) {
            this.chart.getBackground().getGc().setFillColor(this.getColor(string));
        }
        if ((string = this.getParameter("titleColor")) != null) {
            this.chart.getBackground().setTitleColor(this.getColor(string));
        }
        if ((string = this.getParameter("titleFont")) != null) {
            this.chart.getBackground().setTitleFont(this.getFont(string));
        }
        if ((string = this.getParameter("titleString")) != null) {
            this.chart.getBackground().setTitleString(string);
        }
        if ((string = this.getParameter("3D")) != null) {
            this.chart.setThreeD(true);
        }
        if ((string = this.getParameter("2D")) != null) {
            this.chart.setThreeD(false);
        }
        if ((string = this.getParameter("XDepth")) != null) {
            this.chart.setXOffset(Integer.parseInt(string));
        }
        if ((string = this.getParameter("YDepth")) != null) {
            this.chart.setYOffset(Integer.parseInt(string));
        }
    }

    protected Font getFont(String string) {
        int n = string.indexOf(this.delimiter, 0);
        String string2 = string.substring(0, n);
        string2 = string.substring(0, n);
        int n2 = string.indexOf(this.delimiter, n + 1);
        int n3 = Integer.valueOf(string.substring(n + 1, n2));
        int n4 = Integer.valueOf(string.substring(n2 + 1));
        Font font = new Font(string2, n4, n3);
        if (font != null) {
            return font;
        }
        return new Font("TimesRoman", 0, 12);
    }

    protected Color getColor(String string) {
        if (string.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (string.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (string.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (string.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (string.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (string.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (string.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (string.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (string.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        if (string.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (string.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (string.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (string.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (string.equalsIgnoreCase("transparent")) {
            return Gc.TRANSPARENT;
        }
        try {
            return new Color(Integer.parseInt(string, 16));
        }
        catch (NumberFormatException numberFormatException) {
            return Color.black;
        }
    }

    protected void getDatasets() {
        int n = 0;
        if (this.gotDatasets) {
            return;
        }
        this.gotDatasets = true;
        while (this.getDataset(n)) {
            ++n;
        }
        if (this.chart.getNumDatasets() < 1) {
            this.chart.addDataSet("dummy", this.yArr);
        }
    }

    public boolean getDataset(int n) {
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        double[] dArray4 = null;
        String string = this.getParameter("dataset" + n + "xValues");
        if (string != null) {
            dArray = this.getVals(string);
        }
        if ((string = this.getParameter("dataset" + n + "dateValues")) != null) {
            dArray = this.getDateVals(string);
        }
        if ((string = this.getParameter("dataset" + n + "yValues")) != null) {
            dArray2 = this.getVals(string);
        }
        if ((string = this.getParameter("dataset" + n + "y2Values")) != null) {
            dArray3 = this.getVals(string);
        }
        if ((string = this.getParameter("dataset" + n + "y3Values")) != null) {
            dArray4 = this.getVals(string);
        }
        if ((string = this.getParameter("dataset" + n + "xyValues")) != null) {
            System.out.println("xyVals not supported yet");
        }
        return this.getDatasetParameters(n, dArray, dArray2, dArray3, dArray4);
    }

    protected double[] getVals(String string) {
        int n = 0;
        int n2 = 0;
        while (n != -1) {
            n = string.indexOf(this.delimiter, n + 1);
            ++n2;
        }
        if (n2 == 0) {
            try {
                double[] dArray = new double[1];
                dArray[n] = Double.valueOf(string.trim());
                return dArray;
            }
            catch (NumberFormatException numberFormatException) {
                double[] dArray = new double[]{0.0};
                System.out.println("Unintelligable number in this string: " + string);
                return dArray;
            }
        }
        double[] dArray = new double[n2];
        int n3 = 0;
        try {
            n = 0;
            while (n < n2 - 1) {
                int n4 = string.indexOf(this.delimiter, n3);
                dArray[n] = Double.valueOf(string.substring(n3, n4).trim());
                n3 = n4 + 1;
                ++n;
            }
            dArray[n] = Double.valueOf(string.substring(n3).trim());
        }
        catch (NumberFormatException numberFormatException) {
            dArray = new double[]{0.0};
            System.out.println("Unintelligable number in this string: " + string);
        }
        return dArray;
    }

    protected double[] getDateVals(String string) {
        int n = 0;
        int n2 = 0;
        while (n != -1) {
            n = string.indexOf(this.delimiter, n + 1);
            ++n2;
        }
        if (n2 == 0) {
            double[] dArray = new double[1];
            dArray[n] = Date.parse(string.trim());
            return dArray;
        }
        double[] dArray = new double[n2];
        int n3 = 0;
        n = 0;
        while (n < n2 - 1) {
            int n4 = string.indexOf(this.delimiter, n3);
            dArray[n] = Date.parse(string.substring(n3, n4).trim());
            n3 = n4 + 1;
            ++n;
        }
        dArray[n] = Date.parse(string.substring(n3).trim());
        return dArray;
    }

    protected String[] getLabels(String string) {
        int n = 0;
        int n2 = 0;
        while (n != -1) {
            n = string.indexOf(this.delimiter, n + 1);
            ++n2;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        n = 0;
        while (n < n2 - 1) {
            int n4 = string.indexOf(this.delimiter, n3);
            stringArray[n] = string.substring(n3, n4);
            n3 = n4 + 1;
            ++n;
        }
        stringArray[n] = string.substring(n3);
        return stringArray;
    }

    protected Image makeURLImage(String string) {
        Image image = null;
        return image;
    }

    public InputStream openURL(String string) {
        InputStream inputStream;
        try {
            this.myUrl = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return this.openFile(string);
        }
        try {
            URLConnection uRLConnection = this.myUrl.openConnection();
            uRLConnection.setUseCaches(false);
            inputStream = uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            System.out.println("can't open stream " + string);
            return null;
        }
        return inputStream;
    }

    protected InputStream openFile(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            return fileInputStream;
        }
        catch (Exception exception) {
            System.out.println("can't open file " + string);
            return null;
        }
    }

    public boolean closeURL(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("can't close URL");
            return false;
        }
        return true;
    }

    public String getLineFromURL(InputStream inputStream) {
        boolean bl = true;
        int n = -1;
        int n2 = 0;
        while (n2 < 256) {
            this.buff[n2] = '\u0000';
            ++n2;
        }
        n2 = 0;
        while (bl) {
            try {
                n = inputStream.read();
            }
            catch (IOException iOException) {
                System.out.println("bad i/o operation");
            }
            if (n == -1) {
                bl = false;
                if (n2 == 0) {
                    return null;
                }
                return new String(this.buff, 0, n2);
            }
            if (n == 10 || n == 13) {
                if (n2 <= 0) continue;
                return new String(this.buff, 0, n2);
            }
            this.buff[n2] = (char)n;
            ++n2;
        }
        return new String(this.buff, 0, n2);
    }

    protected void getURLDatasets() {
        int n = 0;
        if (this.gotDatasets) {
            return;
        }
        this.gotDatasets = true;
        while (this.getURLDataset(n)) {
            ++n;
        }
        if (this.chart.getNumDatasets() < 1) {
            this.chart.addDataSet("dummy", this.yArr);
        }
    }

    protected void reReadURLDatasets() {
        int n;
        int n2;
        int n3;
        double[] dArray;
        Object object;
        double[] dArray2;
        String string;
        int n4;
        InputStream inputStream;
        String string2 = this.getParameter("URLDataBlock");
        if (string2 != null) {
            inputStream = this.openURL(string2);
            if (inputStream != null) {
                n4 = 0;
                while (n4 < this.chart.getNumDatasets()) {
                    string = this.getLineFromURL(inputStream);
                    dArray2 = this.getVals(string);
                    this.chart.getDatasets()[n4].replaceYData(dArray2);
                    ++n4;
                }
            }
            this.closeURL(inputStream);
        }
        if ((string2 = this.getParameter("URLXYDataRows")) != null) {
            inputStream = this.openURL(string2);
            if (inputStream != null) {
                n4 = 0;
                while (n4 < this.chart.getNumDatasets()) {
                    string = this.getLineFromURL(inputStream);
                    object = this.getVals(string);
                    dArray = new double[((double[])object).length / 2];
                    dArray2 = new double[dArray.length];
                    n3 = 0;
                    n2 = 0;
                    while (n2 < ((double[])object).length) {
                        try {
                            dArray[n3] = object[n2];
                            dArray2[n3] = object[++n2];
                            ++n3;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            System.out.println("need same number of x & y observations in dataset " + n4);
                            return;
                        }
                        ++n2;
                    }
                    this.chart.getDatasets()[n4].replaceYData(dArray2);
                    this.chart.getDatasets()[n4].replaceXData(dArray);
                    ++n4;
                }
            }
            this.closeURL(inputStream);
        }
        if ((string2 = this.getParameter("URLXYDataColumns")) != null) {
            inputStream = this.openURL(string2);
            if (inputStream != null) {
                string = this.getLineFromURL(inputStream);
                n2 = Integer.parseInt(string.trim());
                n3 = this.chart.getNumDatasets() * 2;
                object = new double[n2][];
                dArray = new double[n2];
                dArray2 = new double[n2];
                n4 = 0;
                while (n4 < n2) {
                    string = this.getLineFromURL(inputStream);
                    object[n4] = (double)this.getVals(string);
                    ++n4;
                }
            } else {
                return;
            }
            this.closeURL(inputStream);
            n4 = 0;
            while (n4 < n3) {
                n = 0;
                while (n < n2) {
                    try {
                        dArray[n] = object[n][n4];
                        dArray2[n] = object[n][n4 + 1];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        System.out.println("need same number of x & y observations in column " + n4 + " and row " + n);
                        return;
                    }
                    ++n;
                }
                this.chart.getDatasets()[n4 / 2].replaceYData(dArray2);
                this.chart.getDatasets()[n4 / 2].replaceXData(dArray);
                n4 += 2;
            }
        }
        n4 = 0;
        while (n4 < this.chart.getNumDatasets()) {
            string2 = this.getParameter("dataset" + n4 + "xURL");
            if (string2 != null) {
                inputStream = this.openURL(string2);
                if (inputStream != null) {
                    string = this.getLineFromURL(inputStream);
                    dArray = this.getVals(string);
                    this.chart.getDatasets()[n4].replaceXData(dArray);
                }
                this.closeURL(inputStream);
            }
            if ((string2 = this.getParameter("dataset" + n4 + "yURL")) != null) {
                if (string2.equalsIgnoreCase("fake")) {
                    dArray2 = new double[5];
                    n = 0;
                    while (n < 5) {
                        dArray2[n] = 10.0 * Math.random();
                        ++n;
                    }
                    this.chart.getDatasets()[n4].replaceYData(dArray2);
                } else {
                    inputStream = this.openURL(string2);
                    if (inputStream != null) {
                        string = this.getLineFromURL(inputStream);
                        dArray2 = this.getVals(string);
                        this.chart.getDatasets()[n4].replaceYData(dArray2);
                        this.closeURL(inputStream);
                    }
                }
            }
            if ((string2 = this.getParameter("dataset" + n4 + "URLLabels")) != null && (inputStream = this.openURL(string2)) != null) {
                string = this.getLineFromURL(inputStream);
                String[] stringArray = this.getLabels(string);
                this.replaceDataLabels(n4, stringArray);
                this.closeURL(inputStream);
            }
            ++n4;
        }
    }

    protected boolean getURLDataset(int n) {
        int n2;
        String string;
        InputStream inputStream;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        String string2 = this.getParameter("dataset" + n + "xURL");
        if (string2 != null && (inputStream = this.openURL(string2)) != null) {
            string = this.getLineFromURL(inputStream);
            dArray = this.getVals(string);
            this.closeURL(inputStream);
        }
        if ((string2 = this.getParameter("dataset" + n + "yURL")) != null) {
            if (string2.equalsIgnoreCase("fake")) {
                dArray2 = new double[5];
                n2 = 0;
                while (n2 < 5) {
                    dArray2[n2] = 10.0 * Math.random();
                    ++n2;
                }
            } else {
                inputStream = this.openURL(string2);
                if (inputStream != null) {
                    string = this.getLineFromURL(inputStream);
                    dArray2 = this.getVals(string);
                    this.closeURL(inputStream);
                }
            }
        }
        if ((string2 = this.getParameter("dataset" + n + "y2URL")) != null) {
            if (string2.equalsIgnoreCase("fake")) {
                dArray2 = new double[5];
                n2 = 0;
                while (n2 < 5) {
                    dArray3[n2] = 10.0 * Math.random();
                    ++n2;
                }
            } else {
                inputStream = this.openURL(string2);
                if (inputStream != null) {
                    string = this.getLineFromURL(inputStream);
                    dArray3 = this.getVals(string);
                    this.closeURL(inputStream);
                }
            }
        }
        if ((string2 = this.getParameter("dataset" + n + "xyURL")) != null) {
            System.out.println("xyVals not supported yet");
        }
        return this.getDatasetParameters(n, dArray, dArray2, dArray3, null);
    }

    protected boolean getURLXYDataRows(String string) {
        String string2;
        InputStream inputStream;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        int n = 0;
        if (string != null) {
            inputStream = this.openURL(string);
            if (inputStream == null) {
                return false;
            }
        } else {
            return false;
        }
        this.gotDatasets = true;
        while ((string2 = this.getLineFromURL(inputStream)) != null) {
            dArray = this.getVals(string2);
            dArray2 = new double[dArray.length / 2];
            dArray3 = new double[dArray2.length];
            int n2 = 0;
            int n3 = 0;
            while (n3 < dArray.length) {
                try {
                    dArray2[n2] = dArray[n3];
                    dArray3[n2] = dArray[++n3];
                    ++n2;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.out.println("need same number of x & y observations in dataset " + n);
                    return false;
                }
                ++n3;
            }
            this.getDatasetParameters(n, dArray2, dArray3, null, null);
            ++n;
        }
        this.closeURL(inputStream);
        return true;
    }

    protected boolean getURLXYDataColumns(String string) {
        InputStream inputStream;
        double[] dArray = null;
        double[] dArray2 = null;
        if (string != null) {
            inputStream = this.openURL(string);
            if (inputStream == null) {
                return false;
            }
        } else {
            return false;
        }
        this.gotDatasets = true;
        String string2 = this.getLineFromURL(inputStream);
        int n = Integer.parseInt(string2.trim());
        double[][] dArray3 = new double[n][];
        dArray = new double[n];
        dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            string2 = this.getLineFromURL(inputStream);
            dArray3[n2] = this.getVals(string2);
            ++n2;
        }
        this.closeURL(inputStream);
        int n3 = dArray3[0].length;
        n2 = 0;
        while (n2 < n3) {
            int n4 = 0;
            while (n4 < n) {
                try {
                    dArray[n4] = dArray3[n4][n2];
                    dArray2[n4] = dArray3[n4][n2 + 1];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.out.println("need same number of x & y observations in column " + n2 + " and row " + n4);
                    return false;
                }
                ++n4;
            }
            this.getDatasetParameters(n2 / 2, dArray, dArray2, null, null);
            n2 += 2;
        }
        return true;
    }

    protected boolean getURLDataBlock(String string) {
        String string2;
        InputStream inputStream;
        double[] dArray = null;
        double[] dArray2 = null;
        int n = 0;
        if (string != null) {
            inputStream = this.openURL(string);
            if (inputStream == null) {
                return false;
            }
        } else {
            return false;
        }
        this.gotDatasets = true;
        while ((string2 = this.getLineFromURL(inputStream)) != null) {
            dArray2 = this.getVals(string2);
            this.getDatasetParameters(n, dArray, dArray2, null, null);
            ++n;
        }
        this.closeURL(inputStream);
        return true;
    }

    public boolean getDatasetParameters(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        String[] stringArray = null;
        String string = this.getParameter("dataset" + n + "Name");
        String string2 = string != null ? new String(string) : new String("dataset" + n);
        string = this.getParameter("dataset" + n + "Labels");
        if (string != null) {
            stringArray = this.getLabels(string);
        }
        if ((string = this.getParameter("dataset" + n + "URLLabels")) != null) {
            InputStream inputStream = this.openURL(string);
            if (inputStream != null) {
                string = this.getLineFromURL(inputStream);
                stringArray = this.getLabels(string);
            }
            this.closeURL(inputStream);
        }
        if (dArray4 != null && dArray3 != null && dArray2 != null) {
            this.chart.addDataSet(string2, dArray, dArray2, dArray3, dArray4);
        } else if (dArray3 != null && dArray2 != null && stringArray != null) {
            if (dArray == null) {
                this.chart.addDataSet(string2, dArray2, dArray3, stringArray);
            } else {
                this.chart.addDataSet(string2, dArray, dArray2, stringArray);
            }
        } else if (dArray3 != null && dArray2 != null && stringArray == null) {
            if (dArray == null) {
                this.chart.addDataSet(string2, dArray2, dArray3);
            } else {
                this.chart.addDataSet(string2, dArray, dArray2);
            }
        } else if (dArray2 != null) {
            if (stringArray != null) {
                if (dArray == null) {
                    this.chart.addDataSet(string2, dArray2, stringArray);
                } else {
                    this.chart.addDataSet(string2, dArray, dArray2, stringArray);
                }
            } else if (dArray == null) {
                this.chart.addDataSet(string2, dArray2);
            } else {
                this.chart.addDataSet(string2, dArray, dArray2);
            }
        }
        if (dArray2 == null) {
            return false;
        }
        string = this.getParameter("dataset" + n + "Color");
        if (string != null) {
            this.chart.getDatasets()[n].getGc().setFillColor(this.getColor(string));
            this.chart.getDatasets()[n].getGc().setLineColor(this.getColor(string));
        }
        if ((string = this.getParameter("dataset" + n + "Colors")) != null) {
            stringArray = this.getLabels(string);
            Dataset dataset = this.chart.getDatasets()[n];
            int n2 = 0;
            while (n2 < stringArray.length) {
                dataset.getDataElementAt(n2).getGc().setFillColor(this.getColor(stringArray[n2]));
                ++n2;
            }
        }
        if ((string = this.getParameter("dataset" + n + "LineWidth")) != null) {
            this.chart.getDatasets()[n].getGc().setLineWidth(Integer.parseInt(string));
        }
        if ((string = this.getParameter("dataset" + n + "LabelFont")) != null) {
            this.chart.getDatasets()[n].setLabelFont(this.getFont(string));
        }
        if ((string = this.getParameter("dataset" + n + "LabelColor")) != null) {
            this.chart.getDatasets()[n].setLabelColor(this.getColor(string));
        }
        if ((string = this.getParameter("dataset" + n + "Image")) != null) {
            this.chart.getDatasets()[n].getGc().setImage(this.makeURLImage(string));
        }
        return true;
    }

    protected void getAxisOptions() {
        this.parseAxOptions("yAxis", this.chart.getYAxis());
        this.parseAxOptions("xAxis", this.chart.getXAxis());
        String string = this.getParameter("xAxisLabels");
        if (string != null) {
            this.getXAxisLabels(string);
        }
    }

    private void parseAxOptions(String string, AxisInterface axisInterface) {
        String string2 = this.getParameter(String.valueOf(string) + "Options");
        if (string2 != null) {
            this.getAxisOptions(axisInterface, string2);
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "Start")) != null) {
            axisInterface.setAxisStart(Double.valueOf(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "End")) != null) {
            axisInterface.setAxisEnd(Double.valueOf(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LabelFont")) != null) {
            axisInterface.setLabelFont(this.getFont(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LabelAngle")) != null) {
            axisInterface.setLabelAngle(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LabelPrecision")) != null) {
            axisInterface.setLabelPrecision(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LabelFormat")) != null) {
            axisInterface.setLabelFormat(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "Color")) != null) {
            axisInterface.setLabelColor(this.getColor(string2));
            axisInterface.getLineGc().setLineColor(this.getColor(string2));
            axisInterface.getGridGc().setLineColor(this.getColor(string2));
            axisInterface.getTickGc().setLineColor(this.getColor(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LabelColor")) != null) {
            axisInterface.setLabelColor(this.getColor(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LineColor")) != null) {
            axisInterface.getLineGc().setLineColor(this.getColor(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "GridColor")) != null) {
            axisInterface.getGridGc().setLineColor(this.getColor(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "TickColor")) != null) {
            axisInterface.getTickGc().setLineColor(this.getColor(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "TickLength")) != null) {
            axisInterface.setMajTickLength(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "MinTickLength")) != null) {
            axisInterface.setMinTickLength(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "TickCount")) != null) {
            axisInterface.setNumMajTicks(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "MinTickCount")) != null) {
            axisInterface.setNumMinTicks(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "GridCount")) != null) {
            axisInterface.setNumGrids(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LabelCount")) != null) {
            axisInterface.setNumLabels(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "Title")) != null) {
            axisInterface.setTitleString(string2);
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "TitleColor")) != null) {
            axisInterface.setTitleColor(this.getColor(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "TitleFont")) != null) {
            axisInterface.setTitleFont(this.getFont(string2));
        }
    }

    protected void getAxisOptions(AxisInterface axisInterface, String string) {
        if (string.indexOf("logScaling") != -1) {
            axisInterface.setLogScaling(true);
        }
        if (string.indexOf("autoScale") != -1) {
            axisInterface.setAutoScale(true);
        }
        if (string.indexOf("noAutoScale") != -1) {
            axisInterface.setAutoScale(false);
        }
        if (string.indexOf("lineOn") != -1) {
            axisInterface.setLineVis(true);
        }
        if (string.indexOf("lineOff") != -1) {
            axisInterface.setLineVis(false);
        }
        if (string.indexOf("labelsOn") != -1) {
            axisInterface.setLabelVis(true);
        }
        if (string.indexOf("labelsOff") != -1) {
            axisInterface.setLabelVis(false);
        }
        if (string.indexOf("gridOn") != -1) {
            axisInterface.setGridVis(true);
        }
        if (string.indexOf("gridOff") != -1) {
            axisInterface.setGridVis(false);
        }
        if (string.indexOf("tickOn") != -1) {
            axisInterface.setMajTickVis(true);
        }
        if (string.indexOf("tickOff") != -1) {
            axisInterface.setMajTickVis(false);
        }
        if (string.indexOf("minTickOn") != -1) {
            axisInterface.setMinTickVis(true);
        }
        if (string.indexOf("minTickOff") != -1) {
            axisInterface.setMinTickVis(false);
        }
        if (string.indexOf("rightAxis") != -1) {
            axisInterface.setSide(3);
        }
        if (string.indexOf("leftAxis") != -1) {
            axisInterface.setSide(1);
        }
        if (string.indexOf("topAxis") != -1) {
            axisInterface.setSide(2);
        }
        if (string.indexOf("bottomAxis") != -1) {
            axisInterface.setSide(0);
        }
        if (string.indexOf("rotateTitle") != -1) {
            axisInterface.setTitleRotated(true);
        }
    }

    protected void getXAxisLabels(String string) {
        int n = 0;
        int n2 = 0;
        while (n != -1) {
            n = string.indexOf(this.delimiter, n + 1);
            ++n2;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        n = 0;
        while (n < n2 - 1) {
            int n4 = string.indexOf(this.delimiter, n3);
            stringArray[n] = string.substring(n3, n4);
            n3 = n4 + 1;
            ++n;
        }
        stringArray[n] = string.substring(n3);
        this.chart.getXAxis().addLabels(stringArray);
    }

    public void replaceDataLabels(int n, String[] stringArray) {
        Vector vector = this.chart.getDatasets()[n].getData();
        int n2 = 0;
        while (n2 < vector.size()) {
            Datum datum = (Datum)vector.elementAt(n2);
            try {
                datum.setLabel(stringArray[n2]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            ++n2;
        }
    }

    public void getMyDatasets(String string) {
    }

    public void getMyOptions() {
        this.getAxisOptions();
    }
}

