/*
 * Decompiled with CFR 0.152.
 */
package javachart.servlet;

import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Enumeration;
import javachart.chart.ChartInterface;
import javachart.chart.RotateString;
import javachart.utility.GifMaker;
import javax.servlet.http.HttpServletRequest;

class CacheManager {
    GifMaker gifMaker;
    ChartInterface chart;
    private HttpServletRequest request;
    private String fileName;
    private int imageWidth = 200;
    private int imageHeight = 150;
    private String pub_dir = "public_html";
    private String file_location = "images";
    private String parentString;
    private boolean useCache = true;

    public CacheManager(HttpServletRequest httpServletRequest, Object object) {
        this.setRequest(httpServletRequest);
        this.parentString = object.toString();
    }

    void setRequest(HttpServletRequest httpServletRequest) {
        this.request = httpServletRequest;
        String string = httpServletRequest.getParameter("pub_dir");
        if (string != null) {
            this.pub_dir = string;
        }
        if ((string = httpServletRequest.getParameter("useCache")) != null) {
            this.useCache = string.equalsIgnoreCase("true");
        }
        if ((string = httpServletRequest.getParameter("file_location")) != null) {
            this.file_location = string;
        }
        if ((string = this.getParameter("width")) != null) {
            this.imageWidth = Integer.parseInt(string);
        }
        if ((string = this.getParameter("height")) != null) {
            this.imageHeight = Integer.parseInt(string);
        }
    }

    String getImageName() {
        Object object;
        if (this.request == null) {
            System.out.println("CacheManager: must set request before retrieving name");
            return null;
        }
        if (this.fileName != null) {
            return String.valueOf(this.file_location) + "/" + this.fileName;
        }
        Enumeration enumeration = this.request.getParameterNames();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parentString);
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            stringBuffer.append((String)object);
            stringBuffer.append(this.getParameter((String)object));
        }
        try {
            object = MessageDigest.getInstance("SHA");
            ((MessageDigest)object).digest(stringBuffer.toString().getBytes());
            this.fileName = ((MessageDigest)object).toString();
            this.fileName = String.valueOf(this.fileName.substring(this.fileName.indexOf("<") + 1, this.fileName.indexOf(">") - 1)) + ".gif";
        }
        catch (Exception exception) {
            System.out.println("CacheManager: message digest problem");
        }
        return String.valueOf(this.file_location) + "/" + this.fileName;
    }

    boolean isCached() {
        if (this.request == null) {
            return false;
        }
        if (!this.useCache) {
            return false;
        }
        String string = String.valueOf(this.pub_dir) + "/" + this.getImageName();
        if (string == null) {
            return false;
        }
        File file = new File(string);
        return file.exists() && file.canRead();
    }

    protected void generate() {
        if (this.chart == null) {
            return;
        }
        Frame frame = new Frame();
        frame.addNotify();
        Image image = frame.createImage(this.imageWidth, this.imageHeight);
        Graphics graphics = image.getGraphics();
        this.chart.resize(this.imageWidth, this.imageHeight);
        this.chart.setStringRotator(new RotateString(frame));
        this.chart.setImage(image);
        this.chart.drawGraph(graphics);
        try {
            try {
                this.writeOutput(image);
            }
            catch (Exception exception) {
                System.out.println("JavaChart couldn't write image");
            }
            Object var5_4 = null;
            graphics.dispose();
            ((Container)frame).removeNotify();
            return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            graphics.dispose();
            ((Container)frame).removeNotify();
            throw throwable;
        }
    }

    public void getImageBytes(OutputStream outputStream) {
        try {
            File file = new File(String.valueOf(this.pub_dir) + "/" + this.getImageName());
            FileInputStream fileInputStream = new FileInputStream(file);
            long l = file.length();
            byte[] byArray = new byte[(int)l];
            fileInputStream.read(byArray);
            outputStream.write(byArray);
            return;
        }
        catch (Exception exception) {
            System.out.println("problem retrieving image bytes: " + exception.getMessage());
            return;
        }
    }

    private void writeOutput(Image image) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(this.pub_dir) + "/" + this.getImageName());
        GifMaker gifMaker = new GifMaker(fileOutputStream, image);
        gifMaker.write();
        fileOutputStream.close();
    }

    protected String getParameter(String string) {
        return this.request.getParameter(string);
    }
}

