/*
 * Decompiled with CFR 0.152.
 */
package javachart.contrib;

import java.awt.Graphics;
import javachart.chart.Axis;
import javachart.chart.AxisInterface;
import javachart.chart.Dataset;
import javachart.chart.Line;
import javachart.chart.LineChart;

public class TwinAxisChart
extends LineChart {
    AxisInterface auxYAxis;
    Line auxLine;
    Dataset[] rightDatasets;
    boolean[] dataOnRight;

    private void allocateDatasets() {
        int n = 0;
        int n2 = 0;
        Dataset[] datasetArray = new Dataset[20];
        int n3 = 0;
        while (n3 < 20) {
            if (this.dataOnRight[n3]) {
                this.rightDatasets[n2] = this.getDatasets()[n3];
                ++n2;
            } else {
                datasetArray[n] = this.getDatasets()[n3];
                ++n;
            }
            ++n3;
        }
        this.getYAxis().setDatasets(datasetArray);
        this.auxYAxis.setDatasets(this.rightDatasets);
        this.getLine().setDatasets(datasetArray);
    }

    public synchronized void assignToRightAxis(int n, boolean bl) {
        this.dataOnRight[n] = bl;
    }

    public void drawGraph(Graphics graphics) {
        this.allocateDatasets();
        this.getBackground().draw(graphics);
        this.getPlotarea().draw(graphics);
        if (this.isXAxisVisible()) {
            this.getXAxis().draw(graphics);
        }
        if (this.isYAxisVisible()) {
            this.getYAxis().draw(graphics);
        }
        if (this.isLegendVisible()) {
            this.getLegend().draw(graphics);
        }
        this.auxYAxis.draw(graphics);
        this.getLine().draw(graphics);
        this.auxLine.draw(graphics);
    }

    public AxisInterface getAuxAxis() {
        return this.auxYAxis;
    }

    public Line getAuxLine() {
        return this.auxLine;
    }

    protected void initAxes() {
        super.initAxes();
        this.rightDatasets = new Dataset[20];
        this.dataOnRight = new boolean[20];
        int n = 0;
        while (n < 20) {
            this.dataOnRight[n] = false;
            ++n;
        }
        this.auxYAxis = new Axis(this.rightDatasets, false, this.getPlotarea());
        this.auxYAxis.setSide(3);
        this.auxLine = new Line(this.rightDatasets, this.getXAxis(), this.auxYAxis, this.getPlotarea());
    }
}

